/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler.quartz;

import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerListener;

public class MissedTriggerListener
implements TriggerListener {
    public static String NAME = "MissedTriggerListener";
    private static final Logger logger = Logger.getLogger(MissedTriggerListener.class);

    public String getName() {
        return NAME;
    }

    public void triggerComplete(Trigger trigger, JobExecutionContext jobExecutionContext, int n) {
    }

    public void triggerFired(Trigger trigger, JobExecutionContext jobExecutionContext) {
    }

    public void triggerMisfired(Trigger trigger) {
        logger.info((Object)("Got misfire notification for trigger: " + trigger.getName() + " | job: " + trigger.getJobName()));
        int n = this.getMisFireCount(trigger);
        Date date = trigger.getNextFireTime();
        logger.debug((Object)("Start date for missed triggers: " + date.toString()));
        for (int i = 0; i < n && date != null; ++i) {
            logger.info((Object)("Misfire at: " + date.toString()));
            date = trigger.getFireTimeAfter(date);
        }
    }

    private Calendar resetDate(Calendar calendar) {
        calendar.set(2, 1);
        calendar.set(5, 1);
        calendar.set(1, 1970);
        return calendar;
    }

    public boolean vetoJobExecution(Trigger trigger, JobExecutionContext jobExecutionContext) {
        return false;
    }

    private int getMisFireCount(Trigger trigger) {
        int n = 0;
        if (trigger.getPreviousFireTime() != null) {
            int n2 = ((SimpleTrigger)trigger).computeNumTimesFiredBetween(trigger.getStartTime(), new Date());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(trigger.getStartTime());
            calendar = this.resetDate(calendar);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(new Date());
            calendar2 = this.resetDate(calendar2);
            if (calendar.before(calendar2)) {
                ++n2;
            }
            int n3 = ((SimpleTrigger)trigger).getTimesTriggered();
            n = n2 - n3;
        } else if (((SimpleTrigger)trigger).getTimesTriggered() == 0) {
            n = ((SimpleTrigger)trigger).computeNumTimesFiredBetween(trigger.getStartTime(), new Date()) + 1;
        } else {
            Date date;
            int n4 = ((SimpleTrigger)trigger).getTimesTriggered();
            Date date2 = date = trigger.getStartTime();
            for (int i = 0; i < n4 - 1; ++i) {
                date = date2 = ((SimpleTrigger)trigger).getFireTimeAfter(date);
            }
            n = ((SimpleTrigger)trigger).computeNumTimesFiredBetween(date2, new Date());
        }
        logger.debug((Object)("Job[" + trigger.getJobName() + "] was missed " + n + " time(s)."));
        return n;
    }
}

