/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler.quartz;

import com.ericsson.cms.scheduler.ScheduleTime;
import com.ericsson.cms.scheduler.quartz.MissedTriggerListener;
import com.ericsson.cms.scheduler.quartz.QuartzCallback;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzScheduler {
    private static final Logger logger = Logger.getLogger(QuartzScheduler.class);
    private static final String JOB_GROUP_NAME = "CMS";
    private static final String TRIGGER_GROUP_NAME = "CMS";
    private static final String TRIGGER_PREFIX = "TRIGGER_";
    private static final String JOB_PROPERTIES_FILENAME = "quartz-upgrade.properties";
    private Scheduler scheduler;

    public void start() {
        Object object;
        try {
            object = new StdSchedulerFactory(JOB_PROPERTIES_FILENAME);
            this.scheduler = object.getScheduler();
        }
        catch (SchedulerException schedulerException) {
            throw new RuntimeException("Error while getting/starting com.ericsson.cms.scheduler: ", schedulerException);
        }
        if (this.scheduler == null) {
            object = "Could not get com.ericsson.cms.scheduler from quartz com.ericsson.cms.scheduler factory.";
            throw new RuntimeException((String)object);
        }
        try {
            if (this.scheduler.getTriggerListener(MissedTriggerListener.NAME) == null) {
                logger.debug((Object)"Missed trigger listener added");
                object = new MissedTriggerListener();
                this.scheduler.addTriggerListener((TriggerListener)object);
            }
            this.scheduler.start();
            logger.debug((Object)"There you go. Started the Quartz standard com.ericsson.cms.scheduler.");
        }
        catch (SchedulerException schedulerException) {
            logger.error((Object)"Exception while starting the quartz scheduler", (Throwable)schedulerException);
        }
    }

    public void stop() {
        try {
            if (this.scheduler != null) {
                this.scheduler.shutdown(true);
                this.scheduler = null;
            }
        }
        catch (SchedulerException schedulerException) {
            logger.error((Object)("Failure stopping quartz scheduler, error: " + schedulerException.getLocalizedMessage()), (Throwable)schedulerException);
        }
    }

    public void schedule(long l, ScheduleTime scheduleTime) {
        String string = String.valueOf(l);
        try {
            SimpleTrigger simpleTrigger;
            JobDetail jobDetail = new JobDetail(string, "CMS", QuartzCallback.class);
            jobDetail.setDurability(true);
            jobDetail.setRequestsRecovery(true);
            jobDetail.setVolatility(true);
            String string2 = TRIGGER_PREFIX + string;
            if (scheduleTime.isPeriodic()) {
                logger.debug((Object)("Setting a periodic job starting at: " + scheduleTime.getStartDate() + " every " + scheduleTime.getRepeatInterval() + " msec."));
                simpleTrigger = new SimpleTrigger(string2, "CMS", string, "CMS", scheduleTime.getStartDate(), scheduleTime.getEndDate(), SimpleTrigger.REPEAT_INDEFINITELY, scheduleTime.getRepeatInterval());
            } else {
                logger.debug((Object)("Setting a one time job for date: " + scheduleTime.getStartDate()));
                simpleTrigger = new SimpleTrigger(string2, "CMS", scheduleTime.getStartDate());
                simpleTrigger.setJobName(string);
                simpleTrigger.setJobGroup("CMS");
            }
            simpleTrigger.setMisfireInstruction(4);
            simpleTrigger.setVolatility(true);
            simpleTrigger.addTriggerListener(MissedTriggerListener.NAME);
            this.scheduler.addJob(jobDetail, true);
            this.scheduler.scheduleJob((Trigger)simpleTrigger);
            logger.debug((Object)("Done scheduling job: " + jobDetail.getName()));
        }
        catch (Exception exception) {
            throw new RuntimeException("Error while scheduling: " + string + ":", exception);
        }
    }

    public void deleteSchedule(long l) {
        String string = String.valueOf(l);
        try {
            if (this.scheduler.getJobDetail(string, "CMS") == null) {
                String string2 = "Scheduler did not find job: " + string + " hence cannot delete it.";
                throw new RuntimeException(string2);
            }
            this.scheduler.deleteJob(string, "CMS");
            logger.debug((Object)("Done deleting job: " + string));
        }
        catch (SchedulerException schedulerException) {
            throw new RuntimeException("Error while deleting job: " + string + ":", schedulerException);
        }
    }

    public void updateSchedule(long l, ScheduleTime scheduleTime) {
        try {
            this.deleteSchedule(l);
            this.schedule(l, scheduleTime);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error while updating job schedule: ", exception);
        }
    }

    public List<Date> getFutureExecutions(long l, Date date, int n) {
        ArrayList<Date> arrayList = new ArrayList<Date>();
        String string = String.valueOf(l);
        try {
            JobDetail jobDetail = this.scheduler.getJobDetail(string, "CMS");
            if (jobDetail != null) {
                Date date2;
                String string2 = TRIGGER_PREFIX + string;
                Trigger trigger = this.scheduler.getTrigger(string2, "CMS");
                if (trigger == null) {
                    return arrayList;
                }
                Date date3 = this.add(date, n);
                while ((date2 = trigger.getFireTimeAfter(date)) != null && !date2.after(date3)) {
                    arrayList.add(date2);
                    date = date2;
                }
                return arrayList;
            }
            String string3 = "Scheduler did not find job: " + string;
            throw new RuntimeException(string3);
        }
        catch (SchedulerException schedulerException) {
            throw new RuntimeException("Error while getting future executions of job: " + string + ":", schedulerException);
        }
    }

    public String[] getAllJobs() {
        try {
            return this.scheduler.getJobNames("CMS");
        }
        catch (SchedulerException schedulerException) {
            throw new RuntimeException(schedulerException);
        }
    }

    public String getJobInfo(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Trigger trigger = this.scheduler.getTrigger(TRIGGER_PREFIX + string, "CMS");
            if (trigger == null) {
                return "No trigger Found.";
            }
            stringBuilder.append("Trigger - ");
            stringBuilder.append("Start Time: " + trigger.getStartTime());
            stringBuilder.append(" End Time: " + trigger.getEndTime());
            stringBuilder.append(" Previous Fire Time: " + trigger.getPreviousFireTime());
            stringBuilder.append(" Next Fire Time: " + trigger.getNextFireTime());
            stringBuilder.append(" Final Fire Time: " + trigger.getFinalFireTime());
            return stringBuilder.toString();
        }
        catch (SchedulerException schedulerException) {
            throw new RuntimeException(schedulerException);
        }
    }

    public void printAllJobs() {
        try {
            String[] stringArray = this.scheduler.getJobNames("CMS");
            if (stringArray != null) {
                for (String string : stringArray) {
                    System.out.println(string);
                }
            }
        }
        catch (SchedulerException schedulerException) {
            throw new RuntimeException(schedulerException);
        }
    }

    private Date add(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(10, n);
        return calendar.getTime();
    }
}

