/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.core.SchedulingContext;
import org.quartz.impl.jdbcjobstore.AttributeRestoringConnectionInvocationHandler;
import org.quartz.impl.jdbcjobstore.Constants;
import org.quartz.impl.jdbcjobstore.DriverDelegate;
import org.quartz.impl.jdbcjobstore.FiredTriggerRecord;
import org.quartz.impl.jdbcjobstore.InvalidConfigurationException;
import org.quartz.impl.jdbcjobstore.LockException;
import org.quartz.impl.jdbcjobstore.NoSuchDelegateException;
import org.quartz.impl.jdbcjobstore.SchedulerStateRecord;
import org.quartz.impl.jdbcjobstore.Semaphore;
import org.quartz.impl.jdbcjobstore.SimpleSemaphore;
import org.quartz.impl.jdbcjobstore.StdRowLockSemaphore;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.JobStore;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.utils.DBConnectionManager;
import org.quartz.utils.Key;
import org.quartz.utils.TriggerStatus;

public abstract class JobStoreSupport
implements JobStore,
Constants {
    protected static String LOCK_TRIGGER_ACCESS = "TRIGGER_ACCESS";
    protected static String LOCK_JOB_ACCESS = "JOB_ACCESS";
    protected static String LOCK_CALENDAR_ACCESS = "CALENDAR_ACCESS";
    protected static String LOCK_STATE_ACCESS = "STATE_ACCESS";
    protected static String LOCK_MISFIRE_ACCESS = "MISFIRE_ACCESS";
    protected String dsName;
    protected String tablePrefix = "QRTZ_";
    protected boolean useProperties = false;
    protected String instanceId;
    protected String instanceName;
    protected String delegateClassName;
    protected Class delegateClass = class$org$quartz$impl$jdbcjobstore$StdJDBCDelegate == null ? (class$org$quartz$impl$jdbcjobstore$StdJDBCDelegate = JobStoreSupport.class$("org.quartz.impl.jdbcjobstore.StdJDBCDelegate")) : class$org$quartz$impl$jdbcjobstore$StdJDBCDelegate;
    protected HashMap calendarCache = new HashMap();
    private DriverDelegate delegate;
    private long misfireThreshold = 60000L;
    private boolean dontSetAutoCommitFalse = false;
    private boolean isClustered = false;
    private boolean useDBLocks = false;
    private boolean lockOnInsert = true;
    private Semaphore lockHandler = null;
    private String selectWithLockSQL = null;
    private long clusterCheckinInterval = 7500L;
    private ClusterManager clusterManagementThread = null;
    private MisfireHandler misfireHandler = null;
    private ClassLoadHelper classLoadHelper;
    private SchedulerSignaler signaler;
    protected int maxToRecoverAtATime = 20;
    private boolean setTxIsolationLevelSequential = false;
    private long dbRetryInterval = 10000L;
    private boolean makeThreadsDaemons = false;
    private boolean doubleCheckLockMisfireHandler = true;
    private final Log log = LogFactory.getLog(this.getClass());
    private static long ftrCtr = System.currentTimeMillis();
    protected boolean firstCheckIn = true;
    protected long lastCheckin = System.currentTimeMillis();
    static /* synthetic */ Class class$org$quartz$impl$jdbcjobstore$StdJDBCDelegate;
    static /* synthetic */ Class class$java$sql$Connection;
    static /* synthetic */ Class class$org$quartz$SimpleTrigger;
    static /* synthetic */ Class class$org$quartz$CronTrigger;
    static /* synthetic */ Class class$org$apache$commons$logging$Log;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public void setDataSource(String dsName) {
        this.dsName = dsName;
    }

    public String getDataSource() {
        return this.dsName;
    }

    public void setTablePrefix(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        this.tablePrefix = prefix;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setUseProperties(String useProp) {
        if (useProp == null) {
            useProp = "false";
        }
        this.useProperties = Boolean.valueOf(useProp);
    }

    public boolean canUseProperties() {
        return this.useProperties;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setIsClustered(boolean isClustered) {
        this.isClustered = isClustered;
    }

    public boolean isClustered() {
        return this.isClustered;
    }

    public long getClusterCheckinInterval() {
        return this.clusterCheckinInterval;
    }

    public void setClusterCheckinInterval(long l) {
        this.clusterCheckinInterval = l;
    }

    public int getMaxMisfiresToHandleAtATime() {
        return this.maxToRecoverAtATime;
    }

    public void setMaxMisfiresToHandleAtATime(int maxToRecoverAtATime) {
        this.maxToRecoverAtATime = maxToRecoverAtATime;
    }

    public long getDbRetryInterval() {
        return this.dbRetryInterval;
    }

    public void setDbRetryInterval(long dbRetryInterval) {
        this.dbRetryInterval = dbRetryInterval;
    }

    public void setUseDBLocks(boolean useDBLocks) {
        this.useDBLocks = useDBLocks;
    }

    public boolean getUseDBLocks() {
        return this.useDBLocks;
    }

    public boolean isLockOnInsert() {
        return this.lockOnInsert;
    }

    public void setLockOnInsert(boolean lockOnInsert) {
        this.lockOnInsert = lockOnInsert;
    }

    public long getMisfireThreshold() {
        return this.misfireThreshold;
    }

    public void setMisfireThreshold(long misfireThreshold) {
        if (misfireThreshold < 1L) {
            throw new IllegalArgumentException("Misfirethreshold must be larger than 0");
        }
        this.misfireThreshold = misfireThreshold;
    }

    public boolean isDontSetAutoCommitFalse() {
        return this.dontSetAutoCommitFalse;
    }

    public void setDontSetAutoCommitFalse(boolean b) {
        this.dontSetAutoCommitFalse = b;
    }

    public boolean isTxIsolationLevelSerializable() {
        return this.setTxIsolationLevelSequential;
    }

    public void setTxIsolationLevelSerializable(boolean b) {
        this.setTxIsolationLevelSequential = b;
    }

    public void setDriverDelegateClass(String delegateClassName) throws InvalidConfigurationException {
        this.delegateClassName = delegateClassName;
    }

    public String getDriverDelegateClass() {
        return this.delegateClassName;
    }

    public String getSelectWithLockSQL() {
        return this.selectWithLockSQL;
    }

    public void setSelectWithLockSQL(String string) {
        this.selectWithLockSQL = string;
    }

    protected ClassLoadHelper getClassLoadHelper() {
        return this.classLoadHelper;
    }

    public boolean getMakeThreadsDaemons() {
        return this.makeThreadsDaemons;
    }

    public void setMakeThreadsDaemons(boolean makeThreadsDaemons) {
        this.makeThreadsDaemons = makeThreadsDaemons;
    }

    public boolean getDoubleCheckLockMisfireHandler() {
        return this.doubleCheckLockMisfireHandler;
    }

    public void setDoubleCheckLockMisfireHandler(boolean doubleCheckLockMisfireHandler) {
        this.doubleCheckLockMisfireHandler = doubleCheckLockMisfireHandler;
    }

    protected Log getLog() {
        return this.log;
    }

    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        if (this.dsName == null) {
            throw new SchedulerConfigException("DataSource name not set.");
        }
        this.classLoadHelper = loadHelper;
        this.signaler = signaler;
        if (this.getLockHandler() == null) {
            if (this.isClustered()) {
                this.setUseDBLocks(true);
            }
            if (this.getUseDBLocks()) {
                this.getLog().info((Object)"Using db table-based data access locking (synchronization).");
                this.setLockHandler(new StdRowLockSemaphore(this.getTablePrefix(), this.getSelectWithLockSQL()));
            } else {
                this.getLog().info((Object)"Using thread monitor-based data access locking (synchronization).");
                this.setLockHandler(new SimpleSemaphore());
            }
        }
        if (!this.isClustered()) {
            try {
                this.cleanVolatileTriggerAndJobs();
            }
            catch (SchedulerException se) {
                throw new SchedulerConfigException("Failure occured during job recovery.", se);
            }
        }
    }

    public void schedulerStarted() throws SchedulerException {
        if (this.isClustered()) {
            this.clusterManagementThread = new ClusterManager();
            this.clusterManagementThread.initialize();
        } else {
            try {
                this.recoverJobs();
            }
            catch (SchedulerException se) {
                throw new SchedulerConfigException("Failure occured during job recovery.", se);
            }
        }
        this.misfireHandler = new MisfireHandler();
        this.misfireHandler.initialize();
    }

    public void shutdown() {
        if (this.clusterManagementThread != null) {
            this.clusterManagementThread.shutdown();
        }
        if (this.misfireHandler != null) {
            this.misfireHandler.shutdown();
        }
        try {
            DBConnectionManager.getInstance().shutdown(this.getDataSource());
        }
        catch (SQLException sqle) {
            this.getLog().warn((Object)"Database connection shutdown unsuccessful.", (Throwable)sqle);
        }
    }

    public boolean supportsPersistence() {
        return true;
    }

    protected abstract Connection getNonManagedTXConnection() throws JobPersistenceException;

    protected Connection getAttributeRestoringConnection(Connection conn) {
        return (Connection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{class$java$sql$Connection == null ? (class$java$sql$Connection = JobStoreSupport.class$("java.sql.Connection")) : class$java$sql$Connection}, (InvocationHandler)new AttributeRestoringConnectionInvocationHandler(conn));
    }

    protected Connection getConnection() throws JobPersistenceException {
        Connection conn = null;
        try {
            conn = DBConnectionManager.getInstance().getConnection(this.getDataSource());
        }
        catch (SQLException sqle) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getDataSource() + "': " + sqle.toString(), sqle);
        }
        catch (Throwable e) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getDataSource() + "': " + e.toString(), e, 499);
        }
        if (conn == null) {
            throw new JobPersistenceException("Could not get connection from DataSource '" + this.getDataSource() + "'");
        }
        conn = this.getAttributeRestoringConnection(conn);
        try {
            if (!this.isDontSetAutoCommitFalse()) {
                conn.setAutoCommit(false);
            }
            if (this.isTxIsolationLevelSerializable()) {
                conn.setTransactionIsolation(8);
            }
        }
        catch (SQLException sqle) {
            this.getLog().warn((Object)"Failed to override connection auto commit/transaction isolation.", (Throwable)sqle);
        }
        catch (Throwable e) {
            try {
                conn.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new JobPersistenceException("Failure setting up connection.", e);
        }
        return conn;
    }

    protected void releaseLock(Connection conn, String lockName, boolean doIt) {
        if (doIt && conn != null) {
            try {
                this.getLockHandler().releaseLock(conn, lockName);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
    }

    protected void cleanVolatileTriggerAndJobs() throws JobPersistenceException {
        this.executeInNonManagedTXLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            public void execute(Connection conn) throws JobPersistenceException {
                JobStoreSupport.this.cleanVolatileTriggerAndJobs(conn);
            }
        });
    }

    protected void cleanVolatileTriggerAndJobs(Connection conn) throws JobPersistenceException {
        try {
            int i;
            Key[] volatileTriggers = this.getDelegate().selectVolatileTriggers(conn);
            Key[] volatileJobs = this.getDelegate().selectVolatileJobs(conn);
            for (i = 0; i < volatileTriggers.length; ++i) {
                this.removeTrigger(conn, null, volatileTriggers[i].getName(), volatileTriggers[i].getGroup());
            }
            this.getLog().info((Object)("Removed " + volatileTriggers.length + " Volatile Trigger(s)."));
            for (i = 0; i < volatileJobs.length; ++i) {
                this.removeJob(conn, null, volatileJobs[i].getName(), volatileJobs[i].getGroup(), true);
            }
            this.getLog().info((Object)("Removed " + volatileJobs.length + " Volatile Job(s)."));
            this.getDelegate().deleteVolatileFiredTriggers(conn);
        }
        catch (Exception e) {
            throw new JobPersistenceException("Couldn't clean volatile data: " + e.getMessage(), e);
        }
    }

    protected void recoverJobs() throws JobPersistenceException {
        this.executeInNonManagedTXLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            public void execute(Connection conn) throws JobPersistenceException {
                JobStoreSupport.this.recoverJobs(conn);
            }
        });
    }

    protected void recoverJobs(Connection conn) throws JobPersistenceException {
        try {
            int rows = this.getDelegate().updateTriggerStatesFromOtherStates(conn, "WAITING", "ACQUIRED", "BLOCKED");
            this.getLog().info((Object)("Freed " + (rows += this.getDelegate().updateTriggerStatesFromOtherStates(conn, "PAUSED", "PAUSED_BLOCKED", "PAUSED_BLOCKED")) + " triggers from 'acquired' / 'blocked' state."));
            this.recoverMisfiredJobs(conn, true);
            Trigger[] recoveringJobTriggers = this.getDelegate().selectTriggersForRecoveringJobs(conn);
            this.getLog().info((Object)("Recovering " + recoveringJobTriggers.length + " jobs that were in-progress at the time of the last shut-down."));
            for (int i = 0; i < recoveringJobTriggers.length; ++i) {
                if (!this.jobExists(conn, recoveringJobTriggers[i].getJobName(), recoveringJobTriggers[i].getJobGroup())) continue;
                recoveringJobTriggers[i].computeFirstFireTime(null);
                this.storeTrigger(conn, null, recoveringJobTriggers[i], null, false, "WAITING", false, true);
            }
            this.getLog().info((Object)"Recovery complete.");
            Key[] ct = this.getDelegate().selectTriggersInState(conn, "COMPLETE");
            for (int i = 0; ct != null && i < ct.length; ++i) {
                this.removeTrigger(conn, null, ct[i].getName(), ct[i].getGroup());
            }
            this.getLog().info((Object)("Removed " + ct.length + " 'complete' triggers."));
            int n = this.getDelegate().deleteFiredTriggers(conn);
            this.getLog().info((Object)("Removed " + n + " stale fired job entries."));
        }
        catch (JobPersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobPersistenceException("Couldn't recover jobs: " + e.getMessage(), e);
        }
    }

    protected long getMisfireTime() {
        long misfireTime = System.currentTimeMillis();
        if (this.getMisfireThreshold() > 0L) {
            misfireTime -= this.getMisfireThreshold();
        }
        return misfireTime > 0L ? misfireTime : 0L;
    }

    protected RecoverMisfiredJobsResult recoverMisfiredJobs(Connection conn, boolean recovering) throws JobPersistenceException, SQLException {
        int maxMisfiresToHandleAtATime = recovering ? -1 : this.getMaxMisfiresToHandleAtATime();
        ArrayList misfiredTriggers = new ArrayList();
        boolean hasMoreMisfiredTriggers = this.getDelegate().selectMisfiredTriggersInStates(conn, "MISFIRED", "WAITING", this.getMisfireTime(), maxMisfiresToHandleAtATime, misfiredTriggers);
        if (hasMoreMisfiredTriggers) {
            this.getLog().info((Object)("Handling the first " + misfiredTriggers.size() + " triggers that missed their scheduled fire-time.  " + "More misfired triggers remain to be processed."));
        } else if (misfiredTriggers.size() > 0) {
            this.getLog().info((Object)("Handling " + misfiredTriggers.size() + " trigger(s) that missed their scheduled fire-time."));
        } else {
            this.getLog().debug((Object)"Found 0 triggers that missed their scheduled fire-time.");
            return RecoverMisfiredJobsResult.NO_OP;
        }
        Iterator misfiredTriggerIter = misfiredTriggers.iterator();
        while (misfiredTriggerIter.hasNext()) {
            Key triggerKey = (Key)misfiredTriggerIter.next();
            Trigger trig = this.retrieveTrigger(conn, triggerKey.getName(), triggerKey.getGroup());
            if (trig == null) continue;
            this.doUpdateOfMisfiredTrigger(conn, null, trig, false, "WAITING", recovering);
        }
        return new RecoverMisfiredJobsResult(hasMoreMisfiredTriggers, misfiredTriggers.size());
    }

    protected boolean updateMisfiredTrigger(Connection conn, SchedulingContext ctxt, String triggerName, String groupName, String newStateIfNotComplete, boolean forceState) throws JobPersistenceException {
        try {
            Trigger trig = this.getDelegate().selectTrigger(conn, triggerName, groupName);
            long misfireTime = System.currentTimeMillis();
            if (this.getMisfireThreshold() > 0L) {
                misfireTime -= this.getMisfireThreshold();
            }
            if (trig.getNextFireTime().getTime() > misfireTime) {
                return false;
            }
            this.doUpdateOfMisfiredTrigger(conn, ctxt, trig, forceState, newStateIfNotComplete, false);
            return true;
        }
        catch (Exception e) {
            throw new JobPersistenceException("Couldn't update misfired trigger '" + groupName + "." + triggerName + "': " + e.getMessage(), e);
        }
    }

    private void doUpdateOfMisfiredTrigger(Connection conn, SchedulingContext ctxt, Trigger trig, boolean forceState, String newStateIfNotComplete, boolean recovering) throws JobPersistenceException {
        Calendar cal = null;
        if (trig.getCalendarName() != null) {
            cal = this.retrieveCalendar(conn, ctxt, trig.getCalendarName());
        }
        this.signaler.notifyTriggerListenersMisfired(trig);
        trig.updateAfterMisfire(cal);
        if (trig.getNextFireTime() == null) {
            this.storeTrigger(conn, ctxt, trig, null, true, "COMPLETE", forceState, recovering);
        } else {
            this.storeTrigger(conn, ctxt, trig, null, true, newStateIfNotComplete, forceState, false);
        }
    }

    public void storeJobAndTrigger(final SchedulingContext ctxt, final JobDetail newJob, final Trigger newTrigger) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.executeInLock(this.isLockOnInsert() ? LOCK_TRIGGER_ACCESS : null, new VoidTransactionCallback(){

            public void execute(Connection conn) throws JobPersistenceException {
                if (newJob.isVolatile() && !newTrigger.isVolatile()) {
                    JobPersistenceException jpe = new JobPersistenceException("Cannot associate non-volatile trigger with a volatile job!");
                    jpe.setErrorCode(100);
                    throw jpe;
                }
                JobStoreSupport.this.storeJob(conn, ctxt, newJob, false);
                JobStoreSupport.this.storeTrigger(conn, ctxt, newTrigger, newJob, false, "WAITING", false, false);
            }
        });
    }

    public void storeJob(final SchedulingContext ctxt, final JobDetail newJob, final boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.executeInLock(this.isLockOnInsert() || replaceExisting ? LOCK_TRIGGER_ACCESS : null, new VoidTransactionCallback(){

            public void execute(Connection conn) throws JobPersistenceException {
                JobStoreSupport.this.storeJob(conn, ctxt, newJob, replaceExisting);
            }
        });
    }

    protected void storeJob(Connection conn, SchedulingContext ctxt, JobDetail newJob, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        if (newJob.isVolatile() && this.isClustered()) {
            this.getLog().info((Object)"note: volatile jobs are effectively non-volatile in a clustered environment.");
        }
        boolean existingJob = this.jobExists(conn, newJob.getName(), newJob.getGroup());
        try {
            if (existingJob) {
                if (!replaceExisting) {
                    throw new ObjectAlreadyExistsException(newJob);
                }
                this.getDelegate().updateJobDetail(conn, newJob);
            } else {
                this.getDelegate().insertJobDetail(conn, newJob);
            }
        }
        catch (IOException e) {
            throw new JobPersistenceException("Couldn't store job: " + e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't store job: " + e.getMessage(), e);
        }
    }

    protected boolean jobExists(Connection conn, String jobName, String groupName) throws JobPersistenceException {
        try {
            return this.getDelegate().jobExists(conn, jobName, groupName);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't determine job existence (" + groupName + "." + jobName + "): " + e.getMessage(), e);
        }
    }

    public void storeTrigger(final SchedulingContext ctxt, final Trigger newTrigger, final boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.executeInLock(this.isLockOnInsert() || replaceExisting ? LOCK_TRIGGER_ACCESS : null, new VoidTransactionCallback(){

            public void execute(Connection conn) throws JobPersistenceException {
                JobStoreSupport.this.storeTrigger(conn, ctxt, newTrigger, null, replaceExisting, "WAITING", false, false);
            }
        });
    }

    protected void storeTrigger(Connection conn, SchedulingContext ctxt, Trigger newTrigger, JobDetail job, boolean replaceExisting, String state, boolean forceState, boolean recovering) throws ObjectAlreadyExistsException, JobPersistenceException {
        boolean existingTrigger;
        if (newTrigger.isVolatile() && this.isClustered()) {
            this.getLog().info((Object)"note: volatile triggers are effectively non-volatile in a clustered environment.");
        }
        if ((existingTrigger = this.triggerExists(conn, newTrigger.getName(), newTrigger.getGroup())) && !replaceExisting) {
            throw new ObjectAlreadyExistsException(newTrigger);
        }
        try {
            boolean shouldBepaused = false;
            if (!forceState) {
                shouldBepaused = this.getDelegate().isTriggerGroupPaused(conn, newTrigger.getGroup());
                if (!shouldBepaused && (shouldBepaused = this.getDelegate().isTriggerGroupPaused(conn, "_$_ALL_GROUPS_PAUSED_$_"))) {
                    this.getDelegate().insertPausedTriggerGroup(conn, newTrigger.getGroup());
                }
                if (shouldBepaused && (state.equals("WAITING") || state.equals("ACQUIRED"))) {
                    state = "PAUSED";
                }
            }
            if (job == null) {
                job = this.getDelegate().selectJobDetail(conn, newTrigger.getJobName(), newTrigger.getJobGroup(), this.getClassLoadHelper());
            }
            if (job == null) {
                throw new JobPersistenceException("The job (" + newTrigger.getFullJobName() + ") referenced by the trigger does not exist.");
            }
            if (job.isVolatile() && !newTrigger.isVolatile()) {
                throw new JobPersistenceException("It does not make sense to associate a non-volatile Trigger with a volatile Job!");
            }
            if (job.isStateful() && !recovering) {
                state = this.checkBlockedState(conn, ctxt, job.getName(), job.getGroup(), state);
            }
            if (existingTrigger) {
                if (newTrigger.getClass() == (class$org$quartz$SimpleTrigger == null ? (class$org$quartz$SimpleTrigger = JobStoreSupport.class$("org.quartz.SimpleTrigger")) : class$org$quartz$SimpleTrigger)) {
                    this.getDelegate().updateSimpleTrigger(conn, (SimpleTrigger)newTrigger);
                } else if (newTrigger.getClass() == (class$org$quartz$CronTrigger == null ? (class$org$quartz$CronTrigger = JobStoreSupport.class$("org.quartz.CronTrigger")) : class$org$quartz$CronTrigger)) {
                    this.getDelegate().updateCronTrigger(conn, (CronTrigger)newTrigger);
                } else {
                    this.getDelegate().updateBlobTrigger(conn, newTrigger);
                }
                this.getDelegate().updateTrigger(conn, newTrigger, state, job);
            } else {
                this.getDelegate().insertTrigger(conn, newTrigger, state, job);
                if (newTrigger.getClass() == (class$org$quartz$SimpleTrigger == null ? (class$org$quartz$SimpleTrigger = JobStoreSupport.class$("org.quartz.SimpleTrigger")) : class$org$quartz$SimpleTrigger)) {
                    this.getDelegate().insertSimpleTrigger(conn, (SimpleTrigger)newTrigger);
                } else if (newTrigger.getClass() == (class$org$quartz$CronTrigger == null ? (class$org$quartz$CronTrigger = JobStoreSupport.class$("org.quartz.CronTrigger")) : class$org$quartz$CronTrigger)) {
                    this.getDelegate().insertCronTrigger(conn, (CronTrigger)newTrigger);
                } else {
                    this.getDelegate().insertBlobTrigger(conn, newTrigger);
                }
            }
        }
        catch (Exception e) {
            throw new JobPersistenceException("Couldn't store trigger: " + e.getMessage(), e);
        }
    }

    protected boolean triggerExists(Connection conn, String triggerName, String groupName) throws JobPersistenceException {
        try {
            return this.getDelegate().triggerExists(conn, triggerName, groupName);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't determine trigger existence (" + groupName + "." + triggerName + "): " + e.getMessage(), e);
        }
    }

    public boolean removeJob(final SchedulingContext ctxt, final String jobName, final String groupName) throws JobPersistenceException {
        return (Boolean)this.executeInLock(LOCK_TRIGGER_ACCESS, new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                return JobStoreSupport.this.removeJob(conn, ctxt, jobName, groupName, true) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    protected boolean removeJob(Connection conn, SchedulingContext ctxt, String jobName, String groupName, boolean activeDeleteSafe) throws JobPersistenceException {
        try {
            Key[] jobTriggers = this.getDelegate().selectTriggerNamesForJob(conn, jobName, groupName);
            for (int i = 0; i < jobTriggers.length; ++i) {
                this.deleteTriggerAndChildren(conn, jobTriggers[i].getName(), jobTriggers[i].getGroup());
            }
            return this.deleteJobAndChildren(conn, ctxt, jobName, groupName);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't remove job: " + e.getMessage(), e);
        }
    }

    private boolean deleteJobAndChildren(Connection conn, SchedulingContext ctxt, String jobName, String groupName) throws NoSuchDelegateException, SQLException {
        this.getDelegate().deleteJobListeners(conn, jobName, groupName);
        return this.getDelegate().deleteJobDetail(conn, jobName, groupName) > 0;
    }

    private boolean deleteTriggerAndChildren(Connection conn, String triggerName, String triggerGroupName) throws SQLException, NoSuchDelegateException {
        DriverDelegate delegate = this.getDelegate();
        if (delegate.deleteSimpleTrigger(conn, triggerName, triggerGroupName) == 0 && delegate.deleteCronTrigger(conn, triggerName, triggerGroupName) == 0) {
            delegate.deleteBlobTrigger(conn, triggerName, triggerGroupName);
        }
        delegate.deleteTriggerListeners(conn, triggerName, triggerGroupName);
        return delegate.deleteTrigger(conn, triggerName, triggerGroupName) > 0;
    }

    public JobDetail retrieveJob(final SchedulingContext ctxt, final String jobName, final String groupName) throws JobPersistenceException {
        return (JobDetail)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                return JobStoreSupport.this.retrieveJob(conn, ctxt, jobName, groupName);
            }
        });
    }

    protected JobDetail retrieveJob(Connection conn, SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        try {
            JobDetail job = this.getDelegate().selectJobDetail(conn, jobName, groupName, this.getClassLoadHelper());
            if (job != null) {
                String[] listeners = this.getDelegate().selectJobListeners(conn, jobName, groupName);
                for (int i = 0; i < listeners.length; ++i) {
                    job.addJobListener(listeners[i]);
                }
            }
            return job;
        }
        catch (ClassNotFoundException e) {
            throw new JobPersistenceException("Couldn't retrieve job because a required class was not found: " + e.getMessage(), e, 410);
        }
        catch (IOException e) {
            throw new JobPersistenceException("Couldn't retrieve job because the BLOB couldn't be deserialized: " + e.getMessage(), e, 410);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't retrieve job: " + e.getMessage(), e);
        }
    }

    public boolean removeTrigger(final SchedulingContext ctxt, final String triggerName, final String groupName) throws JobPersistenceException {
        return (Boolean)this.executeInLock(LOCK_TRIGGER_ACCESS, new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                return JobStoreSupport.this.removeTrigger(conn, ctxt, triggerName, groupName) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    protected boolean removeTrigger(Connection conn, SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        boolean removedTrigger = false;
        try {
            int numTriggers;
            JobDetail job = this.getDelegate().selectJobForTrigger(conn, triggerName, groupName, this.getClassLoadHelper());
            removedTrigger = this.deleteTriggerAndChildren(conn, triggerName, groupName);
            if (null != job && !job.isDurable() && (numTriggers = this.getDelegate().selectNumTriggersForJob(conn, job.getName(), job.getGroup())) == 0) {
                this.deleteJobAndChildren(conn, ctxt, job.getName(), job.getGroup());
            }
        }
        catch (ClassNotFoundException e) {
            throw new JobPersistenceException("Couldn't remove trigger: " + e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't remove trigger: " + e.getMessage(), e);
        }
        return removedTrigger;
    }

    public boolean replaceTrigger(final SchedulingContext ctxt, final String triggerName, final String groupName, final Trigger newTrigger) throws JobPersistenceException {
        return (Boolean)this.executeInLock(LOCK_TRIGGER_ACCESS, new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                return JobStoreSupport.this.replaceTrigger(conn, ctxt, triggerName, groupName, newTrigger) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    protected boolean replaceTrigger(Connection conn, SchedulingContext ctxt, String triggerName, String groupName, Trigger newTrigger) throws JobPersistenceException {
        try {
            JobDetail job = this.getDelegate().selectJobForTrigger(conn, triggerName, groupName, this.getClassLoadHelper());
            if (job == null) {
                return false;
            }
            if (!newTrigger.getJobName().equals(job.getName()) || !newTrigger.getJobGroup().equals(job.getGroup())) {
                throw new JobPersistenceException("New trigger is not related to the same job as the old trigger.");
            }
            boolean removedTrigger = this.deleteTriggerAndChildren(conn, triggerName, groupName);
            this.storeTrigger(conn, ctxt, newTrigger, job, false, "WAITING", false, false);
            return removedTrigger;
        }
        catch (ClassNotFoundException e) {
            throw new JobPersistenceException("Couldn't remove trigger: " + e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't remove trigger: " + e.getMessage(), e);
        }
    }

    public Trigger retrieveTrigger(final SchedulingContext ctxt, final String triggerName, final String groupName) throws JobPersistenceException {
        return (Trigger)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                return JobStoreSupport.this.retrieveTrigger(conn, ctxt, triggerName, groupName);
            }
        });
    }

    protected Trigger retrieveTrigger(Connection conn, SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        return this.retrieveTrigger(conn, triggerName, groupName);
    }

    protected Trigger retrieveTrigger(Connection conn, String triggerName, String groupName) throws JobPersistenceException {
        try {
            Trigger trigger = this.getDelegate().selectTrigger(conn, triggerName, groupName);
            if (trigger == null) {
                return null;
            }
            trigger.clearAllTriggerListeners();
            String[] listeners = this.getDelegate().selectTriggerListeners(conn, triggerName, groupName);
            for (int i = 0; i < listeners.length; ++i) {
                trigger.addTriggerListener(listeners[i]);
            }
            return trigger;
        }
        catch (Exception e) {
            throw new JobPersistenceException("Couldn't retrieve trigger: " + e.getMessage(), e);
        }
    }

    public int getTriggerState(final SchedulingContext ctxt, final String triggerName, final String groupName) throws JobPersistenceException {
        return (Integer)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                return new Integer(JobStoreSupport.this.getTriggerState(conn, ctxt, triggerName, groupName));
            }
        });
    }

    public int getTriggerState(Connection conn, SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        try {
            String ts = this.getDelegate().selectTriggerState(conn, triggerName, groupName);
            if (ts == null) {
                return -1;
            }
            if (ts.equals("DELETED")) {
                return -1;
            }
            if (ts.equals("COMPLETE")) {
                return 2;
            }
            if (ts.equals("PAUSED")) {
                return 1;
            }
            if (ts.equals("PAUSED_BLOCKED")) {
                return 1;
            }
            if (ts.equals("ERROR")) {
                return 3;
            }
            if (ts.equals("BLOCKED")) {
                return 4;
            }
            return 0;
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't determine state of trigger (" + groupName + "." + triggerName + "): " + e.getMessage(), e);
        }
    }

    public void storeCalendar(final SchedulingContext ctxt, final String calName, final Calendar calendar, final boolean replaceExisting, final boolean updateTriggers) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.executeInLock(this.isLockOnInsert() || updateTriggers ? LOCK_TRIGGER_ACCESS : null, new VoidTransactionCallback(){

            public void execute(Connection conn) throws JobPersistenceException {
                JobStoreSupport.this.storeCalendar(conn, ctxt, calName, calendar, replaceExisting, updateTriggers);
            }
        });
    }

    protected void storeCalendar(Connection conn, SchedulingContext ctxt, String calName, Calendar calendar, boolean replaceExisting, boolean updateTriggers) throws ObjectAlreadyExistsException, JobPersistenceException {
        try {
            boolean existingCal = this.calendarExists(conn, calName);
            if (existingCal && !replaceExisting) {
                throw new ObjectAlreadyExistsException("Calendar with name '" + calName + "' already exists.");
            }
            if (existingCal) {
                if (this.getDelegate().updateCalendar(conn, calName, calendar) < 1) {
                    throw new JobPersistenceException("Couldn't store calendar.  Update failed.");
                }
                if (updateTriggers) {
                    Trigger[] trigs = this.getDelegate().selectTriggersForCalendar(conn, calName);
                    for (int i = 0; i < trigs.length; ++i) {
                        trigs[i].updateWithNewCalendar(calendar, this.getMisfireThreshold());
                        this.storeTrigger(conn, ctxt, trigs[i], null, true, "WAITING", false, false);
                    }
                }
            } else if (this.getDelegate().insertCalendar(conn, calName, calendar) < 1) {
                throw new JobPersistenceException("Couldn't store calendar.  Insert failed.");
            }
            if (!this.isClustered) {
                this.calendarCache.put(calName, calendar);
            }
        }
        catch (IOException e) {
            throw new JobPersistenceException("Couldn't store calendar because the BLOB couldn't be serialized: " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new JobPersistenceException("Couldn't store calendar: " + e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't store calendar: " + e.getMessage(), e);
        }
    }

    protected boolean calendarExists(Connection conn, String calName) throws JobPersistenceException {
        try {
            return this.getDelegate().calendarExists(conn, calName);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't determine calendar existence (" + calName + "): " + e.getMessage(), e);
        }
    }

    public boolean removeCalendar(final SchedulingContext ctxt, final String calName) throws JobPersistenceException {
        return (Boolean)this.executeInLock(LOCK_TRIGGER_ACCESS, new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                return JobStoreSupport.this.removeCalendar(conn, ctxt, calName) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    protected boolean removeCalendar(Connection conn, SchedulingContext ctxt, String calName) throws JobPersistenceException {
        try {
            if (this.getDelegate().calendarIsReferenced(conn, calName)) {
                throw new JobPersistenceException("Calender cannot be removed if it referenced by a trigger!");
            }
            if (!this.isClustered) {
                this.calendarCache.remove(calName);
            }
            return this.getDelegate().deleteCalendar(conn, calName) > 0;
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't remove calendar: " + e.getMessage(), e);
        }
    }

    public Calendar retrieveCalendar(final SchedulingContext ctxt, final String calName) throws JobPersistenceException {
        return (Calendar)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                return JobStoreSupport.this.retrieveCalendar(conn, ctxt, calName);
            }
        });
    }

    protected Calendar retrieveCalendar(Connection conn, SchedulingContext ctxt, String calName) throws JobPersistenceException {
        Calendar cal;
        Calendar calendar = cal = this.isClustered ? null : (Calendar)this.calendarCache.get(calName);
        if (cal != null) {
            return cal;
        }
        try {
            cal = this.getDelegate().selectCalendar(conn, calName);
            if (!this.isClustered) {
                this.calendarCache.put(calName, cal);
            }
            return cal;
        }
        catch (ClassNotFoundException e) {
            throw new JobPersistenceException("Couldn't retrieve calendar because a required class was not found: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JobPersistenceException("Couldn't retrieve calendar because the BLOB couldn't be deserialized: " + e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't retrieve calendar: " + e.getMessage(), e);
        }
    }

    public int getNumberOfJobs(final SchedulingContext ctxt) throws JobPersistenceException {
        return (Integer)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                return new Integer(JobStoreSupport.this.getNumberOfJobs(conn, ctxt));
            }
        });
    }

    protected int getNumberOfJobs(Connection conn, SchedulingContext ctxt) throws JobPersistenceException {
        try {
            return this.getDelegate().selectNumJobs(conn);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't obtain number of jobs: " + e.getMessage(), e);
        }
    }

    public int getNumberOfTriggers(final SchedulingContext ctxt) throws JobPersistenceException {
        return (Integer)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                return new Integer(JobStoreSupport.this.getNumberOfTriggers(conn, ctxt));
            }
        });
    }

    protected int getNumberOfTriggers(Connection conn, SchedulingContext ctxt) throws JobPersistenceException {
        try {
            return this.getDelegate().selectNumTriggers(conn);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't obtain number of triggers: " + e.getMessage(), e);
        }
    }

    public int getNumberOfCalendars(final SchedulingContext ctxt) throws JobPersistenceException {
        return (Integer)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                return new Integer(JobStoreSupport.this.getNumberOfCalendars(conn, ctxt));
            }
        });
    }

    protected int getNumberOfCalendars(Connection conn, SchedulingContext ctxt) throws JobPersistenceException {
        try {
            return this.getDelegate().selectNumCalendars(conn);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't obtain number of calendars: " + e.getMessage(), e);
        }
    }

    public String[] getJobNames(final SchedulingContext ctxt, final String groupName) throws JobPersistenceException {
        return (String[])this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                return JobStoreSupport.this.getJobNames(conn, ctxt, groupName);
            }
        });
    }

    protected String[] getJobNames(Connection conn, SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        String[] jobNames = null;
        try {
            jobNames = this.getDelegate().selectJobsInGroup(conn, groupName);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't obtain job names: " + e.getMessage(), e);
        }
        return jobNames;
    }

    public String[] getTriggerNames(final SchedulingContext ctxt, final String groupName) throws JobPersistenceException {
        return (String[])this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                return JobStoreSupport.this.getTriggerNames(conn, ctxt, groupName);
            }
        });
    }

    protected String[] getTriggerNames(Connection conn, SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        String[] trigNames = null;
        try {
            trigNames = this.getDelegate().selectTriggersInGroup(conn, groupName);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't obtain trigger names: " + e.getMessage(), e);
        }
        return trigNames;
    }

    public String[] getJobGroupNames(final SchedulingContext ctxt) throws JobPersistenceException {
        return (String[])this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                return JobStoreSupport.this.getJobGroupNames(conn, ctxt);
            }
        });
    }

    protected String[] getJobGroupNames(Connection conn, SchedulingContext ctxt) throws JobPersistenceException {
        String[] groupNames = null;
        try {
            groupNames = this.getDelegate().selectJobGroups(conn);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't obtain job groups: " + e.getMessage(), e);
        }
        return groupNames;
    }

    public String[] getTriggerGroupNames(final SchedulingContext ctxt) throws JobPersistenceException {
        return (String[])this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                return JobStoreSupport.this.getTriggerGroupNames(conn, ctxt);
            }
        });
    }

    protected String[] getTriggerGroupNames(Connection conn, SchedulingContext ctxt) throws JobPersistenceException {
        String[] groupNames = null;
        try {
            groupNames = this.getDelegate().selectTriggerGroups(conn);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't obtain trigger groups: " + e.getMessage(), e);
        }
        return groupNames;
    }

    public String[] getCalendarNames(final SchedulingContext ctxt) throws JobPersistenceException {
        return (String[])this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                return JobStoreSupport.this.getCalendarNames(conn, ctxt);
            }
        });
    }

    protected String[] getCalendarNames(Connection conn, SchedulingContext ctxt) throws JobPersistenceException {
        try {
            return this.getDelegate().selectCalendars(conn);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't obtain trigger groups: " + e.getMessage(), e);
        }
    }

    public Trigger[] getTriggersForJob(final SchedulingContext ctxt, final String jobName, final String groupName) throws JobPersistenceException {
        return (Trigger[])this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                return JobStoreSupport.this.getTriggersForJob(conn, ctxt, jobName, groupName);
            }
        });
    }

    protected Trigger[] getTriggersForJob(Connection conn, SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Trigger[] array = null;
        try {
            array = this.getDelegate().selectTriggersForJob(conn, jobName, groupName);
        }
        catch (Exception e) {
            throw new JobPersistenceException("Couldn't obtain triggers for job: " + e.getMessage(), e);
        }
        return array;
    }

    public void pauseTrigger(final SchedulingContext ctxt, final String triggerName, final String groupName) throws JobPersistenceException {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            public void execute(Connection conn) throws JobPersistenceException {
                JobStoreSupport.this.pauseTrigger(conn, ctxt, triggerName, groupName);
            }
        });
    }

    public void pauseTrigger(Connection conn, SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        try {
            String oldState = this.getDelegate().selectTriggerState(conn, triggerName, groupName);
            if (oldState.equals("WAITING") || oldState.equals("ACQUIRED")) {
                this.getDelegate().updateTriggerState(conn, triggerName, groupName, "PAUSED");
            } else if (oldState.equals("BLOCKED")) {
                this.getDelegate().updateTriggerState(conn, triggerName, groupName, "PAUSED_BLOCKED");
            }
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't pause trigger '" + groupName + "." + triggerName + "': " + e.getMessage(), e);
        }
    }

    public void pauseJob(final SchedulingContext ctxt, final String jobName, final String groupName) throws JobPersistenceException {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            public void execute(Connection conn) throws JobPersistenceException {
                Trigger[] triggers = JobStoreSupport.this.getTriggersForJob(conn, ctxt, jobName, groupName);
                for (int j = 0; j < triggers.length; ++j) {
                    JobStoreSupport.this.pauseTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
                }
            }
        });
    }

    public void pauseJobGroup(final SchedulingContext ctxt, final String groupName) throws JobPersistenceException {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            public void execute(Connection conn) throws JobPersistenceException {
                String[] jobNames = JobStoreSupport.this.getJobNames(conn, ctxt, groupName);
                for (int i = 0; i < jobNames.length; ++i) {
                    Trigger[] triggers = JobStoreSupport.this.getTriggersForJob(conn, ctxt, jobNames[i], groupName);
                    for (int j = 0; j < triggers.length; ++j) {
                        JobStoreSupport.this.pauseTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
                    }
                }
            }
        });
    }

    protected String checkBlockedState(Connection conn, SchedulingContext ctxt, String jobName, String jobGroupName, String currentState) throws JobPersistenceException {
        if (!currentState.equals("WAITING") && !currentState.equals("PAUSED")) {
            return currentState;
        }
        try {
            FiredTriggerRecord rec;
            List lst = this.getDelegate().selectFiredTriggerRecordsByJob(conn, jobName, jobGroupName);
            if (lst.size() > 0 && (rec = (FiredTriggerRecord)lst.get(0)).isJobIsStateful()) {
                return "PAUSED".equals(currentState) ? "PAUSED_BLOCKED" : "BLOCKED";
            }
            return currentState;
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't determine if trigger should be in a blocked state '" + jobGroupName + "." + jobName + "': " + e.getMessage(), e);
        }
    }

    public void resumeTrigger(final SchedulingContext ctxt, final String triggerName, final String groupName) throws JobPersistenceException {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            public void execute(Connection conn) throws JobPersistenceException {
                JobStoreSupport.this.resumeTrigger(conn, ctxt, triggerName, groupName);
            }
        });
    }

    public void resumeTrigger(Connection conn, SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        try {
            TriggerStatus status = this.getDelegate().selectTriggerStatus(conn, triggerName, groupName);
            if (status == null || status.getNextFireTime() == null) {
                return;
            }
            boolean blocked = false;
            if ("PAUSED_BLOCKED".equals(status.getStatus())) {
                blocked = true;
            }
            String newState = this.checkBlockedState(conn, ctxt, status.getJobKey().getName(), status.getJobKey().getGroup(), "WAITING");
            boolean misfired = false;
            if (status.getNextFireTime().before(new Date())) {
                misfired = this.updateMisfiredTrigger(conn, ctxt, triggerName, groupName, newState, true);
            }
            if (!misfired) {
                if (blocked) {
                    this.getDelegate().updateTriggerStateFromOtherState(conn, triggerName, groupName, newState, "PAUSED_BLOCKED");
                } else {
                    this.getDelegate().updateTriggerStateFromOtherState(conn, triggerName, groupName, newState, "PAUSED");
                }
            }
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't resume trigger '" + groupName + "." + triggerName + "': " + e.getMessage(), e);
        }
    }

    public void resumeJob(final SchedulingContext ctxt, final String jobName, final String groupName) throws JobPersistenceException {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            public void execute(Connection conn) throws JobPersistenceException {
                Trigger[] triggers = JobStoreSupport.this.getTriggersForJob(conn, ctxt, jobName, groupName);
                for (int j = 0; j < triggers.length; ++j) {
                    JobStoreSupport.this.resumeTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
                }
            }
        });
    }

    public void resumeJobGroup(final SchedulingContext ctxt, final String groupName) throws JobPersistenceException {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            public void execute(Connection conn) throws JobPersistenceException {
                String[] jobNames = JobStoreSupport.this.getJobNames(conn, ctxt, groupName);
                for (int i = 0; i < jobNames.length; ++i) {
                    Trigger[] triggers = JobStoreSupport.this.getTriggersForJob(conn, ctxt, jobNames[i], groupName);
                    for (int j = 0; j < triggers.length; ++j) {
                        JobStoreSupport.this.resumeTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
                    }
                }
            }
        });
    }

    public void pauseTriggerGroup(final SchedulingContext ctxt, final String groupName) throws JobPersistenceException {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            public void execute(Connection conn) throws JobPersistenceException {
                JobStoreSupport.this.pauseTriggerGroup(conn, ctxt, groupName);
            }
        });
    }

    public void pauseTriggerGroup(Connection conn, SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        try {
            this.getDelegate().updateTriggerGroupStateFromOtherStates(conn, groupName, "PAUSED", "ACQUIRED", "WAITING", "WAITING");
            this.getDelegate().updateTriggerGroupStateFromOtherState(conn, groupName, "PAUSED_BLOCKED", "BLOCKED");
            if (!this.getDelegate().isTriggerGroupPaused(conn, groupName)) {
                this.getDelegate().insertPausedTriggerGroup(conn, groupName);
            }
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't pause trigger group '" + groupName + "': " + e.getMessage(), e);
        }
    }

    public Set getPausedTriggerGroups(final SchedulingContext ctxt) throws JobPersistenceException {
        return (Set)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                return JobStoreSupport.this.getPausedTriggerGroups(conn, ctxt);
            }
        });
    }

    public Set getPausedTriggerGroups(Connection conn, SchedulingContext ctxt) throws JobPersistenceException {
        try {
            return this.getDelegate().selectPausedTriggerGroups(conn);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't determine paused trigger groups: " + e.getMessage(), e);
        }
    }

    public void resumeTriggerGroup(final SchedulingContext ctxt, final String groupName) throws JobPersistenceException {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            public void execute(Connection conn) throws JobPersistenceException {
                JobStoreSupport.this.resumeTriggerGroup(conn, ctxt, groupName);
            }
        });
    }

    public void resumeTriggerGroup(Connection conn, SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        try {
            this.getDelegate().deletePausedTriggerGroup(conn, groupName);
            String[] trigNames = this.getDelegate().selectTriggersInGroup(conn, groupName);
            for (int i = 0; i < trigNames.length; ++i) {
                this.resumeTrigger(conn, ctxt, trigNames[i], groupName);
            }
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't pause trigger group '" + groupName + "': " + e.getMessage(), e);
        }
    }

    public void pauseAll(final SchedulingContext ctxt) throws JobPersistenceException {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            public void execute(Connection conn) throws JobPersistenceException {
                JobStoreSupport.this.pauseAll(conn, ctxt);
            }
        });
    }

    public void pauseAll(Connection conn, SchedulingContext ctxt) throws JobPersistenceException {
        String[] names = this.getTriggerGroupNames(conn, ctxt);
        for (int i = 0; i < names.length; ++i) {
            this.pauseTriggerGroup(conn, ctxt, names[i]);
        }
        try {
            if (!this.getDelegate().isTriggerGroupPaused(conn, "_$_ALL_GROUPS_PAUSED_$_")) {
                this.getDelegate().insertPausedTriggerGroup(conn, "_$_ALL_GROUPS_PAUSED_$_");
            }
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't pause all trigger groups: " + e.getMessage(), e);
        }
    }

    public void resumeAll(final SchedulingContext ctxt) throws JobPersistenceException {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            public void execute(Connection conn) throws JobPersistenceException {
                JobStoreSupport.this.resumeAll(conn, ctxt);
            }
        });
    }

    public void resumeAll(Connection conn, SchedulingContext ctxt) throws JobPersistenceException {
        String[] names = this.getTriggerGroupNames(conn, ctxt);
        for (int i = 0; i < names.length; ++i) {
            this.resumeTriggerGroup(conn, ctxt, names[i]);
        }
        try {
            this.getDelegate().deletePausedTriggerGroup(conn, "_$_ALL_GROUPS_PAUSED_$_");
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't resume all trigger groups: " + e.getMessage(), e);
        }
    }

    protected synchronized String getFiredTriggerRecordId() {
        return this.getInstanceId() + ftrCtr++;
    }

    public Trigger acquireNextTrigger(final SchedulingContext ctxt, final long noLaterThan) throws JobPersistenceException {
        return (Trigger)this.executeInNonManagedTXLock(LOCK_TRIGGER_ACCESS, new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                return JobStoreSupport.this.acquireNextTrigger(conn, ctxt, noLaterThan);
            }
        });
    }

    protected Trigger acquireNextTrigger(Connection conn, SchedulingContext ctxt, long noLaterThan) throws JobPersistenceException {
        try {
            Trigger nextTrigger;
            Key triggerKey;
            int rowsUpdated;
            do {
                if ((triggerKey = this.getDelegate().selectTriggerToAcquire(conn, noLaterThan, this.getMisfireTime())) != null) continue;
                return null;
            } while ((rowsUpdated = this.getDelegate().updateTriggerStateFromOtherState(conn, triggerKey.getName(), triggerKey.getGroup(), "ACQUIRED", "WAITING")) <= 0 || (nextTrigger = this.retrieveTrigger(conn, ctxt, triggerKey.getName(), triggerKey.getGroup())) == null);
            nextTrigger.setFireInstanceId(this.getFiredTriggerRecordId());
            this.getDelegate().insertFiredTrigger(conn, nextTrigger, "ACQUIRED", null);
            return nextTrigger;
        }
        catch (Exception e) {
            throw new JobPersistenceException("Couldn't acquire next trigger: " + e.getMessage(), e);
        }
    }

    public void releaseAcquiredTrigger(final SchedulingContext ctxt, final Trigger trigger) throws JobPersistenceException {
        this.executeInNonManagedTXLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            public void execute(Connection conn) throws JobPersistenceException {
                JobStoreSupport.this.releaseAcquiredTrigger(conn, ctxt, trigger);
            }
        });
    }

    protected void releaseAcquiredTrigger(Connection conn, SchedulingContext ctxt, Trigger trigger) throws JobPersistenceException {
        try {
            this.getDelegate().updateTriggerStateFromOtherState(conn, trigger.getName(), trigger.getGroup(), "WAITING", "ACQUIRED");
            this.getDelegate().deleteFiredTrigger(conn, trigger.getFireInstanceId());
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't release acquired trigger: " + e.getMessage(), e);
        }
    }

    public TriggerFiredBundle triggerFired(final SchedulingContext ctxt, final Trigger trigger) throws JobPersistenceException {
        return (TriggerFiredBundle)this.executeInNonManagedTXLock(LOCK_TRIGGER_ACCESS, new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                try {
                    return JobStoreSupport.this.triggerFired(conn, ctxt, trigger);
                }
                catch (JobPersistenceException jpe) {
                    if (jpe.getErrorCode() == 410) {
                        return null;
                    }
                    throw jpe;
                }
            }
        });
    }

    protected TriggerFiredBundle triggerFired(Connection conn, SchedulingContext ctxt, Trigger trigger) throws JobPersistenceException {
        JobDetail job = null;
        Calendar cal = null;
        try {
            String state = this.getDelegate().selectTriggerState(conn, trigger.getName(), trigger.getGroup());
            if (!state.equals("ACQUIRED")) {
                return null;
            }
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't select trigger state: " + e.getMessage(), e);
        }
        try {
            job = this.retrieveJob(conn, ctxt, trigger.getJobName(), trigger.getJobGroup());
            if (job == null) {
                return null;
            }
        }
        catch (JobPersistenceException jpe) {
            try {
                this.getLog().error((Object)"Error retrieving job, setting trigger state to ERROR.", (Throwable)jpe);
                this.getDelegate().updateTriggerState(conn, trigger.getName(), trigger.getGroup(), "ERROR");
            }
            catch (SQLException sqle) {
                this.getLog().error((Object)"Unable to set trigger state to ERROR.", (Throwable)sqle);
            }
            throw jpe;
        }
        if (trigger.getCalendarName() != null && (cal = this.retrieveCalendar(conn, ctxt, trigger.getCalendarName())) == null) {
            return null;
        }
        try {
            this.getDelegate().deleteFiredTrigger(conn, trigger.getFireInstanceId());
            this.getDelegate().insertFiredTrigger(conn, trigger, "EXECUTING", job);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't insert fired trigger: " + e.getMessage(), e);
        }
        Date prevFireTime = trigger.getPreviousFireTime();
        trigger.triggered(cal);
        String state = "WAITING";
        boolean force = true;
        if (job.isStateful()) {
            state = "BLOCKED";
            force = false;
            try {
                this.getDelegate().updateTriggerStatesForJobFromOtherState(conn, job.getName(), job.getGroup(), "BLOCKED", "WAITING");
                this.getDelegate().updateTriggerStatesForJobFromOtherState(conn, job.getName(), job.getGroup(), "BLOCKED", "ACQUIRED");
                this.getDelegate().updateTriggerStatesForJobFromOtherState(conn, job.getName(), job.getGroup(), "PAUSED_BLOCKED", "PAUSED");
            }
            catch (SQLException e) {
                throw new JobPersistenceException("Couldn't update states of blocked triggers: " + e.getMessage(), e);
            }
        }
        if (trigger.getNextFireTime() == null) {
            state = "COMPLETE";
            force = true;
        }
        this.storeTrigger(conn, ctxt, trigger, job, true, state, force, false);
        job.getJobDataMap().clearDirtyFlag();
        return new TriggerFiredBundle(job, trigger, cal, trigger.getGroup().equals("RECOVERING_JOBS"), new Date(), trigger.getPreviousFireTime(), prevFireTime, trigger.getNextFireTime());
    }

    public void triggeredJobComplete(final SchedulingContext ctxt, final Trigger trigger, final JobDetail jobDetail, final int triggerInstCode) throws JobPersistenceException {
        this.executeInNonManagedTXLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            public void execute(Connection conn) throws JobPersistenceException {
                JobStoreSupport.this.triggeredJobComplete(conn, ctxt, trigger, jobDetail, triggerInstCode);
            }
        });
    }

    protected void triggeredJobComplete(Connection conn, SchedulingContext ctxt, Trigger trigger, JobDetail jobDetail, int triggerInstCode) throws JobPersistenceException {
        block20: {
            try {
                if (triggerInstCode == 3) {
                    if (trigger.getNextFireTime() == null) {
                        TriggerStatus stat = this.getDelegate().selectTriggerStatus(conn, trigger.getName(), trigger.getGroup());
                        if (stat != null && stat.getNextFireTime() == null) {
                            this.removeTrigger(conn, ctxt, trigger.getName(), trigger.getGroup());
                        }
                    } else {
                        this.removeTrigger(conn, ctxt, trigger.getName(), trigger.getGroup());
                    }
                } else if (triggerInstCode == 2) {
                    this.getDelegate().updateTriggerState(conn, trigger.getName(), trigger.getGroup(), "COMPLETE");
                } else if (triggerInstCode == 5) {
                    this.getLog().info((Object)("Trigger " + trigger.getFullName() + " set to ERROR state."));
                    this.getDelegate().updateTriggerState(conn, trigger.getName(), trigger.getGroup(), "ERROR");
                } else if (triggerInstCode == 4) {
                    this.getDelegate().updateTriggerStatesForJob(conn, trigger.getJobName(), trigger.getJobGroup(), "COMPLETE");
                } else if (triggerInstCode == 6) {
                    this.getLog().info((Object)("All triggers of Job " + trigger.getFullJobName() + " set to ERROR state."));
                    this.getDelegate().updateTriggerStatesForJob(conn, trigger.getJobName(), trigger.getJobGroup(), "ERROR");
                }
                if (!jobDetail.isStateful()) break block20;
                this.getDelegate().updateTriggerStatesForJobFromOtherState(conn, jobDetail.getName(), jobDetail.getGroup(), "WAITING", "BLOCKED");
                this.getDelegate().updateTriggerStatesForJobFromOtherState(conn, jobDetail.getName(), jobDetail.getGroup(), "PAUSED", "PAUSED_BLOCKED");
                try {
                    if (jobDetail.getJobDataMap().isDirty()) {
                        this.getDelegate().updateJobData(conn, jobDetail);
                    }
                }
                catch (IOException e) {
                    throw new JobPersistenceException("Couldn't serialize job data: " + e.getMessage(), e);
                }
                catch (SQLException e) {
                    throw new JobPersistenceException("Couldn't update job data: " + e.getMessage(), e);
                }
            }
            catch (SQLException e) {
                throw new JobPersistenceException("Couldn't update trigger state(s): " + e.getMessage(), e);
            }
        }
        try {
            this.getDelegate().deleteFiredTrigger(conn, trigger.getFireInstanceId());
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't delete fired trigger: " + e.getMessage(), e);
        }
    }

    protected DriverDelegate getDelegate() throws NoSuchDelegateException {
        if (null == this.delegate) {
            try {
                if (this.delegateClassName != null) {
                    this.delegateClass = this.getClassLoadHelper().loadClass(this.delegateClassName);
                }
                Constructor ctor = null;
                Object[] ctorParams = null;
                if (this.canUseProperties()) {
                    Class[] ctorParamTypes = new Class[]{class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = JobStoreSupport.class$("org.apache.commons.logging.Log")) : class$org$apache$commons$logging$Log, class$java$lang$String == null ? (class$java$lang$String = JobStoreSupport.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = JobStoreSupport.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = JobStoreSupport.class$("java.lang.Boolean")) : class$java$lang$Boolean};
                    ctor = this.delegateClass.getConstructor(ctorParamTypes);
                    ctorParams = new Object[]{this.getLog(), this.tablePrefix, this.instanceId, new Boolean(this.canUseProperties())};
                } else {
                    Class[] ctorParamTypes = new Class[]{class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = JobStoreSupport.class$("org.apache.commons.logging.Log")) : class$org$apache$commons$logging$Log, class$java$lang$String == null ? (class$java$lang$String = JobStoreSupport.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = JobStoreSupport.class$("java.lang.String")) : class$java$lang$String};
                    ctor = this.delegateClass.getConstructor(ctorParamTypes);
                    ctorParams = new Object[]{this.getLog(), this.tablePrefix, this.instanceId};
                }
                this.delegate = (DriverDelegate)ctor.newInstance(ctorParams);
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchDelegateException("Couldn't find delegate constructor: " + e.getMessage());
            }
            catch (InstantiationException e) {
                throw new NoSuchDelegateException("Couldn't create delegate: " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new NoSuchDelegateException("Couldn't create delegate: " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new NoSuchDelegateException("Couldn't create delegate: " + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                throw new NoSuchDelegateException("Couldn't load delegate class: " + e.getMessage());
            }
        }
        return this.delegate;
    }

    protected Semaphore getLockHandler() {
        return this.lockHandler;
    }

    public void setLockHandler(Semaphore lockHandler) {
        this.lockHandler = lockHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RecoverMisfiredJobsResult doRecoverMisfires() throws JobPersistenceException {
        boolean transOwner = false;
        Connection conn = this.getNonManagedTXConnection();
        try {
            int misfireCount;
            RecoverMisfiredJobsResult result = RecoverMisfiredJobsResult.NO_OP;
            int n = misfireCount = this.getDoubleCheckLockMisfireHandler() ? this.getDelegate().countMisfiredTriggersInStates(conn, "MISFIRED", "WAITING", this.getMisfireTime()) : Integer.MAX_VALUE;
            if (misfireCount == 0) {
                this.getLog().debug((Object)"Found 0 triggers that missed their scheduled fire-time.");
            } else {
                transOwner = this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
                result = this.recoverMisfiredJobs(conn, false);
            }
            this.commitConnection(conn);
            RecoverMisfiredJobsResult recoverMisfiredJobsResult = result;
            return recoverMisfiredJobsResult;
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        catch (SQLException e) {
            this.rollbackConnection(conn);
            throw new JobPersistenceException("Database error recovering from misfires.", e);
        }
        catch (RuntimeException e) {
            this.rollbackConnection(conn);
            throw new JobPersistenceException("Unexpected runtime exception: " + e.getMessage(), e);
        }
        finally {
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.cleanupConnection(conn);
            }
        }
    }

    protected void signalSchedulingChange() {
        this.signaler.signalSchedulingChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doCheckin() throws JobPersistenceException {
        boolean transOwner = false;
        boolean transStateOwner = false;
        boolean recovered = false;
        Connection conn = this.getNonManagedTXConnection();
        try {
            List failedRecords = null;
            if (!this.firstCheckIn) {
                boolean succeeded = false;
                try {
                    failedRecords = this.clusterCheckIn(conn);
                    this.commitConnection(conn);
                    succeeded = true;
                }
                catch (JobPersistenceException e) {
                    this.rollbackConnection(conn);
                    throw e;
                }
                finally {
                    if (!succeeded) {
                        this.cleanupConnection(conn);
                    }
                }
            }
            if (this.firstCheckIn || failedRecords.size() > 0) {
                this.getLockHandler().obtainLock(conn, LOCK_STATE_ACCESS);
                transStateOwner = true;
                List list = failedRecords = this.firstCheckIn ? this.clusterCheckIn(conn) : this.findFailedInstances(conn);
                if (failedRecords.size() > 0) {
                    this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
                    transOwner = true;
                    this.clusterRecover(conn, failedRecords);
                    recovered = true;
                }
            }
            this.commitConnection(conn);
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        finally {
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                try {
                    this.releaseLock(conn, LOCK_STATE_ACCESS, transStateOwner);
                }
                finally {
                    this.cleanupConnection(conn);
                }
            }
        }
        this.firstCheckIn = false;
        return recovered;
    }

    protected List findFailedInstances(Connection conn) throws JobPersistenceException {
        try {
            LinkedList<SchedulerStateRecord> failedInstances = new LinkedList<SchedulerStateRecord>();
            boolean foundThisScheduler = false;
            long timeNow = System.currentTimeMillis();
            List states = this.getDelegate().selectSchedulerStateRecords(conn, null);
            Iterator itr = states.iterator();
            while (itr.hasNext()) {
                SchedulerStateRecord rec = (SchedulerStateRecord)itr.next();
                if (rec.getSchedulerInstanceId().equals(this.getInstanceId())) {
                    foundThisScheduler = true;
                    if (!this.firstCheckIn) continue;
                    failedInstances.add(rec);
                    continue;
                }
                if (this.calcFailedIfAfter(rec) >= timeNow) continue;
                failedInstances.add(rec);
            }
            if (this.firstCheckIn) {
                failedInstances.addAll(this.findOrphanedFailedInstances(conn, states));
            }
            if (!foundThisScheduler && !this.firstCheckIn) {
                this.getLog().warn((Object)("This scheduler instance (" + this.getInstanceId() + ") is still " + "active but was recovered by another instance in the cluster.  " + "This may cause inconsistent behavior."));
            }
            return failedInstances;
        }
        catch (Exception e) {
            this.lastCheckin = System.currentTimeMillis();
            throw new JobPersistenceException("Failure identifying failed instances when checking-in: " + e.getMessage(), e);
        }
    }

    private List findOrphanedFailedInstances(Connection conn, List schedulerStateRecords) throws SQLException, NoSuchDelegateException {
        ArrayList<SchedulerStateRecord> orphanedInstances = new ArrayList<SchedulerStateRecord>();
        Set allFiredTriggerInstanceNames = this.getDelegate().selectFiredTriggerInstanceNames(conn);
        if (!allFiredTriggerInstanceNames.isEmpty()) {
            Iterator schedulerStateIter = schedulerStateRecords.iterator();
            while (schedulerStateIter.hasNext()) {
                SchedulerStateRecord rec = (SchedulerStateRecord)schedulerStateIter.next();
                allFiredTriggerInstanceNames.remove(rec.getSchedulerInstanceId());
            }
            Iterator orphanIter = allFiredTriggerInstanceNames.iterator();
            while (orphanIter.hasNext()) {
                SchedulerStateRecord orphanedInstance = new SchedulerStateRecord();
                orphanedInstance.setSchedulerInstanceId((String)orphanIter.next());
                orphanedInstances.add(orphanedInstance);
                this.getLog().warn((Object)("Found orphaned fired triggers for instance: " + orphanedInstance.getSchedulerInstanceId()));
            }
        }
        return orphanedInstances;
    }

    protected long calcFailedIfAfter(SchedulerStateRecord rec) {
        return rec.getCheckinTimestamp() + Math.max(rec.getCheckinInterval(), System.currentTimeMillis() - this.lastCheckin) + 7500L;
    }

    protected List clusterCheckIn(Connection conn) throws JobPersistenceException {
        List failedInstances = this.findFailedInstances(conn);
        try {
            this.lastCheckin = System.currentTimeMillis();
            if (this.getDelegate().updateSchedulerState(conn, this.getInstanceId(), this.lastCheckin) == 0) {
                this.getDelegate().insertSchedulerState(conn, this.getInstanceId(), this.lastCheckin, this.getClusterCheckinInterval());
            }
        }
        catch (Exception e) {
            throw new JobPersistenceException("Failure updating scheduler state when checking-in: " + e.getMessage(), e);
        }
        return failedInstances;
    }

    protected void clusterRecover(Connection conn, List failedInstances) throws JobPersistenceException {
        if (failedInstances.size() > 0) {
            long recoverIds = System.currentTimeMillis();
            this.logWarnIfNonZero(failedInstances.size(), "ClusterManager: detected " + failedInstances.size() + " failed or restarted instances.");
            try {
                Iterator itr = failedInstances.iterator();
                while (itr.hasNext()) {
                    SchedulerStateRecord rec = (SchedulerStateRecord)itr.next();
                    this.getLog().info((Object)("ClusterManager: Scanning for instance \"" + rec.getSchedulerInstanceId() + "\"'s failed in-progress jobs."));
                    List firedTriggerRecs = this.getDelegate().selectInstancesFiredTriggerRecords(conn, rec.getSchedulerInstanceId());
                    int acquiredCount = 0;
                    int recoveredCount = 0;
                    int otherCount = 0;
                    HashSet<Key> triggerKeys = new HashSet<Key>();
                    Iterator ftItr = firedTriggerRecs.iterator();
                    while (ftItr.hasNext()) {
                        FiredTriggerRecord ftRec = (FiredTriggerRecord)ftItr.next();
                        Key tKey = ftRec.getTriggerKey();
                        Key jKey = ftRec.getJobKey();
                        triggerKeys.add(tKey);
                        if (ftRec.getFireInstanceState().equals("BLOCKED")) {
                            this.getDelegate().updateTriggerStatesForJobFromOtherState(conn, jKey.getName(), jKey.getGroup(), "WAITING", "BLOCKED");
                        } else if (ftRec.getFireInstanceState().equals("PAUSED_BLOCKED")) {
                            this.getDelegate().updateTriggerStatesForJobFromOtherState(conn, jKey.getName(), jKey.getGroup(), "PAUSED", "PAUSED_BLOCKED");
                        }
                        if (ftRec.getFireInstanceState().equals("ACQUIRED")) {
                            this.getDelegate().updateTriggerStateFromOtherState(conn, tKey.getName(), tKey.getGroup(), "WAITING", "ACQUIRED");
                            ++acquiredCount;
                        } else if (ftRec.isJobRequestsRecovery()) {
                            if (this.jobExists(conn, jKey.getName(), jKey.getGroup())) {
                                SimpleTrigger rcvryTrig = new SimpleTrigger("recover_" + rec.getSchedulerInstanceId() + "_" + String.valueOf(recoverIds++), "RECOVERING_JOBS", new Date(ftRec.getFireTimestamp()));
                                rcvryTrig.setVolatility(ftRec.isTriggerIsVolatile());
                                rcvryTrig.setJobName(jKey.getName());
                                rcvryTrig.setJobGroup(jKey.getGroup());
                                rcvryTrig.setMisfireInstruction(1);
                                rcvryTrig.setPriority(ftRec.getPriority());
                                JobDataMap jd = this.getDelegate().selectTriggerJobDataMap(conn, tKey.getName(), tKey.getGroup());
                                jd.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_NAME", tKey.getName());
                                jd.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_GROUP", tKey.getGroup());
                                jd.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_FIRETIME_IN_MILLISECONDS_AS_STRING", String.valueOf(ftRec.getFireTimestamp()));
                                rcvryTrig.setJobDataMap(jd);
                                rcvryTrig.computeFirstFireTime(null);
                                this.storeTrigger(conn, null, rcvryTrig, null, false, "WAITING", false, true);
                                ++recoveredCount;
                            } else {
                                this.getLog().warn((Object)("ClusterManager: failed job '" + jKey + "' no longer exists, cannot schedule recovery."));
                                ++otherCount;
                            }
                        } else {
                            ++otherCount;
                        }
                        if (!ftRec.isJobIsStateful()) continue;
                        this.getDelegate().updateTriggerStatesForJobFromOtherState(conn, jKey.getName(), jKey.getGroup(), "WAITING", "BLOCKED");
                        this.getDelegate().updateTriggerStatesForJobFromOtherState(conn, jKey.getName(), jKey.getGroup(), "PAUSED", "PAUSED_BLOCKED");
                    }
                    this.getDelegate().deleteFiredTriggers(conn, rec.getSchedulerInstanceId());
                    int completeCount = 0;
                    Iterator triggerKeyIter = triggerKeys.iterator();
                    while (triggerKeyIter.hasNext()) {
                        List firedTriggers;
                        Key triggerKey = (Key)triggerKeyIter.next();
                        if (!this.getDelegate().selectTriggerState(conn, triggerKey.getName(), triggerKey.getGroup()).equals("COMPLETE") || !(firedTriggers = this.getDelegate().selectFiredTriggerRecords(conn, triggerKey.getName(), triggerKey.getGroup())).isEmpty()) continue;
                        SchedulingContext schedulingContext = new SchedulingContext();
                        schedulingContext.setInstanceId(this.instanceId);
                        if (!this.removeTrigger(conn, schedulingContext, triggerKey.getName(), triggerKey.getGroup())) continue;
                        ++completeCount;
                    }
                    this.logWarnIfNonZero(acquiredCount, "ClusterManager: ......Freed " + acquiredCount + " acquired trigger(s).");
                    this.logWarnIfNonZero(completeCount, "ClusterManager: ......Deleted " + completeCount + " complete triggers(s).");
                    this.logWarnIfNonZero(recoveredCount, "ClusterManager: ......Scheduled " + recoveredCount + " recoverable job(s) for recovery.");
                    this.logWarnIfNonZero(otherCount, "ClusterManager: ......Cleaned-up " + otherCount + " other failed job(s).");
                    if (rec.getSchedulerInstanceId().equals(this.getInstanceId())) continue;
                    this.getDelegate().deleteSchedulerState(conn, rec.getSchedulerInstanceId());
                }
            }
            catch (Exception e) {
                throw new JobPersistenceException("Failure recovering jobs: " + e.getMessage(), e);
            }
        }
    }

    protected void logWarnIfNonZero(int val, String warning) {
        if (val > 0) {
            this.getLog().info((Object)warning);
        } else {
            this.getLog().debug((Object)warning);
        }
    }

    protected void cleanupConnection(Connection conn) {
        if (conn != null) {
            Proxy connProxy;
            InvocationHandler invocationHandler;
            if (conn instanceof Proxy && (invocationHandler = Proxy.getInvocationHandler(connProxy = (Proxy)((Object)conn))) instanceof AttributeRestoringConnectionInvocationHandler) {
                AttributeRestoringConnectionInvocationHandler connHandler = (AttributeRestoringConnectionInvocationHandler)invocationHandler;
                connHandler.restoreOriginalAtributes();
                this.closeConnection(connHandler.getWrappedConnection());
                return;
            }
            this.closeConnection(conn);
        }
    }

    protected void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                this.getLog().error((Object)"Failed to close Connection", (Throwable)e);
            }
            catch (Throwable e) {
                this.getLog().error((Object)"Unexpected exception closing Connection.  This is often due to a Connection being returned after or during shutdown.", e);
            }
        }
    }

    protected void rollbackConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.rollback();
            }
            catch (SQLException e) {
                this.getLog().error((Object)("Couldn't rollback jdbc connection. " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void commitConnection(Connection conn) throws JobPersistenceException {
        if (conn != null) {
            try {
                conn.commit();
            }
            catch (SQLException e) {
                throw new JobPersistenceException("Couldn't commit jdbc connection. " + e.getMessage(), e);
            }
        }
    }

    public Object executeWithoutLock(TransactionCallback txCallback) throws JobPersistenceException {
        return this.executeInLock(null, txCallback);
    }

    protected void executeInLock(String lockName, final VoidTransactionCallback txCallback) throws JobPersistenceException {
        this.executeInLock(lockName, new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                txCallback.execute(conn);
                return null;
            }
        });
    }

    protected abstract Object executeInLock(String var1, TransactionCallback var2) throws JobPersistenceException;

    protected void executeInNonManagedTXLock(String lockName, final VoidTransactionCallback txCallback) throws JobPersistenceException {
        this.executeInNonManagedTXLock(lockName, new TransactionCallback(){

            public Object execute(Connection conn) throws JobPersistenceException {
                txCallback.execute(conn);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object executeInNonManagedTXLock(String lockName, TransactionCallback txCallback) throws JobPersistenceException {
        boolean transOwner = false;
        Connection conn = null;
        try {
            if (lockName != null) {
                if (this.getLockHandler().requiresConnection()) {
                    conn = this.getNonManagedTXConnection();
                }
                transOwner = this.getLockHandler().obtainLock(conn, lockName);
            }
            if (conn == null) {
                conn = this.getNonManagedTXConnection();
            }
            Object result = txCallback.execute(conn);
            this.commitConnection(conn);
            Object object = result;
            return object;
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        catch (RuntimeException e) {
            this.rollbackConnection(conn);
            throw new JobPersistenceException("Unexpected runtime exception: " + e.getMessage(), e);
        }
        finally {
            try {
                this.releaseLock(conn, lockName, transOwner);
            }
            finally {
                this.cleanupConnection(conn);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MisfireHandler
    extends Thread {
        private boolean shutdown = false;
        private int numFails = 0;

        MisfireHandler() {
            this.setName("QuartzScheduler_" + JobStoreSupport.this.instanceName + "-" + JobStoreSupport.this.instanceId + "_MisfireHandler");
            this.setDaemon(JobStoreSupport.this.getMakeThreadsDaemons());
        }

        public void initialize() {
            this.start();
        }

        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }

        private RecoverMisfiredJobsResult manage() {
            try {
                JobStoreSupport.this.getLog().debug((Object)"MisfireHandler: scanning for misfires...");
                RecoverMisfiredJobsResult res = JobStoreSupport.this.doRecoverMisfires();
                this.numFails = 0;
                return res;
            }
            catch (Exception e) {
                if (this.numFails % 4 == 0) {
                    JobStoreSupport.this.getLog().error((Object)("MisfireHandler: Error handling misfires: " + e.getMessage()), (Throwable)e);
                }
                ++this.numFails;
                return RecoverMisfiredJobsResult.NO_OP;
            }
        }

        public void run() {
            while (!this.shutdown) {
                long sTime = System.currentTimeMillis();
                RecoverMisfiredJobsResult recoverMisfiredJobsResult = this.manage();
                if (recoverMisfiredJobsResult.getProcessedMisfiredTriggerCount() > 0) {
                    JobStoreSupport.this.signalSchedulingChange();
                }
                if (this.shutdown) continue;
                long timeToSleep = 50L;
                if (!recoverMisfiredJobsResult.hasMoreMisfiredTriggers()) {
                    timeToSleep = JobStoreSupport.this.getMisfireThreshold() - (System.currentTimeMillis() - sTime);
                    if (timeToSleep <= 0L) {
                        timeToSleep = 50L;
                    }
                    if (this.numFails > 0) {
                        timeToSleep = Math.max(JobStoreSupport.this.getDbRetryInterval(), timeToSleep);
                    }
                }
                try {
                    Thread.sleep(timeToSleep);
                }
                catch (Exception ignore) {}
            }
        }
    }

    class ClusterManager
    extends Thread {
        private boolean shutdown = false;
        private int numFails = 0;

        ClusterManager() {
            this.setPriority(7);
            this.setName("QuartzScheduler_" + JobStoreSupport.this.instanceName + "-" + JobStoreSupport.this.instanceId + "_ClusterManager");
            this.setDaemon(JobStoreSupport.this.getMakeThreadsDaemons());
        }

        public void initialize() {
            this.manage();
            this.start();
        }

        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }

        private boolean manage() {
            boolean res = false;
            try {
                res = JobStoreSupport.this.doCheckin();
                this.numFails = 0;
                JobStoreSupport.this.getLog().debug((Object)"ClusterManager: Check-in complete.");
            }
            catch (Exception e) {
                if (this.numFails % 4 == 0) {
                    JobStoreSupport.this.getLog().error((Object)("ClusterManager: Error managing cluster: " + e.getMessage()), (Throwable)e);
                }
                ++this.numFails;
            }
            return res;
        }

        public void run() {
            while (!this.shutdown) {
                if (!this.shutdown) {
                    long timeToSleep = JobStoreSupport.this.getClusterCheckinInterval();
                    long transpiredTime = System.currentTimeMillis() - JobStoreSupport.this.lastCheckin;
                    if ((timeToSleep -= transpiredTime) <= 0L) {
                        timeToSleep = 100L;
                    }
                    if (this.numFails > 0) {
                        timeToSleep = Math.max(JobStoreSupport.this.getDbRetryInterval(), timeToSleep);
                    }
                    try {
                        Thread.sleep(timeToSleep);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                if (this.shutdown || !this.manage()) continue;
                JobStoreSupport.this.signalSchedulingChange();
            }
        }
    }

    protected static interface VoidTransactionCallback {
        public void execute(Connection var1) throws JobPersistenceException;
    }

    protected static interface TransactionCallback {
        public Object execute(Connection var1) throws JobPersistenceException;
    }

    protected static class RecoverMisfiredJobsResult {
        public static final RecoverMisfiredJobsResult NO_OP = new RecoverMisfiredJobsResult(false, 0);
        private boolean _hasMoreMisfiredTriggers;
        private int _processedMisfiredTriggerCount;

        public RecoverMisfiredJobsResult(boolean hasMoreMisfiredTriggers, int processedMisfiredTriggerCount) {
            this._hasMoreMisfiredTriggers = hasMoreMisfiredTriggers;
            this._processedMisfiredTriggerCount = processedMisfiredTriggerCount;
        }

        public boolean hasMoreMisfiredTriggers() {
            return this._hasMoreMisfiredTriggers;
        }

        public int getProcessedMisfiredTriggerCount() {
            return this._processedMisfiredTriggerCount;
        }
    }
}

