/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.workflow.upgrayedd;

import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import oracle.jdbc.driver.OracleDriver;

public class UpgradeWorkflow {
    private Connection conn;
    private String expression;
    private String name;
    private List<String> templateNames;

    public static void main(String[] args) throws Exception {
        String upgdateType = args[0];
        if (args.length == 1) {
            System.out.println("No templates passed");
        }
        List<String> templateNames = Arrays.asList(args[1].split(","));
        UpgradeWorkflow uw = null;
        if (upgdateType.equals("ContentProcessing")) {
            uw = new UpgradeWorkflow(templateNames, "annotation-@Category(\"ContentProcessing\")", "@Category(\"ContentProcessing\")");
        } else if (upgdateType.equals("LocalContentProcessing")) {
            uw = new UpgradeWorkflow(templateNames, "annotation-@Category(\"LocalContentProcessing\")", "@Category(\"LocalContentProcessing\")");
        } else if (upgdateType.equals("TitleListProcessing")) {
            uw = new UpgradeWorkflow(templateNames, "annotation-@Category(\"TitleListProcessing\")", "@Category(\"TitleListProcessing\")");
        }
        if (uw != null) {
            uw.upgrade();
        } else {
            System.out.println("Unrecognized option: " + upgdateType);
        }
    }

    private UpgradeWorkflow(List<String> templateNames, String name, String expression) throws Exception {
        this.name = name;
        this.expression = expression;
        this.templateNames = templateNames;
        DriverManager.registerDriver((Driver)new OracleDriver());
        Properties props = new Properties();
        props.load(new FileInputStream("metadata_upgrade.properties"));
        String url = props.getProperty("url");
        String user = props.getProperty("user");
        String pwd = props.getProperty("pwd");
        this.conn = DriverManager.getConnection(url, user, pwd);
    }

    public void upgrade() throws Exception {
        ArrayList<String> messages = new ArrayList<String>();
        ArrayList<Long> insertable = new ArrayList<Long>();
        for (String processDefName : this.templateNames) {
            processDefName = processDefName.trim();
            try {
                Long processDefId = this.getProcessDefinition(processDefName);
                if (processDefId == null) {
                    messages.add("No template found with the name: " + processDefName);
                    continue;
                }
                if (this.isUpgraded(processDefId)) {
                    messages.add(processDefName + " has ALREADY been upgraded.");
                    continue;
                }
                insertable.add(processDefId);
                messages.add("Successfully upgraded template: " + processDefName);
            }
            catch (SQLException e) {
                this.conn.close();
                throw new Exception("Error while processing template: " + processDefName, e);
            }
        }
        if (insertable.size() > 0) {
            this.insertAnnotations(insertable);
        }
        this.conn.close();
        for (String str : messages) {
            System.out.println(str);
        }
    }

    private Long getProcessDefinition(String processDefName) throws SQLException {
        String queryStr = "SELECT id_ FROM jbpm_processdefinition WHERE upper(name_) = ? and version_  = (SELECT MAX(version_) FROM jbpm_processdefinition WHERE upper(name_) = ?)";
        PreparedStatement query = this.conn.prepareStatement(queryStr);
        String upName = processDefName.toUpperCase();
        query.setString(1, upName);
        query.setString(2, upName);
        ResultSet rs = query.executeQuery();
        Long result = null;
        if (rs.next()) {
            result = rs.getLong(1);
        }
        query.close();
        return result;
    }

    private boolean isUpgraded(long proccessDefId) throws SQLException {
        String queryStr = "SELECT id_ FROM  jbpm_action WHERE name_ = ? AND processdefinition_ = ?";
        PreparedStatement query = this.conn.prepareStatement(queryStr);
        query.setString(1, this.name);
        query.setLong(2, proccessDefId);
        ResultSet rs = query.executeQuery();
        boolean result = rs.next();
        rs.close();
        query.close();
        return result;
    }

    private void insertAnnotations(List<Long> proccessDefIds) throws Exception {
        String queryStr = "insert into jbpm_action (class, name_, expression_, ispropagationallowed_, isasync_, processdefinition_) values ('X', ?, ?, 1, 0,  ?)";
        try {
            this.conn.setAutoCommit(false);
            PreparedStatement insert = this.conn.prepareStatement(queryStr);
            for (Long proccessDefId : proccessDefIds) {
                insert.setString(1, this.name);
                insert.setString(2, this.expression);
                insert.setLong(3, proccessDefId);
                insert.addBatch();
            }
            insert.executeBatch();
            this.conn.commit();
            insert.close();
        }
        catch (SQLException e) {
            try {
                this.conn.rollback();
                this.conn.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw new Exception("Error while processing inserts ", e);
        }
    }
}

