/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import com.tandbergtv.metadatamanager.MetadataManagerDAOImpl;
import com.tandbergtv.metadatamanager.exception.InvalidRevisionException;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.model.RootAssetRevision;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.binder.ECMFBinder;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentDAO {
    private static final Logger logger = Logger.getLogger(MetadataManagerDAOImpl.class);
    private static final String METADATA_XML_TABLE = "mdm_metadata";
    private static final String METADATA_REVISION_XML_TABLE = "mdm_metadata_revision";
    private static final String SQL_COMMON_1 = "]' PASSING object_value AS \"p\")";
    private static final String ASSET_SEQ_SQL = "select mdm_asset_seq.nextval from dual";
    private HibernateTemplate template;

    public DocumentDAO(HibernateTemplate template) {
        this.template = template;
    }

    @Transactional
    public void saveAsset(Asset asset) throws MetadataException {
        boolean isNewRevision = true;
        Session session = this.getCurrentSession();
        Group rootAsset = (Group)asset;
        int revision = rootAsset.getLatestRevisionNumber();
        RootAssetRevision newRootAssetRevision = rootAsset.getRevision(revision);
        List<RootAssetRevision> revisions = this.getRootAssetRevisions(session, rootAsset.getTTVId(), revision);
        if (revisions != null && !revisions.isEmpty()) {
            isNewRevision = false;
        }
        boolean newAsset = !rootAsset.getTTVId().isValidIdentifier();
        List<Asset> assets = rootAsset.getAllAssets(true);
        List<Object> newAssetList = new ArrayList();
        if (newAsset) {
            newAssetList = assets;
        } else {
            for (Asset a : assets) {
                if (a.getId() >= 1L) continue;
                newAssetList.add(a);
            }
        }
        if (newAssetList.size() > 0) {
            AssetIdGen work = new AssetIdGen(newAssetList);
            try {
                session.doWork((Work)work);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw new MetadataException(ex.getMessage(), ex);
            }
        }
        if (newAsset) {
            newRootAssetRevision.setDocumentId(rootAsset.getId());
        }
        logger.debug((Object)("Saving asset tree, new revision: " + isNewRevision));
        ArrayList<Asset> assetList = new ArrayList<Asset>();
        assetList.add(rootAsset);
        Document ecmfDoc = new ECMFBinder().bind(assetList);
        Object work = newAsset ? new InsertMetadata(false, ecmfDoc) : new UpdateMetadata(rootAsset.getId(), ecmfDoc, isNewRevision);
        try {
            session.doWork((Work)work);
        }
        catch (Exception ex) {
            logger.error((Object)DocumentDAO.getString(ecmfDoc));
            throw new MetadataException(ex.getMessage(), ex);
        }
        session.merge((Object)newRootAssetRevision);
    }

    @Transactional
    public void deleteAsset(Asset asset) throws MetadataException {
        Session session = this.getCurrentSession();
        this.inactivateAllChildren(asset);
        Group rootAsset = (Group)asset;
        int revision = rootAsset.getLatestRevisionNumber();
        RootAssetRevision newRootAssetRevision = rootAsset.getRevision(revision);
        DeleteMetadata work = new DeleteMetadata(rootAsset.getTTVId().getId());
        try {
            session.doWork((Work)work);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new MetadataException(ex.getMessage(), ex);
        }
        session.merge((Object)newRootAssetRevision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public Asset getAsset(TTVId identifier, int revisionNumber, boolean withCurrentSession) throws SearchException, InvalidRevisionException {
        Session session;
        Session session2 = session = withCurrentSession ? this.getCurrentSession() : this.getNewSession();
        if (revisionNumber == 0) {
            revisionNumber = Integer.MAX_VALUE;
        }
        List<RootAssetRevision> allRevisions = null;
        allRevisions = this.getRootAssetRevisions(session, identifier, 0);
        if (allRevisions.size() < 1) {
            String msg = "No RootAssetRevisions found for document with id=" + identifier.getId();
            logger.info((Object)msg);
            throw new SearchException(msg);
        }
        boolean isGettingLatest = revisionNumber >= allRevisions.get(0).getRevisionNumber();
        Asset asset = null;
        try {
            asset = this.getAsset(identifier, isGettingLatest, revisionNumber, allRevisions, session);
            if (asset == null && isGettingLatest && (asset = this.getAsset(identifier, false, revisionNumber = allRevisions.get(0).getRevisionNumber(), allRevisions, session)) != null) {
                this.inactivateAllChildren(asset);
            }
            if (asset == null) {
                String msg = "No document found with id=" + identifier.getId();
                if (!isGettingLatest) {
                    msg = msg + " and revision=" + revisionNumber;
                }
                logger.info((Object)msg);
                throw new SearchException(msg);
            }
        }
        finally {
            if (!withCurrentSession) {
                session.close();
            }
        }
        return asset;
    }

    private void inactivateAllChildren(Asset a) {
        a.setState(false);
        for (Relation relation : a.getRelations()) {
            Asset targetAsset = relation.getTargetAsset();
            targetAsset.setState(false);
            this.inactivateAllChildren(targetAsset);
        }
    }

    private Asset getAsset(TTVId identifier, boolean isGettingLatest, int revisionNumber, List<RootAssetRevision> allRevisions, Session session) throws SearchException, InvalidRevisionException {
        GetMetadata work = new GetMetadata(isGettingLatest, identifier.getId(), revisionNumber);
        List<Document> ecmfDocs = null;
        try {
            session.doWork((Work)work);
            ecmfDocs = work.getDocuments();
            if (ecmfDocs.size() > 1) {
                String msg = "More than one document found with id=" + identifier.getId();
                if (!isGettingLatest) {
                    msg = msg + " and revision=" + revisionNumber;
                }
                logger.info((Object)msg);
                throw new SearchException(msg);
            }
            if (ecmfDocs.size() < 1) {
                return null;
            }
        }
        catch (HibernateException e) {
            throw new SearchException(e.getMessage());
        }
        List<Asset> pkgs = new ECMFBinder().bind(ecmfDocs.get(0));
        Group rootAsset = (Group)pkgs.get(0);
        rootAsset.setRevisions(allRevisions);
        return rootAsset;
    }

    private static String getInsertSelectSql(long documentId) {
        StringBuilder s = new StringBuilder("INSERT into mdm_metadata_revision (object_value)");
        s.append(" select object_value from mdm_metadata mdm");
        s.append(" WHERE XMLExists('$p/ECMFSpec[@documentId=");
        s.append(documentId);
        s.append("]' PASSING mdm.object_value AS \"p\")");
        return s.toString();
    }

    private void dumpAssetTree(Asset asset) {
        if (asset == null) {
            return;
        }
        logger.info((Object)asset.toString());
        for (Relation r : asset.getRelations()) {
            this.dumpAssetTree(r.getTargetAsset());
        }
    }

    private static String getString(Document doc) {
        String xmlString = null;
        StringWriter out = new StringWriter();
        XMLSerializer serializer = new XMLSerializer(out, new OutputFormat(doc, null, true));
        try {
            serializer.serialize(doc);
            xmlString = out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return xmlString;
    }

    private Session getNewSession() {
        return this.template.getSessionFactory().openSession();
    }

    private Session getCurrentSession() {
        return (Session)this.template.executeWithNativeSession(new HibernateCallback(){

            public Session doInHibernate(Session session) {
                return session;
            }
        });
    }

    private List<RootAssetRevision> getRootAssetRevisions(Session session, TTVId id, int revision) {
        StringBuilder b = new StringBuilder("select * from MDM_ROOTASSETREVISION where asset_id=");
        b.append(id.getId());
        if (revision > 0) {
            b.append(" and revisionnumber=" + revision);
        } else {
            b.append(" order by revisionnumber desc");
        }
        SQLQuery q = session.createSQLQuery(b.toString()).addEntity(RootAssetRevision.class);
        List revs = q.list();
        return revs;
    }

    private static class AssetIdGen
    implements Work {
        private String sql = "select mdm_asset_seq.nextval from dual";
        private List<Asset> newAssets = new ArrayList<Asset>();

        public AssetIdGen(List<Asset> newAssets) {
            this.newAssets = newAssets;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Connection con) throws SQLException {
            if (this.newAssets.size() < 1) {
                return;
            }
            PreparedStatement st = null;
            ResultSet rs = null;
            try {
                st = con.prepareStatement(this.sql);
                for (int i = 0; i < this.newAssets.size(); ++i) {
                    rs = st.executeQuery();
                    if (!rs.next()) continue;
                    this.newAssets.get(i).setId(rs.getInt(1));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                st.close();
            }
        }
    }

    static class GetMetadata
    implements Work {
        private String sql;
        private List<Document> docs = new ArrayList<Document>();

        public GetMetadata(boolean isGettingLatest, long documentId, int revision) {
            StringBuilder s = new StringBuilder("SELECT XMLSERIALIZE(content x.OBJECT_VALUE as clob no indent) FROM ");
            if (!isGettingLatest) {
                s.append("mdm_metadata_revision x");
            } else {
                s.append("mdm_metadata x");
            }
            s.append(" WHERE XMLExists('$p/ECMFSpec[@documentId=");
            s.append(documentId);
            if (!isGettingLatest) {
                s.append(" and @revision=");
                s.append(revision);
            }
            s.append(DocumentDAO.SQL_COMMON_1);
            this.sql = s.toString();
        }

        public GetMetadata(String sql) {
            this.sql = sql;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Connection con) throws SQLException {
            Statement st = null;
            ResultSet rs = null;
            try {
                logger.debug((Object)this.sql);
                st = con.prepareStatement(this.sql);
                rs = st.executeQuery();
                while (rs.next()) {
                    Reader r = rs.getCharacterStream(1);
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document doc = builder.parse(new InputSource(r));
                    this.docs.add(doc);
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
                return;
            }
            catch (SAXException e) {
                logger.error((Object)e);
                return;
            }
            catch (ParserConfigurationException e) {
                logger.error((Object)e);
                return;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                st.close();
            }
        }

        public List<Document> getDocuments() {
            return this.docs;
        }
    }

    private static class DeleteMetadata
    implements Work {
        private String insSelSql;
        private String delSql;

        public DeleteMetadata(long documentId) {
            this.insSelSql = DocumentDAO.getInsertSelectSql(documentId);
            StringBuilder s = new StringBuilder("DELETE from ");
            s.append(DocumentDAO.METADATA_XML_TABLE);
            s.append(" WHERE XMLExists('$p/ECMFSpec[@documentId=");
            s.append(documentId);
            s.append(DocumentDAO.SQL_COMMON_1);
            this.delSql = s.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Connection con) throws SQLException {
            Statement st = null;
            try {
                logger.debug((Object)this.insSelSql);
                st = con.prepareStatement(this.insSelSql);
                st.execute();
                st.close();
                logger.debug((Object)this.delSql);
                st = con.prepareStatement(this.delSql);
                st.execute();
            }
            finally {
                st.close();
            }
        }
    }

    private static class UpdateMetadata
    implements Work {
        private String insSelSql;
        private String updSql;
        private String strXml;

        public UpdateMetadata(long documentId, Document ecmfDoc, boolean isNewRevision) throws MetadataException {
            this.strXml = DocumentDAO.getString(ecmfDoc);
            if (this.strXml == null || this.strXml.isEmpty()) {
                throw new MetadataException("Error: Empty Document");
            }
            if (isNewRevision) {
                this.insSelSql = DocumentDAO.getInsertSelectSql(documentId);
            }
            StringBuilder s = new StringBuilder("UPDATE ");
            s.append(DocumentDAO.METADATA_XML_TABLE);
            s.append(" SET object_value = ?  WHERE XMLExists('$p/ECMFSpec[@documentId=");
            s.append(documentId);
            s.append(DocumentDAO.SQL_COMMON_1);
            this.updSql = s.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Connection con) throws SQLException {
            Statement st = null;
            SQLXML xmlObj = null;
            try {
                if (this.insSelSql != null && !this.insSelSql.isEmpty()) {
                    logger.debug((Object)this.insSelSql);
                    st = con.prepareStatement(this.insSelSql);
                    st.execute();
                    st.close();
                }
                logger.debug((Object)this.updSql);
                st = con.prepareStatement(this.updSql);
                xmlObj = con.createSQLXML();
                xmlObj.setString(this.strXml);
                st.setSQLXML(1, xmlObj);
                st.executeUpdate();
            }
            finally {
                if (xmlObj != null) {
                    xmlObj.free();
                }
                st.close();
            }
        }

        public String getXMLString() {
            return this.strXml;
        }
    }

    private static class InsertMetadata
    implements Work {
        private String strXml;
        private String sql;

        public InsertMetadata(boolean isRevisionTable, Document ecmfDoc) throws MetadataException {
            this.strXml = DocumentDAO.getString(ecmfDoc);
            if (this.strXml == null || this.strXml.isEmpty()) {
                throw new MetadataException("Error: Empty Document");
            }
            StringBuilder s = new StringBuilder("INSERT into ");
            if (isRevisionTable) {
                s.append(DocumentDAO.METADATA_REVISION_XML_TABLE);
            } else {
                s.append(DocumentDAO.METADATA_XML_TABLE);
            }
            s.append(" VALUES (?)");
            this.sql = s.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Connection con) throws SQLException {
            Statement st = null;
            SQLXML xmlObj = null;
            try {
                logger.debug((Object)this.sql);
                st = con.prepareStatement(this.sql);
                xmlObj = con.createSQLXML();
                xmlObj.setString(this.strXml);
                st.setSQLXML(1, xmlObj);
                st.execute();
            }
            finally {
                if (xmlObj != null) {
                    xmlObj.free();
                }
                st.close();
            }
        }

        public String getXMLString() {
            return this.strXml;
        }
    }
}

