/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.metadatamanager.search.ConditionBuilder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateConditionBuilder
extends ConditionBuilder {
    SimpleDateFormat xmlDateFormat = new SimpleDateFormat("'fn:dateTime(xs:date(\"'yyyy-MM-dd'\"), xs:time(\"'HH:mm:ss'\"))'");

    public DateConditionBuilder(Predicate predicate) {
        super(predicate);
    }

    private Date truncateTime(Date date) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        this.truncateTime(cal);
        return cal.getTime();
    }

    private void truncateTime(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    private Date getRelativeDate() {
        PredicateRightValue prv = (PredicateRightValue)this.predicate;
        int numDays = Integer.parseInt((String)prv.getValue().get(0));
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(new Date());
        this.truncateTime(cal);
        cal.add(6, numDays);
        return cal.getTime();
    }

    private Date getFirstDate() {
        PredicateRightValue prv = (PredicateRightValue)this.predicate;
        return this.parseDate((String)prv.getValue().get(0));
    }

    private Date parseDate(String date) {
        String format = "yyyy-MM-dd";
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        try {
            return formatter.parse(date.substring(0, format.length()));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private Date addDays(Date date, int days) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        cal.add(6, days);
        return cal.getTime();
    }

    @Override
    protected String equal() {
        return this.equalDateHelper(this.getFirstDate());
    }

    private String equalDateHelper(Date date) {
        String xpathMinusTail;
        Date startDate = this.truncateTime(date);
        Date endDate = this.addDays(startDate, 1);
        String xpathTail = this.getXpathTail();
        String customCriteria = "";
        if (this.isCustomField()) {
            xpathMinusTail = this.getCustomFieldXpath();
            customCriteria = this.getCustomCriteria();
        } else {
            xpathMinusTail = this.getXpathMinusTail();
        }
        StringBuffer condition = new StringBuffer("xmlexists('$p");
        condition.append(xpathMinusTail);
        condition.append("[");
        condition.append(customCriteria);
        condition.append(xpathTail);
        condition.append(" >= ");
        condition.append(this.xmlDateFormat.format(startDate));
        condition.append(" and ");
        condition.append(xpathTail);
        condition.append(" < ");
        condition.append(this.xmlDateFormat.format(endDate));
        condition.append("]");
        condition.append("' passing sys_nc_rowinfo$ as \"p\")");
        return condition.toString();
    }

    @Override
    protected String greaterThan() {
        Date date = this.addDays(this.truncateTime(this.getFirstDate()), 1);
        return this.buildSimpleCompare(" >= ", date);
    }

    @Override
    protected String greaterThanEqual() {
        Date date = this.truncateTime(this.getFirstDate());
        return this.buildSimpleCompare(" >= ", date);
    }

    @Override
    protected String lessThan() {
        Date date = this.truncateTime(this.getFirstDate());
        return this.buildSimpleCompare(" < ", date);
    }

    @Override
    protected String lessThanEqual() {
        Date date = this.addDays(this.truncateTime(this.getFirstDate()), 1);
        return this.buildSimpleCompare(" < ", date);
    }

    @Override
    protected String notEqual() {
        return this.notEqualHelper(this.getFirstDate());
    }

    private String notEqualHelper(Date date) {
        String xpathMinusTail;
        Date startDate = this.truncateTime(date);
        Date endDate = this.addDays(startDate, 1);
        String xpathTail = this.getXpathTail();
        String customCriteria = "";
        if (this.isCustomField()) {
            xpathMinusTail = this.getCustomFieldXpath();
            customCriteria = this.getCustomCriteria();
        } else {
            xpathMinusTail = this.getXpathMinusTail();
        }
        StringBuffer condition = new StringBuffer("xmlexists('$p");
        condition.append(xpathMinusTail);
        condition.append("[");
        condition.append(customCriteria);
        condition.append("(");
        condition.append(xpathTail);
        condition.append(" < ");
        condition.append(this.xmlDateFormat.format(startDate));
        condition.append(" or ");
        condition.append(xpathTail);
        condition.append(" >= ");
        condition.append(this.xmlDateFormat.format(endDate));
        condition.append(")");
        condition.append("]");
        condition.append("' passing sys_nc_rowinfo$ as \"p\")");
        return condition.toString();
    }

    private String buildSimpleCompare(String operator, Date date) {
        String xpathMinusTail;
        String xpathTail = this.getXpathTail();
        String customCriteria = "";
        if (this.isCustomField()) {
            xpathMinusTail = this.getCustomFieldXpath();
            customCriteria = this.getCustomCriteria();
        } else {
            xpathMinusTail = this.getXpathMinusTail();
        }
        StringBuffer condition = new StringBuffer("xmlexists('$p");
        condition.append(xpathMinusTail);
        condition.append("[");
        condition.append(customCriteria);
        condition.append(xpathTail);
        condition.append(operator);
        condition.append(this.xmlDateFormat.format(date));
        condition.append("]");
        condition.append("' passing sys_nc_rowinfo$ as \"p\")");
        return condition.toString();
    }

    @Override
    protected String lessThanToday() {
        Date date = this.getRelativeDate();
        return this.buildSimpleCompare(" < ", date);
    }

    @Override
    protected String equalToToday() {
        Date date = this.truncateTime(new Date());
        return this.equalDateHelper(date);
    }

    @Override
    protected String notEqualToToday() {
        Date date = this.truncateTime(new Date());
        return this.notEqualHelper(date);
    }

    @Override
    protected String notLessThanToday() {
        Date date = this.getRelativeDate();
        return this.buildSimpleCompare(" >= ", date);
    }

    @Override
    protected String greaterThanToday() {
        Date date = this.addDays(this.getRelativeDate(), 1);
        return this.buildSimpleCompare(" >= ", date);
    }

    @Override
    protected String notGreaterThanToday() {
        Date date = this.addDays(this.getRelativeDate(), 1);
        return this.buildSimpleCompare(" < ", date);
    }

    @Override
    protected String between() {
        String xpathMinusTail;
        Date startDate = this.truncateTime(this.getFirstDate());
        PredicateRightValue prv = (PredicateRightValue)this.predicate;
        Date endDate = this.parseDate((String)prv.getValue().get(1));
        endDate = this.truncateTime(endDate);
        endDate = this.addDays(endDate, 1);
        String xpathTail = this.getXpathTail();
        String customCriteria = "";
        if (this.isCustomField()) {
            xpathMinusTail = this.getCustomFieldXpath();
            customCriteria = this.getCustomCriteria();
        } else {
            xpathMinusTail = this.getXpathMinusTail();
        }
        StringBuffer condition = new StringBuffer("xmlexists('$p");
        condition.append(xpathMinusTail);
        condition.append("[");
        condition.append(customCriteria);
        condition.append(xpathTail);
        condition.append(" >= ");
        condition.append(this.xmlDateFormat.format(startDate));
        condition.append(" and ");
        condition.append(xpathTail);
        condition.append(" < ");
        condition.append(this.xmlDateFormat.format(endDate));
        condition.append("]");
        condition.append("' passing sys_nc_rowinfo$ as \"p\")");
        return condition.toString();
    }
}

