/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.ericsson.cms.criteria.Predicate;
import com.tandbergtv.metadatamanager.search.AssetSearchQueryBuilder;
import com.tandbergtv.metadatamanager.search.ConditionBuilder;

public class StringConditionBuilder
extends ConditionBuilder {
    public StringConditionBuilder(Predicate predicate) {
        super(predicate);
    }

    @Override
    protected String equal() {
        return this.simpleConditionHelper(" = ");
    }

    @Override
    protected String notEqual() {
        return this.simpleConditionHelper(" != ");
    }

    @Override
    protected String getXpathTail() {
        String xpathTail = super.getXpathTail();
        if (this.predicate.getIgnoreCase()) {
            return "fn:upper-case(" + xpathTail + ")";
        }
        return xpathTail;
    }

    @Override
    protected String getRhsValue(int index) {
        StringBuffer sb = new StringBuffer("\"");
        if (this.predicate.getIgnoreCase()) {
            sb.append(super.getRhsValue(index).toUpperCase());
        } else {
            sb.append(super.getRhsValue(index));
        }
        sb.append("\"");
        return sb.toString();
    }

    @Override
    protected String in() {
        return this.inHelper("or", "=");
    }

    @Override
    protected String notIn() {
        return this.inHelper("and", "!=");
    }

    @Override
    protected String contains() {
        return this.containsHelper(">");
    }

    @Override
    protected String notContains() {
        return this.containsHelper("=");
    }

    private String containsHelper(String containsOperator) {
        StringBuffer condition = new StringBuffer("xmlexists('$p");
        String customCriteria = "";
        String tail = "text()";
        String xpath = this.getFullXpath();
        if (xpath.contains("/@")) {
            int attributeIndex = xpath.lastIndexOf("/@");
            tail = xpath.substring(attributeIndex);
            xpath = xpath.substring(0, attributeIndex - 1);
        }
        condition.append(xpath);
        condition.append("[");
        condition.append(customCriteria);
        condition.append("ora:contains(");
        condition.append(tail);
        condition.append(", \"");
        condition.append(AssetSearchQueryBuilder.encodeString(super.getRhsValue(0)));
        condition.append("\") ");
        condition.append(containsOperator);
        condition.append(" 0]");
        condition.append("' passing sys_nc_rowinfo$ as \"p\")");
        return condition.toString();
    }

    @Override
    protected String startsWith() {
        return this.getFuncCondition("fn:starts-with");
    }

    private String getFuncCondition(String function) {
        String xpathMinusTail;
        StringBuffer condition = new StringBuffer("xmlexists('$p");
        String customCriteria = "";
        if (this.isCustomField()) {
            xpathMinusTail = this.getCustomFieldXpath();
            customCriteria = this.getCustFieldName() + " and ";
        } else {
            xpathMinusTail = this.getXpathMinusTail();
        }
        condition.append(xpathMinusTail);
        condition.append("[");
        condition.append(customCriteria);
        condition.append(function);
        condition.append("(");
        condition.append(this.getXpathTail());
        condition.append(", ");
        condition.append(this.getRhsValue(0));
        condition.append(")]");
        condition.append("' passing sys_nc_rowinfo$ as \"p\")");
        return condition.toString();
    }

    @Override
    protected String doesNotStartWith() {
        return "not(" + this.startsWith() + ")";
    }

    @Override
    protected String endsWith() {
        return this.getFuncCondition("fn:ends-with");
    }

    @Override
    protected String doesNotEndWith() {
        return "not(" + this.endsWith() + ")";
    }
}

