/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.util.XPathMappingReader;
import com.tandbergtv.metadatamanager.util.binder.AssetType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class XPathTranslator {
    private static final String TNS_STR = "/tns:";

    public void setPathForAllAssets(Asset rootAsset) {
        this.setAssetPath(rootAsset, null);
    }

    public XPathType getType(String xPath) {
        if (xPath.contains(TNS_STR)) {
            return XPathType.TTV_XPATH;
        }
        if (xPath.contains("/")) {
            return XPathType.ECMF_XPATH;
        }
        return XPathType.ALIAS;
    }

    public String translateTTVtoECMF(String ttvXPath) {
        String ecmfXPath = null;
        Map<String, String> ecmfXpathLookUp = XPathMappingReader.getInstance().getEcmfXpathLookUp();
        String lookUpPath = ecmfXpathLookUp.get(ttvXPath.trim());
        ecmfXPath = lookUpPath != null ? lookUpPath : ttvXPath.replaceAll(TNS_STR, "/");
        return ecmfXPath;
    }

    public String translateECMFtoTTV(String ecmfXPath) {
        String ttvXPath = null;
        Map<String, String> ttvXpathLookUp = XPathMappingReader.getInstance().getTtvXpathLookUp();
        String lookUpPath = ttvXpathLookUp.get(ecmfXPath.trim());
        if (lookUpPath != null) {
            ttvXPath = lookUpPath;
        } else {
            int n = ecmfXPath.lastIndexOf("/@");
            if (n >= 0) {
                String attrName = ecmfXPath.substring(n + 2);
                String tmp = ecmfXPath.substring(0, n);
                StringBuilder b = new StringBuilder(tmp.replaceAll("/", TNS_STR));
                ttvXPath = b.append("/@" + attrName).toString();
            } else {
                ttvXPath = ecmfXPath.replaceAll("/", TNS_STR);
            }
        }
        return ttvXPath;
    }

    public void translateTTVtoECMF(Asset asset) {
        if (asset == null) {
            return;
        }
        String assetPath = asset.getPath();
        if (assetPath == null || assetPath.isEmpty()) {
            Asset rootAsset = asset.getRoot();
            if (rootAsset == null) {
                rootAsset = asset;
            }
            this.setPathForAllAssets(rootAsset);
            assetPath = asset.getPath();
        }
        List<Field> fields = asset.getFields();
        for (Field field : fields) {
            this.translateTTVtoECMF(field);
        }
        for (Relation r : asset.getRelations()) {
            this.translateTTVtoECMF(r.getTargetAsset());
        }
    }

    public void translateECMFtoTTV(Asset asset) {
        if (asset == null) {
            return;
        }
        List<Field> fields = asset.getFields();
        for (Field field : fields) {
            this.translateECMFtoTTV(field);
        }
        for (Relation r : asset.getRelations()) {
            this.translateECMFtoTTV(r.getTargetAsset());
        }
    }

    public String translateAliastoECMF(String alias) {
        StringBuilder b = new StringBuilder("/Fields/");
        String ecmfXPath = b.append(alias.replaceAll("[.]", "/")).toString();
        return ecmfXPath;
    }

    private void setAssetPath(Asset asset, Asset parentAsset) {
        if (asset != null) {
            if (asset.getType() == null) {
                return;
            }
            String assetType = AssetType.valueOf(asset.getType()).toString();
            if (parentAsset != null) {
                asset.setPath(parentAsset.getPath() + "/" + assetType);
            } else {
                asset.setPath("/" + assetType);
            }
        }
        for (Relation r : asset.getRelations()) {
            this.setAssetPath(r.getTargetAsset(), asset);
        }
    }

    private boolean requiresChangeInIndicesForLookUpXpath(String ecmfXpath) {
        if (ecmfXpath.endsWith("Review/Language/@value")) {
            return false;
        }
        if (ecmfXpath.endsWith("Receiver/Version/IntegerValue")) {
            return false;
        }
        return !ecmfXpath.endsWith("TrickModeRestrictions/TrickModeRestriction");
    }

    public void translateTTVtoECMF(Field field) {
        String ttvXPath;
        String ecmfXPath = null;
        Map<String, String> ecmfXpathLookUp = XPathMappingReader.getInstance().getEcmfXpathLookUp();
        String lookUpPath = ecmfXpathLookUp.get((ttvXPath = field.getTtvXPath()).trim());
        if (lookUpPath != null) {
            ecmfXPath = lookUpPath;
            if (!this.requiresChangeInIndicesForLookUpXpath(ecmfXPath)) {
                field.setTtvXPath(ecmfXPath);
                return;
            }
            ArrayList<Integer> newIndices = new ArrayList<Integer>();
            if (!ttvXPath.startsWith("/tns:Fields/tns:TTVId")) {
                List<Integer> indices = field.getIndices();
                if (ecmfXPath.endsWith("RatingValue/Value") || ecmfXPath.endsWith("RatingValue/System")) {
                    for (int i = 0; i < 3; ++i) {
                        newIndices.add(new Integer(1));
                    }
                    newIndices.add(indices.get(2));
                    newIndices.add(new Integer(1));
                } else if (ecmfXPath.startsWith("/Fields/Video/AudioInfos")) {
                    int i;
                    for (i = 0; i < 3; ++i) {
                        newIndices.add(new Integer(1));
                    }
                    for (i = 1; i < indices.size(); ++i) {
                        newIndices.add(indices.get(i));
                    }
                } else if (ecmfXPath.endsWith("Asset/Id")) {
                    for (int i = 0; i < 4; ++i) {
                        newIndices.add(indices.get(i));
                    }
                } else if (ecmfXPath.endsWith("Size/height") || ecmfXPath.endsWith("Size/width")) {
                    newIndices.add(indices.get(0));
                    newIndices.add(new Integer(1));
                    newIndices.add(indices.get(1));
                    newIndices.add(new Integer(1));
                } else {
                    newIndices.add(new Integer(1));
                    for (int i = 0; i < indices.size(); ++i) {
                        newIndices.add(indices.get(i));
                    }
                }
            }
            field.setIndices(newIndices);
        } else {
            ecmfXPath = ttvXPath.replaceAll(TNS_STR, "/");
        }
        field.setTtvXPath(ecmfXPath);
    }

    public void translateECMFtoTTV(Field field) {
        String ecmfXPath;
        String ttvXPath = null;
        Map<String, String> ttvXpathLookUp = XPathMappingReader.getInstance().getTtvXpathLookUp();
        String lookUpPath = ttvXpathLookUp.get((ecmfXPath = field.getTtvXPath()).trim());
        if (lookUpPath != null) {
            ttvXPath = lookUpPath;
            if (!this.requiresChangeInIndicesForLookUpXpath(ecmfXPath)) {
                field.setTtvXPath(ttvXPath);
                return;
            }
            ArrayList<Integer> newIndices = new ArrayList<Integer>();
            if (!ecmfXPath.endsWith("@assetId")) {
                List<Integer> indices = field.getIndices();
                if (ecmfXPath.endsWith("RatingValue/Value") || ecmfXPath.endsWith("RatingValue/System")) {
                    for (int i = 0; i < 2; ++i) {
                        newIndices.add(new Integer(1));
                    }
                    newIndices.add(indices.get(3));
                } else if (ecmfXPath.startsWith("/Fields/Video/AudioInfos")) {
                    newIndices.add(new Integer(1));
                    for (int i = 3; i < indices.size(); ++i) {
                        newIndices.add(indices.get(i));
                    }
                } else if (ecmfXPath.endsWith("Asset/Id")) {
                    for (int i = 0; i < 5; ++i) {
                        newIndices.add(new Integer(1));
                    }
                } else if (ecmfXPath.endsWith("Size/height") || ecmfXPath.endsWith("Size/width")) {
                    newIndices.add(indices.get(0));
                    newIndices.add(indices.get(2));
                } else {
                    for (int i = 1; i < indices.size(); ++i) {
                        newIndices.add(indices.get(i));
                    }
                }
            } else {
                for (int i = 0; i < 3; ++i) {
                    newIndices.add(new Integer(1));
                }
            }
            field.setIndices(newIndices);
        } else {
            int n = ecmfXPath.lastIndexOf("/@");
            if (n >= 0) {
                String attrName = ecmfXPath.substring(n + 2);
                String tmp = ecmfXPath.substring(0, n);
                StringBuilder b = new StringBuilder(tmp.replaceAll("/", TNS_STR));
                ttvXPath = b.append("/@" + attrName).toString();
            } else {
                ttvXPath = ecmfXPath.replaceAll("/", TNS_STR);
            }
        }
        field.setTtvXPath(ttvXPath);
    }

    public static enum XPathType {
        TTV_XPATH,
        ECMF_XPATH,
        ALIAS;

    }
}

