/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.upgrade;

import com.ericsson.cms.upgrade.ATTJob;
import com.ericsson.cms.upgrade.utils.DBUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class InsertATTJobs {
    protected static final Logger logger = Logger.getLogger(InsertATTJobs.class);
    protected static final String PROGRAM_SHORT_NAME = "insertattjobs";
    protected static final String PROGRAM_VERSION_NUMBER = "1.0";
    protected static final String SQL_COUNT_JOBS = "SELECT count(*) from WFS.SCH_JOB";
    protected static final String SQL_DOES_JOB_EXIST = "SELECT count(*) from WFS.SCH_JOB where name = '$jobName'";
    protected static final String TRIGGER_GROUP_WORKFLOW_PMM_JOBS = "Workflow PMM Jobs";
    protected static final String JOB_GROUP_WORKFLOW_PMM_JOBS = "Workflow PMM Jobs";

    public static void main(String[] args) throws Exception {
        logger.info((Object)"In InsertATTJobs.main()...");
        InsertATTJobs insertATTJobs = new InsertATTJobs();
        insertATTJobs.insertATTJobs(args);
    }

    public void insertATTJobs(String[] args) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = DBUtils.getDBConnection(args);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(SQL_COUNT_JOBS);
            int jobsCount = 0;
            if (rs != null && rs.next()) {
                jobsCount = rs.getInt(1);
            }
            logger.info((Object)(jobsCount + " Scheduler Jobs found."));
            this.deleteQuartzPMMJobs(conn, "Workflow PMM Jobs", "Workflow PMM Jobs");
            conn.setAutoCommit(false);
            this.insertATTJobs(conn);
            conn.commit();
            logger.info((Object)"Done inserting ATT jobs...");
        }
        catch (Exception e) {
            logger.error((Object)"Exception occurred while inserting ATT jobs", (Throwable)e);
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    logger.error((Object)"Exception rolling back ATT jobs already inserted", (Throwable)e1);
                }
            }
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Exception occurred while closing database statement after insert jobs", (Throwable)e);
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Exception occurred while closing database connection after insert jobs", (Throwable)e);
            }
        }
    }

    public List<ATTJob> getATTJobs() {
        ArrayList<ATTJob> attJobs = new ArrayList<ATTJob>();
        ATTJob attJob1 = new ATTJob("Remove Old Master Titles", "Purge Master Titles", 31);
        attJobs.add(attJob1);
        ATTJob attJob2 = new ATTJob("Remove Files from Old Titles", "Purge National Titles", 30);
        attJobs.add(attJob2);
        return attJobs;
    }

    public void insertATTJobs(Connection conn) throws SQLException {
        if (conn != null) {
            List<ATTJob> attJobs = this.getATTJobs();
            logger.info((Object)("Inserting ATT Jobs: " + attJobs));
            this.insertATTJobs(conn, attJobs);
        } else {
            logger.error((Object)"Got 'null' database connection. Cannot insert ATT Jobs...");
        }
    }

    public void insertATTJobs(Connection conn, List<ATTJob> attJobs) throws SQLException {
        for (ATTJob attJob : attJobs) {
            this.insertATTJob(conn, attJob);
        }
    }

    public void insertATTJob(Connection conn, ATTJob attJob) throws SQLException {
        if (attJob != null) {
            boolean doesJobExist = this.doesJobExist(conn, attJob);
            String jobName = attJob.getJobName();
            String templateName = attJob.getTemplateName();
            int numDaysAfter = attJob.getNumDaysAfter();
            if (!doesJobExist) {
                this.insertATTJob(conn, jobName, templateName, numDaysAfter);
            } else {
                logger.info((Object)("Job: " + jobName + " already exists. No need to Insert..."));
            }
        } else {
            logger.error((Object)"Got 'null' ATTJob. Cannot insert...");
        }
    }

    public void insertATTJob(Connection conn, String jobName, String templateName, int numDaysAfter) throws SQLException {
        logger.info((Object)("Inserting job, jobName = " + jobName + ", templateName = " + templateName));
        int ruleId = 0;
        String insertSQL = "begin insert into WFS.SCH_RULE (RULETYPEID,STARTDATE,ENDDATE) values (3,to_timestamp(to_char(sysdate + interval '1' day, 'DD-MON-YYYY') || ' 02.00.00.000000000 AM','DD-MON-YYYY HH.MI.SS.FF AM'),null) returning ID_ INTO ?; END;";
        logger.info((Object)("insertSQL = " + insertSQL));
        CallableStatement cs = conn.prepareCall(insertSQL);
        cs.registerOutParameter(1, 2);
        cs.execute();
        ruleId = cs.getInt(1);
        logger.info((Object)("SCH_RULE record inserted. Got ruleId = " + ruleId));
        if (ruleId == 0) {
            logger.error((Object)"Failed to insert job because SCH_RULE record could not be inserted. Returning without inserting...");
            return;
        }
        int jobId = 0;
        insertSQL = "begin insert into WFS.SCH_JOB (NAME,RULEID,ASSOCIATED_ENTITY_TYPE,ASSOCIATION_DESCRIPTION,CALLBACK_CLASS,ACTIVE) values ('" + jobName + "'," + ruleId + ",'SELF','SELF','com.ericsson.cms.scheduler.WOSchedulerCallback',1) returning ID INTO ?; END;";
        logger.info((Object)("insertSQL = " + insertSQL));
        cs = conn.prepareCall(insertSQL);
        cs.registerOutParameter(1, 2);
        cs.execute();
        jobId = cs.getInt(1);
        logger.info((Object)("SCH_JOB record inserted. Got jobId = " + jobId));
        if (jobId == 0) {
            logger.error((Object)"Failed to insert job because SCH_JOB record could not be inserted. Returning without inserting...");
            return;
        }
        Statement updateStmt = conn.createStatement();
        String qrtzJobName = String.valueOf(jobId);
        insertSQL = "insert into WFS.QRTZ_JOB_DETAILS (JOB_NAME,JOB_GROUP,DESCRIPTION,JOB_CLASS_NAME,IS_DURABLE,IS_VOLATILE,IS_STATEFUL,REQUESTS_RECOVERY) values ('" + qrtzJobName + "','CMS',null,'com.ericsson.cms.scheduler.quartz.QuartzCallback','1','1','0','1')";
        logger.info((Object)("insertSQL = " + insertSQL));
        int updateCount = updateStmt.executeUpdate(insertSQL);
        logger.info((Object)(updateCount + " QRTZ_JOB_DETAILS records inserted."));
        String qrtzTriggerName = "TRIGGER_" + qrtzJobName;
        insertSQL = "insert into WFS.QRTZ_TRIGGERS (TRIGGER_NAME,TRIGGER_GROUP,JOB_NAME,JOB_GROUP,IS_VOLATILE,DESCRIPTION,NEXT_FIRE_TIME,PREV_FIRE_TIME,PRIORITY,TRIGGER_STATE,TRIGGER_TYPE,START_TIME,END_TIME,CALENDAR_NAME,MISFIRE_INSTR) values ('" + qrtzTriggerName + "','CMS','" + qrtzJobName + "','CMS','1',null,\n" + "\t(select (extract(day from (to_timestamp_tz(to_char(systimestamp + interval '1' day, 'DD-MON-YYYY \"02:00:00 AM\" TZH:TZM'), 'DD-MON-YYYY HH.MI.SS AM TZH:TZM') - to_timestamp_tz('01-JAN-1970 UTC','DD-MON-YYYY TZR'))) * 24 * 60 * 60\n" + "     + extract(hour from (to_timestamp_tz(to_char(systimestamp + interval '1' day, 'DD-MON-YYYY \"02:00:00 AM\" TZH:TZM'), 'DD-MON-YYYY HH.MI.SS AM TZH:TZM') - to_timestamp_tz('01-JAN-1970 UTC','DD-MON-YYYY TZR'))) *60*60\n" + "     + extract(minute from (to_timestamp_tz(to_char(systimestamp + interval '1' day, 'DD-MON-YYYY \"02:00:00 AM\" TZH:TZM'), 'DD-MON-YYYY HH.MI.SS AM TZH:TZM') - to_timestamp_tz('01-JAN-1970 UTC','DD-MON-YYYY TZR'))) *60\n" + "     + extract(second from (to_timestamp_tz(to_char(systimestamp + interval '1' day, 'DD-MON-YYYY \"02:00:00 AM\" TZH:TZM'), 'DD-MON-YYYY HH.MI.SS AM TZH:TZM') - to_timestamp_tz('01-JAN-1970 UTC','DD-MON-YYYY TZR')))) * 1000 from dual),\n" + "\t-1,5,'WAITING','SIMPLE',\n" + "\t(select (extract(day from (to_timestamp_tz(to_char(systimestamp + interval '1' day, 'DD-MON-YYYY \"02:00:00 AM\" TZH:TZM'), 'DD-MON-YYYY HH.MI.SS AM TZH:TZM') - to_timestamp_tz('01-JAN-1970 UTC','DD-MON-YYYY TZR'))) * 24 * 60 * 60\n" + "     + extract(hour from (to_timestamp_tz(to_char(systimestamp + interval '1' day, 'DD-MON-YYYY \"02:00:00 AM\" TZH:TZM'), 'DD-MON-YYYY HH.MI.SS AM TZH:TZM') - to_timestamp_tz('01-JAN-1970 UTC','DD-MON-YYYY TZR'))) *60*60\n" + "     + extract(minute from (to_timestamp_tz(to_char(systimestamp + interval '1' day, 'DD-MON-YYYY \"02:00:00 AM\" TZH:TZM'), 'DD-MON-YYYY HH.MI.SS AM TZH:TZM') - to_timestamp_tz('01-JAN-1970 UTC','DD-MON-YYYY TZR'))) *60\n" + "     + extract(second from (to_timestamp_tz(to_char(systimestamp + interval '1' day, 'DD-MON-YYYY \"02:00:00 AM\" TZH:TZM'), 'DD-MON-YYYY HH.MI.SS AM TZH:TZM') - to_timestamp_tz('01-JAN-1970 UTC','DD-MON-YYYY TZR')))) * 1000 from dual),\n" + "\t0,null,4)";
        logger.info((Object)("insertSQL = " + insertSQL));
        updateCount = updateStmt.executeUpdate(insertSQL);
        logger.info((Object)(updateCount + " QRTZ_TRIGGERS records inserted."));
        insertSQL = "insert into WFS.QRTZ_SIMPLE_TRIGGERS (TRIGGER_NAME,TRIGGER_GROUP,REPEAT_COUNT,REPEAT_INTERVAL,TIMES_TRIGGERED) values ('" + qrtzTriggerName + "','CMS',-1,86400000,0)";
        logger.info((Object)("insertSQL = " + insertSQL));
        updateCount = updateStmt.executeUpdate(insertSQL);
        logger.info((Object)(updateCount + " QRTZ_SIMPLE_TRIGGERS records inserted."));
        insertSQL = "insert into WFS.QRTZ_TRIGGER_LISTENERS (TRIGGER_NAME,TRIGGER_GROUP,TRIGGER_LISTENER) values ('" + qrtzTriggerName + "','CMS','MissedTriggerListener')";
        logger.info((Object)("insertSQL = " + insertSQL));
        updateCount = updateStmt.executeUpdate(insertSQL);
        logger.info((Object)(updateCount + " QRTZ_TRIGGER_LISTENERS records inserted."));
        insertSQL = "insert into WFS.SCH_RULEPARAMETER (RULEID,VALUE,ORDER_) values (" + ruleId + ",'" + numDaysAfter + "',1)";
        logger.info((Object)("insertSQL = " + insertSQL));
        updateCount = updateStmt.executeUpdate(insertSQL);
        logger.info((Object)(updateCount + " SCH_RULEPARAMETER records inserted."));
        insertSQL = "insert into WFS.SCH_RULEPARAMETER (RULEID,VALUE,ORDER_) values (" + ruleId + ",'after',2)";
        logger.info((Object)("insertSQL = " + insertSQL));
        updateCount = updateStmt.executeUpdate(insertSQL);
        logger.info((Object)(updateCount + " SCH_RULEPARAMETER records inserted."));
        insertSQL = "insert into WFS.SCH_RULEPARAMETER (RULEID,VALUE,ORDER_) values (" + ruleId + ",'$Title Metadata.PACKAGE.TITLE./Fields/Rights/LicensingWindowEnd',3)";
        logger.info((Object)("insertSQL = " + insertSQL));
        updateCount = updateStmt.executeUpdate(insertSQL);
        logger.info((Object)(updateCount + " SCH_RULEPARAMETER records inserted."));
        insertSQL = "insert into WFS.SCH_RULEPARAMETER (RULEID,VALUE,ORDER_) values (" + ruleId + ",'2:00 am',4)";
        logger.info((Object)("insertSQL = " + insertSQL));
        updateCount = updateStmt.executeUpdate(insertSQL);
        logger.info((Object)(updateCount + " SCH_RULEPARAMETER records inserted."));
        insertSQL = "insert into WFS.SCH_WOJOB (JOBID,TEMPLATENAME,PRIORITY) values (" + jobId + ",'" + templateName + "','NORMAL')";
        logger.info((Object)("insertSQL = " + insertSQL));
        updateCount = updateStmt.executeUpdate(insertSQL);
        logger.info((Object)(updateCount + " SCH_WOJOB records inserted."));
        insertSQL = "insert into WFS.SCH_WOJOB_MAPPARAMS (WOJOBID,NAME,VALUE) values (" + jobId + ",'titleId','_autoMapped')";
        logger.info((Object)("insertSQL = " + insertSQL));
        updateCount = updateStmt.executeUpdate(insertSQL);
        logger.info((Object)(updateCount + " SCH_WOJOB_MAPPARAMS records inserted."));
        logger.info((Object)("Done Inserting job, jobName = " + jobName + ", templateName = " + templateName));
    }

    public boolean doesJobExist(Connection conn, ATTJob attJob) throws SQLException {
        boolean doesJobExist = false;
        if (conn != null) {
            if (attJob != null) {
                String jobName = attJob.getJobName();
                Statement stmt = conn.createStatement();
                String querySQL = SQL_DOES_JOB_EXIST.replace("$jobName", jobName);
                ResultSet rs = stmt.executeQuery(querySQL);
                int jobsCount = 0;
                if (rs.next()) {
                    jobsCount = rs.getInt(1);
                    if (jobsCount == 1) {
                        doesJobExist = true;
                    } else if (jobsCount > 1) {
                        logger.error((Object)(jobsCount + " jobs found in db for jobName: " + jobName));
                    }
                }
            }
        } else {
            logger.error((Object)("Got 'null' database connection. Cannot check existence of job: " + attJob));
        }
        return doesJobExist;
    }

    public void deleteAllJobs(String[] args) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DBUtils.getDBConnection(args);
            logger.info((Object)"Deleting All Jobs created previously...");
            conn.setAutoCommit(false);
            this.deleteAllJobs(conn);
            conn.commit();
            logger.info((Object)"Done deleting ATT Jobs");
        }
        catch (Exception e) {
            logger.error((Object)"Exception occurred while deleting ATT jobs", (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"Exception occurred while closing database statement after delete jobs", (Throwable)e);
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"Exception occurred while closing database connection after delete all jobs", (Throwable)e);
            }
        }
    }

    public void deleteQuartzPMMJobs(Connection conn, String triggerGroup, String jobGroup) throws SQLException {
        logger.info((Object)("Starting deleting Quartz Jobs By Trigger Group: " + triggerGroup + ", jobGroup: " + jobGroup));
        Statement deleteStmt = conn.createStatement();
        String deleteSQL = "delete from WFS.QRTZ_TRIGGER_LISTENERS where trigger_group = '" + triggerGroup + "'";
        logger.info((Object)("deleteSQL = " + deleteSQL));
        int deleteCount = deleteStmt.executeUpdate(deleteSQL);
        logger.info((Object)(deleteCount + " QRTZ_TRIGGER_LISTENERS records deleted."));
        deleteSQL = "delete from WFS.QRTZ_SIMPLE_TRIGGERS where trigger_group = '" + triggerGroup + "'";
        logger.info((Object)("deleteSQL = " + deleteSQL));
        deleteCount = deleteStmt.executeUpdate(deleteSQL);
        logger.info((Object)(deleteCount + " QRTZ_SIMPLE_TRIGGERS records deleted."));
        deleteSQL = "delete from WFS.QRTZ_TRIGGERS where trigger_group = '" + triggerGroup + "'";
        logger.info((Object)("deleteSQL = " + deleteSQL));
        deleteCount = deleteStmt.executeUpdate(deleteSQL);
        logger.info((Object)(deleteCount + " QRTZ_TRIGGERS records deleted."));
        deleteSQL = "delete from WFS.QRTZ_JOB_DETAILS where job_group = '" + jobGroup + "'";
        logger.info((Object)("deleteSQL = " + deleteSQL));
        deleteCount = deleteStmt.executeUpdate(deleteSQL);
        logger.info((Object)(deleteCount + " QRTZ_JOB_DETAILS records deleted."));
        logger.info((Object)("Done deleting Quartz Jobs By Trigger Group: " + triggerGroup + ", jobGroup: " + jobGroup));
    }

    public void deleteAllJobs(Connection conn) throws SQLException {
        Statement deleteStmt = conn.createStatement();
        String deleteSQL = "delete from WFS.SCH_RULEPARAMETER";
        logger.info((Object)("deleteSQL = " + deleteSQL));
        int deleteCount = deleteStmt.executeUpdate(deleteSQL);
        logger.info((Object)(deleteCount + " SCH_RULEPARAMETER records deleted."));
        deleteSQL = "delete from WFS.SCH_WOJOB_MAPPARAMS";
        logger.info((Object)("deleteSQL = " + deleteSQL));
        deleteCount = deleteStmt.executeUpdate(deleteSQL);
        logger.info((Object)(deleteCount + " SCH_WOJOB_MAPPARAMS records deleted."));
        deleteSQL = "delete from WFS.SCH_WOJOB";
        logger.info((Object)("deleteSQL = " + deleteSQL));
        deleteCount = deleteStmt.executeUpdate(deleteSQL);
        logger.info((Object)(deleteCount + " SCH_WOJOB records deleted."));
        deleteSQL = "delete from WFS.SCH_JOB";
        logger.info((Object)("deleteSQL = " + deleteSQL));
        deleteCount = deleteStmt.executeUpdate(deleteSQL);
        logger.info((Object)(deleteCount + " SCH_JOB records deleted."));
        deleteSQL = "delete from WFS.SCH_RULE";
        logger.info((Object)("deleteSQL = " + deleteSQL));
        deleteCount = deleteStmt.executeUpdate(deleteSQL);
        logger.info((Object)(deleteCount + " SCH_RULE records deleted."));
        deleteSQL = "delete from WFS.QRTZ_TRIGGER_LISTENERS";
        logger.info((Object)("deleteSQL = " + deleteSQL));
        deleteCount = deleteStmt.executeUpdate(deleteSQL);
        logger.info((Object)(deleteCount + " QRTZ_TRIGGER_LISTENERS records deleted."));
        deleteSQL = "delete from WFS.QRTZ_SIMPLE_TRIGGERS";
        logger.info((Object)("deleteSQL = " + deleteSQL));
        deleteCount = deleteStmt.executeUpdate(deleteSQL);
        logger.info((Object)(deleteCount + " QRTZ_SIMPLE_TRIGGERS records deleted."));
        deleteSQL = "delete from WFS.QRTZ_TRIGGERS";
        logger.info((Object)("deleteSQL = " + deleteSQL));
        deleteCount = deleteStmt.executeUpdate(deleteSQL);
        logger.info((Object)(deleteCount + " QRTZ_TRIGGERS records deleted."));
        deleteSQL = "delete from WFS.QRTZ_JOB_DETAILS";
        logger.info((Object)("deleteSQL = " + deleteSQL));
        deleteCount = deleteStmt.executeUpdate(deleteSQL);
        logger.info((Object)(deleteCount + " QRTZ_JOB_DETAILS records deleted."));
    }
}

