/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.upgrade;

import com.ericsson.cms.upgrade.utils.DBUtils;
import java.sql.Connection;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class PermissionsManager {
    protected static final Logger logger = Logger.getLogger(PermissionsManager.class);
    protected static final String SQL_UPDATE_RENAME_JOBS_MODULE = "update cms_module set modulename = 'Scheduler', displayname = 'Job Scheduler' where modulename = 'Jobs'";

    public static void main(String[] args) throws Exception {
        logger.info((Object)"In PermissionsManager.main()...");
        PermissionsManager permissionsManager = new PermissionsManager();
        permissionsManager.renameJobsModule(args);
    }

    public void renameJobsModule(String[] args) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DBUtils.getDBConnection(args);
            stmt = conn.createStatement();
            String updateSQL = SQL_UPDATE_RENAME_JOBS_MODULE;
            logger.info((Object)("updateSQL = " + updateSQL));
            int updateCount = stmt.executeUpdate(updateSQL);
            logger.info((Object)("renameJobsModule updateCount = " + updateCount));
            if (updateCount < 1) {
                logger.warn((Object)"No 'Jobs' modules were renamed to 'Scheduler'.");
            } else if (updateCount == 1) {
                logger.info((Object)"'Jobs' module renamed to 'Scheduler'.");
            } else {
                logger.warn((Object)(updateCount + " 'Jobs' modules renamed to 'Scheduler'! Only 1 'Jobs' module should have been renamed..."));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception occurred while renaming 'Jobs' module to 'Scheduler'", (Throwable)e);
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    logger.error((Object)"Exception rolling back renaming 'Jobs' module", (Throwable)e1);
                }
            }
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Exception occurred while closing database statement after renaming 'Jobs' module", (Throwable)e);
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Exception occurred while closing database connection after renaming 'Jobs' module", (Throwable)e);
            }
        }
    }
}

