/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.communication.config;

import com.tandbergtv.watchpoint.communication.config.MessageConfiguration;
import com.tandbergtv.watchpoint.communication.config.MessageHandler;
import com.tandbergtv.watchpoint.communication.config.MessageHandlerConfigReader;
import com.tandbergtv.watchpoint.communication.config.MessageHandlerConfigurationException;
import java.io.InputStream;
import java.util.Map;

public class MessageHandlerFactory {
    private Map<String, MessageConfiguration> configurationMap = null;

    public MessageHandlerFactory(InputStream inStream) throws MessageHandlerConfigurationException {
        this.configurationMap = MessageHandlerConfigReader.readConfiguration(inStream);
    }

    public MessageHandler getMessageHandler(String messageUID) throws MessageHandlerConfigurationException {
        MessageConfiguration config;
        String className;
        if (messageUID != null) {
            messageUID = messageUID.trim();
        }
        String string = className = (config = this.configurationMap.get(messageUID)) != null ? config.getHandlerClassName() : null;
        if (className == null) {
            String msg = "The Message UID: " + messageUID + " does not have a Message Handler configured for it.";
            throw new MessageHandlerConfigurationException(msg);
        }
        return this.loadMessageHandler(className);
    }

    public boolean isMessageAsynchronous(String messageUID) throws MessageHandlerConfigurationException {
        MessageConfiguration config;
        if (messageUID != null) {
            messageUID = messageUID.trim();
        }
        if ((config = this.configurationMap.get(messageUID)) == null) {
            String msg = "The Message UID: " + messageUID + " is not configured and cannot be handled.";
            throw new MessageHandlerConfigurationException(msg);
        }
        return !config.isSynchronous();
    }

    public String getResponseUID(String messageUID) throws MessageHandlerConfigurationException {
        MessageConfiguration config;
        if (messageUID != null) {
            messageUID = messageUID.trim();
        }
        if ((config = this.configurationMap.get(messageUID)) == null) {
            String msg = "The Message UID: " + messageUID + " is not configured and cannot be handled.";
            throw new MessageHandlerConfigurationException(msg);
        }
        return config.getResponseUID();
    }

    private MessageHandler loadMessageHandler(String className) throws MessageHandlerConfigurationException {
        Object handlerClass = null;
        try {
            Class<?> refClass = Class.forName(className);
            handlerClass = refClass.newInstance();
        }
        catch (Exception ex) {
            String msg = "Failed to create instance of Message Handler class: " + className;
            throw new MessageHandlerConfigurationException(msg, ex);
        }
        if (!(handlerClass instanceof MessageHandler)) {
            String msg = "The configured Message Handler class: " + className + " does not implement: " + MessageHandler.class.getName();
            throw new MessageHandlerConfigurationException(msg);
        }
        return handlerClass;
    }
}

