/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.partner.scheduling;

import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.scheduler.ActionContext;
import com.ericsson.cms.scheduler.ExecutionContext;
import com.ericsson.cms.scheduler.IWOSchedulerClient;
import com.ericsson.cms.scheduler.Node;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.partner.scheduling.TitleMetadataOptionProvider;
import com.tandbergtv.watchpoint.pmm.partner.scheduling.Util;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class SelfPartnerWOSchedulerClient
implements IWOSchedulerClient {
    private static final String FILTER_NAME_PREFIX = "$Title Metadata.";
    private static final String FILTER_NAME_SEPARATOR = ".";
    private static final String ASSET_TYPE_SEPARATOR = "/";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private ITitleSearchService searchService = (ITitleSearchService)InjectionUtil.injectInstance((String)"cms/TitleSearchServiceProxy/local", ITitleSearchService.class);

    public String getName() {
        return PartnerType.SELF.name();
    }

    public String getDisplayName() {
        return "Self Partner";
    }

    public Map<Long, String> getAllEntities() {
        return null;
    }

    public List<Node> getParametersForFilter() {
        ArrayList<Node> roots = new ArrayList<Node>();
        roots.add(new TitleMetadataOptionProvider().getJobRuleMenuOptions());
        return roots;
    }

    public List<Node> getParametersForWorkOrderMapping(boolean associatedWithTitles) {
        ArrayList<Node> rootList = new ArrayList<Node>();
        rootList.add(Util.getPartnerParameters());
        return rootList;
    }

    public Map<String, String> getParameterValuesForWorkOrderMapping(Long associatedEntityId) {
        return Util.getPartnerParameterValues(this.getSelfPartner());
    }

    public ExecutionContext getExecutionContext(Long associatedEntityId, String filterName, Date filterValue) {
        ExecutionContext ec = new ExecutionContext();
        ec.setCommonWOParams(Util.getPartnerParameterValues(this.getSelfPartner()));
        filterName = filterName.substring(FILTER_NAME_PREFIX.length());
        String[] filterNamePartsArray = filterName.split("\\.");
        int numFilterNameParts = filterNamePartsArray.length;
        String xpath = filterNamePartsArray[numFilterNameParts - 1];
        String assetType = filterNamePartsArray[0];
        for (int i = 1; i < numFilterNameParts - 1; ++i) {
            assetType = assetType + ASSET_TYPE_SEPARATOR + filterNamePartsArray[i];
        }
        ArrayList<String> metaValues = new ArrayList<String>();
        String metaValue = DATE_FORMAT.format(filterValue);
        metaValues.add(metaValue);
        PredicateRightValue metaCond = new PredicateRightValue(xpath, assetType, FieldType.ASSET, metaValues, LogicalOperator.EQUAL, Boolean.valueOf(false));
        ExpValue condition = new ExpValue((Predicate)metaCond);
        List titleIds = this.searchService.getTitleIds((ExpNode)condition);
        if (titleIds != null) {
            for (Long titleId : titleIds) {
                ActionContext ac = new ActionContext();
                ac.setTitleId(titleId.longValue());
                ec.add(ac);
            }
        }
        return ec;
    }

    public String getAssociationDescription(List<Long> associatedEntityIds) {
        String associationDescription = this.getName();
        return associationDescription;
    }

    private Partner getSelfPartner() {
        IPartnerManagement partnerManager = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
        List partners = partnerManager.getAllActivePartners();
        if (partners != null) {
            for (Partner partner : partners) {
                if (partner.getType() != PartnerType.SELF) continue;
                return partner;
            }
        }
        return null;
    }
}

