/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.ingest;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.entities.FileSearchResult;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.watchpoint.pmm.core.AssetsManager;
import com.tandbergtv.watchpoint.pmm.core.ITitleStatusService;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.TitleDocumentActionException;
import com.tandbergtv.watchpoint.pmm.title.TitleStatusService;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.ingest.ContentMapping;
import com.tandbergtv.watchpoint.pmm.title.ingest.FileMapResult;
import com.tandbergtv.watchpoint.pmm.title.ingest.ITitleIngestService;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleAsset;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleAssetMapping;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestException;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestResult;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.aspectj.runtime.internal.AroundClosure;
import org.w3c.dom.Document;

public class TitleIngestService
implements ITitleIngestService {
    private ITitleManager titleManager;
    private IContentClassService contentClassService;
    private IPartnerManagement partnerManagement;
    private ITitleStatusService statusService;
    private ITitleSearchService titleSearchService;

    public void start() {
        this.titleManager = this.getService(ITitleManager.class);
        this.contentClassService = this.getService(IContentClassService.class);
        this.partnerManagement = this.getService(IPartnerManagement.class);
        this.statusService = new TitleStatusService();
        this.titleSearchService = this.getService(ITitleSearchService.class);
    }

    public void stop() {
        this.titleManager = null;
        this.contentClassService = null;
        this.partnerManagement = null;
        this.statusService = null;
        this.titleSearchService = null;
    }

    public String getServiceName() {
        return "Title Ingest Service";
    }

    @Transactional
    public ContentMapping getMappingForMetadata(String metadataPath) throws TitleIngestException {
        String string = metadataPath;
        return (ContentMapping)TitleIngestService.getMappingForMetadata_aroundBody1$advice(this, string, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("getMappingForMetadata", String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public ContentMapping getMappingForContent(String assetPath, String providerId) {
        String string = assetPath;
        String string2 = providerId;
        return (ContentMapping)TitleIngestService.getMappingForContent_aroundBody3$advice(this, string, string2, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("getMappingForContent", String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public TitleIngestResult createTitleForPackage(String metadataPath, String assetFolderPath, String providerId, String contentClassName, ITitleActionSource source) throws TitleIngestException {
        String string = metadataPath;
        String string2 = assetFolderPath;
        String string3 = providerId;
        String string4 = contentClassName;
        ITitleActionSource iTitleActionSource = source;
        return (TitleIngestResult)TitleIngestService.createTitleForPackage_aroundBody5$advice(this, string, string2, string3, string4, iTitleActionSource, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("createTitleForPackage", String.class, String.class, String.class, String.class, ITitleActionSource.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public TitleIngestResult updateTitleForPackage(String metadataPath, String assetFolderPath, Long titleId, ITitleActionSource source) throws TitleIngestException {
        String string = metadataPath;
        String string2 = assetFolderPath;
        Long l = titleId;
        ITitleActionSource iTitleActionSource = source;
        return (TitleIngestResult)TitleIngestService.updateTitleForPackage_aroundBody7$advice(this, string, string2, l, iTitleActionSource, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("updateTitleForPackage", String.class, String.class, Long.class, ITitleActionSource.class).getAnnotation(Transactional.class), null);
    }

    private Map<String, FileMapResult> mapFilesForPackage(String metadataPath, String assetFolderPath, Title title) throws TitleIngestException {
        FileMapResult metadataMapping = this.mapFile(title, title.getAsset(), metadataPath, true);
        List<String> assetFilePaths = this.getAssetsInFolder(assetFolderPath);
        List<FileMapResult> contentMappings = this.mapContentFiles(title, assetFilePaths);
        HashMap<String, FileMapResult> mappings = new HashMap<String, FileMapResult>();
        mappings.put(metadataPath, metadataMapping);
        for (FileMapResult fmr : contentMappings) {
            mappings.put(fmr.getPath(), fmr);
        }
        return mappings;
    }

    private List<String> getAssetsInFolder(String assetFolderPath) throws TitleIngestException {
        File assetsFolder = this.getFolder(assetFolderPath);
        ArrayList<String> result = new ArrayList<String>();
        for (File f : assetsFolder.listFiles()) {
            if (this.isMetadataFile(f) || f.isDirectory()) continue;
            result.add(f.getAbsolutePath());
        }
        return result;
    }

    private List<FileMapResult> mapContentFiles(Title title, List<String> assetFilePaths) throws TitleIngestException {
        ArrayList<FileMapResult> result = new ArrayList<FileMapResult>();
        for (String assetPath : assetFilePaths) {
            String assetFileName = new File(assetPath).getName();
            Asset matchingAsset = this.findAssetWithFileName(title, assetFileName);
            if (matchingAsset == null) {
                FileMapResult noMappingResult = new FileMapResult(assetPath, null, null, false);
                result.add(noMappingResult);
                continue;
            }
            FileMapResult fileMappingResult = this.mapFile(title, matchingAsset, assetPath, false);
            result.add(fileMappingResult);
        }
        return result;
    }

    public String getMetadataPathForPackage(String packageFolderPath) throws TitleIngestException {
        File[] packageFiles;
        String result = null;
        File packageFolder = this.getFolder(packageFolderPath);
        for (File f : packageFiles = packageFolder.listFiles()) {
            if (!this.isMetadataFile(f)) continue;
            if (result != null) {
                throw new TitleIngestException("The folder " + packageFolderPath + " contains more than one xml file.");
            }
            result = f.getAbsolutePath();
        }
        if (result == null) {
            throw new TitleIngestException("The folder " + packageFolderPath + " does not contain an xml file.");
        }
        return result;
    }

    @Transactional
    public TitleIngestResult createTitleForMetadata(String metadataPath, String providerId, String contentClassName, ITitleActionSource source) throws TitleIngestException {
        String string = metadataPath;
        String string2 = providerId;
        String string3 = contentClassName;
        ITitleActionSource iTitleActionSource = source;
        return (TitleIngestResult)TitleIngestService.createTitleForMetadata_aroundBody9$advice(this, string, string2, string3, iTitleActionSource, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("createTitleForMetadata", String.class, String.class, String.class, ITitleActionSource.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public TitleIngestResult updateTitleForMetadata(String metadataPath, Long titleId, ITitleActionSource source) throws TitleIngestException {
        String string = metadataPath;
        Long l = titleId;
        ITitleActionSource iTitleActionSource = source;
        return (TitleIngestResult)TitleIngestService.updateTitleForMetadata_aroundBody11$advice(this, string, l, iTitleActionSource, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("updateTitleForMetadata", String.class, Long.class, ITitleActionSource.class).getAnnotation(Transactional.class), null);
    }

    private Map<String, FileMapResult> mapMetadata(String metadataPath, Title title) throws TitleIngestException {
        HashMap<String, FileMapResult> result = new HashMap<String, FileMapResult>();
        FileMapResult mapping = this.mapFile(title, title.getAsset(), metadataPath, true);
        result.put(metadataPath, mapping);
        return result;
    }

    @Transactional
    public List<Asset> getContentAssets(Long titleId) throws TitleIngestException {
        Long l = titleId;
        return (List)TitleIngestService.getContentAssets_aroundBody13$advice(this, l, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("getContentAssets", Long.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Collection<TitleAssetMapping> getUnmappedContentForTitle(Long titleId) throws TitleIngestException {
        Long l = titleId;
        return (Collection)TitleIngestService.getUnmappedContentForTitle_aroundBody15$advice(this, l, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("getUnmappedContentForTitle", Long.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public TitleAssetMapping getUnmappedContentForTitleAsset(Long titleId, Long assetId) throws TitleIngestException {
        Long l = titleId;
        Long l2 = assetId;
        return (TitleAssetMapping)TitleIngestService.getUnmappedContentForTitleAsset_aroundBody17$advice(this, l, l2, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("getUnmappedContentForTitleAsset", Long.class, Long.class).getAnnotation(Transactional.class), null);
    }

    private TitleAssetMapping getUnmappedContentForTitleAsset(Title title, Asset asset, String providerId) throws TitleIngestException {
        TitleAsset titleAsset = new TitleAsset(title.getId(), Long.valueOf(asset.getId()));
        Collection<String> filePaths = this.findUnmappedContentFilesMatchingAsset(providerId, asset);
        return new TitleAssetMapping(titleAsset, filePaths);
    }

    private Collection<String> findUnmappedContentFilesMatchingAsset(String providerId, Asset asset) throws TitleIngestException {
        String fileName = this.getAssetFileName(asset);
        try {
            List<File> unmappedFiles = this.getAssetsManager().getUnmappedFiles(fileName, providerId);
            ArrayList<String> result = new ArrayList<String>(unmappedFiles.size());
            for (File uf : unmappedFiles) {
                result.add(uf.getAbsolutePath());
            }
            return result;
        }
        catch (IOException e) {
            String msg = "Failed to get unmapped file paths for file name: " + fileName + ", error: " + e.getLocalizedMessage();
            throw new TitleIngestException(msg, (Throwable)e);
        }
    }

    @Transactional
    public TitleIngestResult updateTitleForContent(String assetPath, Long titleId, ITitleActionSource source) throws TitleIngestException {
        String string = assetPath;
        Long l = titleId;
        ITitleActionSource iTitleActionSource = source;
        return (TitleIngestResult)TitleIngestService.updateTitleForContent_aroundBody19$advice(this, string, l, iTitleActionSource, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("updateTitleForContent", String.class, Long.class, ITitleActionSource.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public TitleIngestResult updateTitleForContent(String assetPath, Long titleId, Long assetId, ITitleActionSource source) throws TitleIngestException {
        String string = assetPath;
        Long l = titleId;
        Long l2 = assetId;
        ITitleActionSource iTitleActionSource = source;
        return (TitleIngestResult)TitleIngestService.updateTitleForContent_aroundBody21$advice(this, string, l, l2, iTitleActionSource, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("updateTitleForContent", String.class, Long.class, Long.class, ITitleActionSource.class).getAnnotation(Transactional.class), null);
    }

    private Asset getSingleAssetInTitle(String assetPath, Long titleId, Title title) throws TitleIngestException {
        String assetName = new File(assetPath).getName();
        Asset asset = this.findAssetWithFileName(title, assetName);
        if (asset == null) {
            throw new TitleIngestException("There should be one asset with name " + assetName + " in the title[" + titleId + "], but none were found.");
        }
        return asset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TitleIngestResult updateTitleForContent(String assetPath, Title title, Asset asset, ITitleActionSource source) throws TitleIngestException {
        ISavedTitle savedTitle;
        Long plannerId;
        Map<String, FileMapResult> mappings;
        AssetsManager.getThreadLocalInstance().beginTransaction();
        boolean success = false;
        try {
            mappings = this.mapContent(title, asset, assetPath);
            plannerId = this.getPlannerId(title);
            savedTitle = this.saveTitle(title, source);
            success = true;
        }
        finally {
            if (success) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                AssetsManager.getThreadLocalInstance().rollbackTransaction();
            }
        }
        TitleIngestResult result = new TitleIngestResult(savedTitle, mappings, plannerId);
        this.sendProgressUpdateForAssets(result, source);
        return result;
    }

    private Map<String, FileMapResult> mapContent(Title title, Asset asset, String assetPath) throws TitleIngestException {
        HashMap<String, FileMapResult> result = new HashMap<String, FileMapResult>();
        FileMapResult mapping = this.moveAndMapFile(title, asset, assetPath, false);
        result.put(assetPath, mapping);
        return result;
    }

    public String generateUnmappedContentPath(String contentFilePath, String providerId) {
        if (contentFilePath == null) {
            throw new IllegalArgumentException("contentFilePath can't be null");
        }
        if (providerId == null) {
            throw new IllegalArgumentException("providerId can't be null");
        }
        String fileName = new File(contentFilePath).getName();
        return this.getUnmappedFilesDirectory() + File.separator + providerId + File.separator + fileName + "_" + System.currentTimeMillis() + File.separator + fileName;
    }

    private Title createTitleForDocument(MetadataDocument document, String providerId, String contentClassName) throws TitleIngestException {
        try {
            Title title = new Title();
            Asset mergedAsset = this.mergeDocument(null, document);
            title.setAsset(mergedAsset);
            title.setPartnerId(this.getPartnerId(providerId));
            title.setContentClassId(this.getContentClassId(contentClassName));
            this.contentClassService.applyContentClassMetadataForIngest(title);
            return title;
        }
        catch (MetadataException e) {
            throw new TitleIngestException("Failed to create title with " + document + ", error: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (ContentClassPersistenceException e) {
            throw new TitleIngestException("Error applying content class when creating title with " + document + ", error: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private Title updateTitleForDocument(Long titleId, MetadataDocument document) throws TitleIngestException {
        try {
            Title title = this.getTitleForIngest(titleId);
            Long rootAssetId = title.getAsset().getId();
            Asset mergedAsset = this.mergeDocument(rootAssetId, document);
            title.setAsset(mergedAsset);
            this.contentClassService.applyContentClassMetadataForIngest(title);
            return title;
        }
        catch (MetadataException e) {
            throw new TitleIngestException("Failed to update title[" + titleId + "] with " + document + ", error: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (ContentClassPersistenceException e) {
            throw new TitleIngestException("Error applying content class when updating title[" + titleId + "] with " + document + ", error: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private Title getTitle(long titleId) throws TitleIngestException {
        Title title = this.titleManager.get(Long.valueOf(titleId));
        if (!title.getIsActive().booleanValue()) {
            String msg = "Title[" + titleId + "] is not active.";
            throw new TitleIngestException(msg);
        }
        return title;
    }

    private Title getTitleForIngest(long titleId) throws TitleIngestException {
        Title title = this.titleManager.getForUpdate(Long.valueOf(titleId));
        if (!title.getIsActive().booleanValue()) {
            String msg = "Title[" + titleId + "] is not active.";
            throw new TitleIngestException(msg);
        }
        if (title.isCopy()) {
            String msg = "Title[" + titleId + "] is a copy.";
            throw new TitleIngestException(msg);
        }
        return title;
    }

    private ISavedTitle saveTitle(Title title, ITitleActionSource source) throws TitleIngestException {
        ISavedTitle savedTitle = null;
        try {
            savedTitle = this.titleManager.save(title, source);
        }
        catch (TitleValidationException e) {
            throw new TitleIngestException(e.getLocalizedMessage(), (Throwable)e);
        }
        return savedTitle;
    }

    private Asset findAssetWithFileName(Title title, String fileName) throws TitleIngestException {
        if (title == null || title.getAsset() == null) {
            return null;
        }
        Asset result = null;
        for (Asset a : title.getAllAssets(false)) {
            if (!fileName.equals(this.getAssetFileName(a))) continue;
            if (result != null) {
                throw new TitleIngestException("Title has more than one asset with content file name: " + fileName);
            }
            result = a;
        }
        return result;
    }

    private String getAssetFileName(Asset asset) {
        Field fileNameField = asset.getFirstField(FieldName.URL.toString());
        if (fileNameField == null || fileNameField.getValue() == null) {
            return null;
        }
        String fileNameValue = fileNameField.getValue();
        int pathSeperaterIndex = fileNameValue.lastIndexOf(File.separator);
        if (pathSeperaterIndex < 0) {
            return fileNameValue;
        }
        return fileNameValue.substring(pathSeperaterIndex + 1, fileNameValue.length());
    }

    private boolean assetHasContentUrl(Asset asset) {
        return !this.isEmpty(this.getAssetFileName(asset));
    }

    private MetadataDocument createDocument(String filePath) throws TitleIngestException {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            document = docBuilder.parse(new File(filePath));
        }
        catch (Exception e) {
            throw new TitleIngestException("Unable to parse the metadata file: " + filePath, (Throwable)e);
        }
        return new MetadataDocument(filePath, document);
    }

    private void validateDocumentForTitle(MetadataDocument metadataDocument, Long titleId) throws TitleIngestException {
        Long matchedTitleId = this.getTitleID(metadataDocument);
        if (matchedTitleId != null && !matchedTitleId.equals(titleId)) {
            String specificationName = this.getSpecHandler(metadataDocument).getSpecName();
            String operation = titleId != null ? "update title[" + titleId + "]" : "create title";
            String msg = "Could not " + operation + " for " + metadataDocument + ", title[" + matchedTitleId + "] has the same " + specificationName + " specification key.";
            throw new TitleIngestException(msg);
        }
    }

    private Long getTitleID(MetadataDocument metadataDocument) throws TitleIngestException {
        try {
            List titleIds = this.titleManager.getTitleIDs(metadataDocument.document);
            if (titleIds.size() != 1) {
                String msg = "There should be only one root asset in " + metadataDocument;
                throw new TitleIngestException(msg);
            }
            return (Long)titleIds.get(0);
        }
        catch (TitleDocumentActionException ex) {
            String msg = "Failed to determine title for " + metadataDocument + ", error: " + ex.getLocalizedMessage();
            throw new TitleIngestException(msg, (Throwable)ex);
        }
    }

    private Asset mergeDocument(Long rootAssetId, MetadataDocument document) throws TitleIngestException, MetadataException {
        ISpecHandler specHandler = this.getSpecHandler(document);
        List mergedAssets = null;
        mergedAssets = rootAssetId == null ? specHandler.mergeWithoutSave(document.document) : specHandler.mergeWithoutSave(rootAssetId, document.document);
        if (mergedAssets.size() != 1) {
            String msg = "The mergeWithoutSave operation should return exactly one asset, but " + mergedAssets.size() + " were found when merging " + document;
            throw new TitleIngestException(msg);
        }
        return (Asset)mergedAssets.get(0);
    }

    private ISpecHandler getSpecHandler(MetadataDocument document) throws TitleIngestException {
        ISpecHandler handler;
        ISpecificationManager service = this.getService(ISpecificationManager.class);
        Specification specification = service.getSpecificationForDocument(document.document);
        ISpecHandler iSpecHandler = handler = specification != null ? specification.getSpecHandler() : null;
        if (handler == null) {
            String msg = "Failed to match a specification for " + document + ". Check your license or the specification plugin(s).";
            throw new TitleIngestException(msg);
        }
        return handler;
    }

    private File getFolder(String folderPath) throws TitleIngestException {
        if (folderPath == null) {
            throw new IllegalArgumentException("folderPath can't be null");
        }
        File result = new File(folderPath);
        if (!result.exists()) {
            throw new TitleIngestException("The folder " + folderPath + " doesn't exist.");
        }
        if (!result.isDirectory()) {
            throw new TitleIngestException("The path " + folderPath + " is not a directory.");
        }
        return result;
    }

    private boolean isMetadataFile(File f) {
        return f.getName().toLowerCase().endsWith(".xml");
    }

    private FileMapResult moveAndMapFile(Title title, Asset asset, String filePath, boolean isMetadata) throws TitleIngestException {
        File mappedFile = new File(filePath);
        if (this.getAssetsManager().isUnmappedFilePath(filePath)) {
            mappedFile = this.moveToMappedLocation(mappedFile);
        }
        return this.mapFile(title, asset, mappedFile.getAbsolutePath(), isMetadata);
    }

    private File moveToMappedLocation(File file) throws TitleIngestException {
        try {
            return this.getAssetsManager().moveToMappedFilesDirectory(file);
        }
        catch (IOException e) {
            throw new TitleIngestException("Failed to move file " + file.getAbsolutePath() + " to the mapped folder location, error:" + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private FileMapResult mapFile(Title title, Asset asset, String filePath, boolean isMetadata) throws TitleIngestException {
        File file = new File(filePath);
        String size = null;
        try {
            size = String.valueOf(file.length());
        }
        catch (Exception e) {
            // empty catch block
        }
        com.tandbergtv.metadatamanager.model.File newFile = this.titleManager.createOriginalFile();
        newFile.addField(new Field(FieldName.FILE_URL.toString(), filePath));
        if (size != null) {
            newFile.addField(new Field(FieldName.FILE_SIZE.toString(), size));
        }
        title.addFile(asset, newFile);
        return new FileMapResult(filePath, asset, newFile, isMetadata);
    }

    private String getUnmappedFilesDirectory() {
        return this.getAssetsManager().getUnmappedFilesDirectory().getAbsolutePath();
    }

    private AssetsManager getAssetsManager() {
        return AssetsManager.getThreadLocalInstance();
    }

    private void sendProgressUpdateForAssets(TitleIngestResult titleIngestResult, ITitleActionSource source) {
        Title ingestedTitle = titleIngestResult.getSavedTitle().getTitle();
        Long plannerId = titleIngestResult.getPlannerId();
        String sourceComponentName = source.getComponentName();
        String sourceEntityName = source.getEntityName();
        String sourceId = source.getID();
        Collection fileMappings = titleIngestResult.getMappings().values();
        for (FileMapResult fileMap : fileMappings) {
            if (fileMap.isMetadata() || !fileMap.isMapped()) continue;
            String assetType = fileMap.getParentAsset().getAssetType();
            this.statusService.sendAssetReceivedStatus(ingestedTitle, assetType, plannerId, sourceComponentName, sourceEntityName, sourceId);
        }
    }

    private void sendProgressUpdateForMetadata(TitleIngestResult titleIngestResult, ITitleActionSource source) {
        Title ingestedTitle = titleIngestResult.getSavedTitle().getTitle();
        Long plannerId = titleIngestResult.getPlannerId();
        String sourceComponentName = source.getComponentName();
        String sourceEntityName = source.getEntityName();
        String sourceId = source.getID();
        this.statusService.sendMetadataReceivedStatus(ingestedTitle, plannerId, sourceComponentName, sourceEntityName, sourceId);
    }

    private Long getPartnerId(String providerId) throws TitleIngestException {
        Partner sourceOrSelfPartner = this.partnerManagement.getSourceOrSelfPartner(providerId);
        if (sourceOrSelfPartner == null) {
            throw new TitleIngestException("Could not find any source or self partner with providerId " + providerId);
        }
        return sourceOrSelfPartner.getId();
    }

    private String getProviderId(Title title) {
        Partner partner = this.partnerManagement.getPartner(title.getPartnerId().longValue());
        return partner.getProviderId();
    }

    private Long getContentClassId(String contentClassName) throws TitleIngestException {
        try {
            if (this.isEmpty(contentClassName)) {
                return this.contentClassService.getDefaultContentClassId();
            }
            Long id = this.contentClassService.getContentClassIdByName(contentClassName);
            if (id == null) {
                String msg = "The content class[" + contentClassName + "] was not found.";
                throw new TitleIngestException(msg);
            }
            return id;
        }
        catch (ContentClassPersistenceException e) {
            String msg = "Failed to get content class[" + contentClassName + "], error: " + e.getLocalizedMessage();
            throw new TitleIngestException(msg, (Throwable)e);
        }
    }

    private Long getPlannerId(Title title) {
        IScheduleSearchService scheduleSearchService = this.getService(IScheduleSearchService.class);
        Long result = scheduleSearchService.findEarliestUpcomingPlannerId(title);
        if (result == null) {
            result = scheduleSearchService.findPastPlannerId(title);
        }
        return result;
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private <T extends Service> T getService(Class<T> serviceClass) {
        return (T)((Service)ServiceRegistry.getDefault().lookup(serviceClass));
    }

    public TitleIngestResult updateTitleForContent(String assetPath, Title title, ITitleActionSource source) throws TitleIngestException {
        if (assetPath == null) {
            throw new IllegalArgumentException("assetPath can't be null");
        }
        if (title == null) {
            throw new IllegalArgumentException("Title can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        Asset asset = this.getSingleAssetInTitle(assetPath, title.getId(), title);
        return this.updateTitleForContent(assetPath, title, asset, source);
    }

    private static final /* synthetic */ ContentMapping getMappingForMetadata_aroundBody0(TitleIngestService this_, String metadataPath) {
        if (metadataPath == null) {
            throw new IllegalArgumentException("metadataPath can't be null");
        }
        MetadataDocument document = this_.createDocument(metadataPath);
        Long titleId = this_.getTitleID(document);
        ArrayList<TitleAsset> titleAssets = new ArrayList<TitleAsset>();
        if (titleId != null) {
            Title title = this_.getTitle(titleId);
            titleAssets.add(new TitleAsset(title.getId(), Long.valueOf(title.getAsset().getId())));
        }
        return new ContentMapping(metadataPath, titleAssets);
    }

    private static final /* synthetic */ Object getMappingForMetadata_aroundBody1$advice(TitleIngestService this_, String metadataPath, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.getMappingForMetadata_aroundBody0(this_, metadataPath);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentMapping object = TitleIngestService.getMappingForMetadata_aroundBody0(this_, metadataPath);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ContentMapping getMappingForContent_aroundBody2(TitleIngestService this_, String assetPath, String providerId) {
        String fileName = new File(assetPath).getName();
        List searchResults = this_.titleSearchService.findAssetWithFileName(fileName, providerId);
        ArrayList<TitleAsset> titleAssets = new ArrayList<TitleAsset>(searchResults.size());
        for (FileSearchResult fsr : searchResults) {
            titleAssets.add(new TitleAsset(Long.valueOf(fsr.getTitleId()), Long.valueOf(fsr.getAssetId())));
        }
        return new ContentMapping(assetPath, titleAssets);
    }

    private static final /* synthetic */ Object getMappingForContent_aroundBody3$advice(TitleIngestService this_, String assetPath, String providerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.getMappingForContent_aroundBody2(this_, assetPath, providerId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentMapping object = TitleIngestService.getMappingForContent_aroundBody2(this_, assetPath, providerId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TitleIngestResult createTitleForPackage_aroundBody4(TitleIngestService this_, String metadataPath, String assetFolderPath, String providerId, String contentClassName, ITitleActionSource source) {
        if (metadataPath == null) {
            throw new IllegalArgumentException("metadataPath can't be null");
        }
        if (assetFolderPath == null) {
            throw new IllegalArgumentException("assetFolderPath can't be null");
        }
        if (providerId == null) {
            throw new IllegalArgumentException("providerId can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        MetadataDocument metadataDocument = this_.createDocument(metadataPath);
        this_.validateDocumentForTitle(metadataDocument, null);
        Title title = this_.createTitleForDocument(metadataDocument, providerId, contentClassName);
        Map<String, FileMapResult> mappings = this_.mapFilesForPackage(metadataPath, assetFolderPath, title);
        ISavedTitle savedTitle = this_.saveTitle(title, source);
        TitleIngestResult result = new TitleIngestResult(savedTitle, mappings, null);
        this_.sendProgressUpdateForMetadata(result, source);
        this_.sendProgressUpdateForAssets(result, source);
        return result;
    }

    private static final /* synthetic */ Object createTitleForPackage_aroundBody5$advice(TitleIngestService this_, String metadataPath, String assetFolderPath, String providerId, String contentClassName, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.createTitleForPackage_aroundBody4(this_, metadataPath, assetFolderPath, providerId, contentClassName, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleIngestResult object = TitleIngestService.createTitleForPackage_aroundBody4(this_, metadataPath, assetFolderPath, providerId, contentClassName, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TitleIngestResult updateTitleForPackage_aroundBody6(TitleIngestService this_, String metadataPath, String assetFolderPath, Long titleId, ITitleActionSource source) {
        if (metadataPath == null) {
            throw new IllegalArgumentException("metadataPath can't be null");
        }
        if (assetFolderPath == null) {
            throw new IllegalArgumentException("assetFolderPath can't be null");
        }
        if (titleId == null) {
            throw new IllegalArgumentException("titleId can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        MetadataDocument metadataDocument = this_.createDocument(metadataPath);
        this_.validateDocumentForTitle(metadataDocument, titleId);
        Title title = this_.updateTitleForDocument(titleId, metadataDocument);
        Map<String, FileMapResult> mappings = this_.mapFilesForPackage(metadataPath, assetFolderPath, title);
        Long plannerId = this_.getPlannerId(title);
        ISavedTitle savedTitle = this_.saveTitle(title, source);
        TitleIngestResult result = new TitleIngestResult(savedTitle, mappings, plannerId);
        this_.sendProgressUpdateForMetadata(result, source);
        this_.sendProgressUpdateForAssets(result, source);
        return result;
    }

    private static final /* synthetic */ Object updateTitleForPackage_aroundBody7$advice(TitleIngestService this_, String metadataPath, String assetFolderPath, Long titleId, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.updateTitleForPackage_aroundBody6(this_, metadataPath, assetFolderPath, titleId, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleIngestResult object = TitleIngestService.updateTitleForPackage_aroundBody6(this_, metadataPath, assetFolderPath, titleId, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TitleIngestResult createTitleForMetadata_aroundBody8(TitleIngestService this_, String metadataPath, String providerId, String contentClassName, ITitleActionSource source) {
        if (metadataPath == null) {
            throw new IllegalArgumentException("metadataPath can't be null");
        }
        if (providerId == null) {
            throw new IllegalArgumentException("providerId can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        MetadataDocument metadataDocument = this_.createDocument(metadataPath);
        this_.validateDocumentForTitle(metadataDocument, null);
        Title title = this_.createTitleForDocument(metadataDocument, providerId, contentClassName);
        Map<String, FileMapResult> mappings = this_.mapMetadata(metadataPath, title);
        ISavedTitle savedTitle = this_.saveTitle(title, source);
        TitleIngestResult result = new TitleIngestResult(savedTitle, mappings, null);
        this_.sendProgressUpdateForMetadata(result, source);
        return result;
    }

    private static final /* synthetic */ Object createTitleForMetadata_aroundBody9$advice(TitleIngestService this_, String metadataPath, String providerId, String contentClassName, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.createTitleForMetadata_aroundBody8(this_, metadataPath, providerId, contentClassName, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleIngestResult object = TitleIngestService.createTitleForMetadata_aroundBody8(this_, metadataPath, providerId, contentClassName, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TitleIngestResult updateTitleForMetadata_aroundBody10(TitleIngestService this_, String metadataPath, Long titleId, ITitleActionSource source) {
        if (metadataPath == null) {
            throw new IllegalArgumentException("metadataPath can't be null");
        }
        if (titleId == null) {
            throw new IllegalArgumentException("titleId can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        MetadataDocument metadataDocument = this_.createDocument(metadataPath);
        this_.validateDocumentForTitle(metadataDocument, titleId);
        Title title = this_.updateTitleForDocument(titleId, metadataDocument);
        Map<String, FileMapResult> mappings = this_.mapMetadata(metadataPath, title);
        Long plannerId = this_.getPlannerId(title);
        ISavedTitle savedTitle = this_.saveTitle(title, source);
        TitleIngestResult result = new TitleIngestResult(savedTitle, mappings, plannerId);
        this_.sendProgressUpdateForMetadata(result, source);
        return result;
    }

    private static final /* synthetic */ Object updateTitleForMetadata_aroundBody11$advice(TitleIngestService this_, String metadataPath, Long titleId, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.updateTitleForMetadata_aroundBody10(this_, metadataPath, titleId, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleIngestResult object = TitleIngestService.updateTitleForMetadata_aroundBody10(this_, metadataPath, titleId, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getContentAssets_aroundBody12(TitleIngestService this_, Long titleId) {
        if (titleId == null) {
            throw new TitleIngestException("titleId can't be null");
        }
        Title title = this_.getTitle(titleId);
        ArrayList<Asset> result = new ArrayList<Asset>();
        for (Asset asset : title.getAllAssets(false)) {
            if (!this_.assetHasContentUrl(asset)) continue;
            result.add(asset);
        }
        return result;
    }

    private static final /* synthetic */ Object getContentAssets_aroundBody13$advice(TitleIngestService this_, Long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.getContentAssets_aroundBody12(this_, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleIngestService.getContentAssets_aroundBody12(this_, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Collection getUnmappedContentForTitle_aroundBody14(TitleIngestService this_, Long titleId) {
        if (titleId == null) {
            throw new IllegalArgumentException("titleId can't be null");
        }
        ArrayList<TitleAssetMapping> result = new ArrayList<TitleAssetMapping>();
        Title title = this_.getTitle(titleId);
        String providerId = this_.getProviderId(title);
        for (Asset asset : title.getAllAssets(false)) {
            if (!this_.assetHasContentUrl(asset)) continue;
            result.add(this_.getUnmappedContentForTitleAsset(title, asset, providerId));
        }
        return result;
    }

    private static final /* synthetic */ Object getUnmappedContentForTitle_aroundBody15$advice(TitleIngestService this_, Long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.getUnmappedContentForTitle_aroundBody14(this_, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Collection object = TitleIngestService.getUnmappedContentForTitle_aroundBody14(this_, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TitleAssetMapping getUnmappedContentForTitleAsset_aroundBody16(TitleIngestService this_, Long titleId, Long assetId) {
        Title title = this_.getTitle(titleId);
        Asset asset = title.getAsset(assetId.longValue());
        String providerId = this_.getProviderId(title);
        return this_.getUnmappedContentForTitleAsset(title, asset, providerId);
    }

    private static final /* synthetic */ Object getUnmappedContentForTitleAsset_aroundBody17$advice(TitleIngestService this_, Long titleId, Long assetId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.getUnmappedContentForTitleAsset_aroundBody16(this_, titleId, assetId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetMapping object = TitleIngestService.getUnmappedContentForTitleAsset_aroundBody16(this_, titleId, assetId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TitleIngestResult updateTitleForContent_aroundBody18(TitleIngestService this_, String assetPath, Long titleId, ITitleActionSource source) {
        if (assetPath == null) {
            throw new IllegalArgumentException("assetPath can't be null");
        }
        if (titleId == null) {
            throw new IllegalArgumentException("titleId can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        Title title = this_.getTitleForIngest(titleId);
        Asset asset = this_.getSingleAssetInTitle(assetPath, titleId, title);
        return this_.updateTitleForContent(assetPath, title, asset, source);
    }

    private static final /* synthetic */ Object updateTitleForContent_aroundBody19$advice(TitleIngestService this_, String assetPath, Long titleId, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.updateTitleForContent_aroundBody18(this_, assetPath, titleId, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleIngestResult object = TitleIngestService.updateTitleForContent_aroundBody18(this_, assetPath, titleId, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TitleIngestResult updateTitleForContent_aroundBody20(TitleIngestService this_, String assetPath, Long titleId, Long assetId, ITitleActionSource source) {
        if (assetPath == null) {
            throw new IllegalArgumentException("assetPath can't be null");
        }
        if (titleId == null) {
            throw new IllegalArgumentException("titleId can't be null");
        }
        if (assetId == null) {
            throw new IllegalArgumentException("assetId can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        Title title = this_.getTitleForIngest(titleId);
        Asset asset = title.getAsset(assetId.longValue());
        return this_.updateTitleForContent(assetPath, title, asset, source);
    }

    private static final /* synthetic */ Object updateTitleForContent_aroundBody21$advice(TitleIngestService this_, String assetPath, Long titleId, Long assetId, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.updateTitleForContent_aroundBody20(this_, assetPath, titleId, assetId, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleIngestResult object = TitleIngestService.updateTitleForContent_aroundBody20(this_, assetPath, titleId, assetId, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final class MetadataDocument {
        private final String path;
        private final Document document;

        public MetadataDocument(String path, Document document) {
            this.path = path;
            this.document = document;
        }

        public String toString() {
            return "metadata document[" + this.path + "]";
        }
    }
}

