/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.ericsson.cms.criteria.Predicate;
import com.tandbergtv.metadatamanager.search.ConditionBuilder;

public class TitleMetaDataConditionBuilder {
    public String getCondition(Predicate predicate) {
        switch (predicate.getSearchComplientOperator()) {
            case MISSINGCONTENT: {
                return this.missingContent(predicate);
            }
            case NOTMISSINGCONTENT: {
                return this.notMissingContent(predicate);
            }
        }
        return ConditionBuilder.getCondition((Predicate)predicate);
    }

    protected String missingContent(Predicate predicate) {
        String rootAssetType = predicate.getFieldLeftSectionType();
        return "t.id_ in (" + this.buildContentCheck(rootAssetType) + ")";
    }

    protected String notMissingContent(Predicate predicate) {
        String rootAssetType = predicate.getFieldLeftSectionType();
        return "t.id_ not in (" + this.buildContentCheck(rootAssetType) + ")";
    }

    private String buildContentCheck(String assetType) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT pt.id_ ");
        sb.append("FROM (SELECT ID,XMLTYPE(DATA) AS A FROM PMM_CONTENT_CLASS) PCC, ");
        sb.append("XMLTABLE('/metadata/asset' PASSING PCC.A COLUMNS  \"path\" VARCHAR2(1000) PATH '@path', ");
        sb.append("\"requiresFile\" VARCHAR2(1000) PATH '@requiresFile', \"isHidden\" varchar2(1000) PATH '@isHidden') XMLPCC, ");
        sb.append("PMM_TITLE PT, ");
        sb.append("mdm_metadata mm ");
        sb.append("WHERE XMLPCC.\"requiresFile\"='true' ");
        sb.append("AND XMLPCC.\"isHidden\" IS NULL ");
        sb.append("AND xmlpcc.\"path\"!='PACKAGE' ");
        sb.append("AND XMLPCC.\"path\" LIKE '");
        sb.append(assetType);
        sb.append("%' ");
        sb.append("AND PT.CONTENT_CLASS_ID= PCC.ID ");
        sb.append("AND XMLCAST(XMLQUERY('/ECMFSpec/@documentId' PASSING MM.OBJECT_VALUE RETURNING CONTENT) AS NUMBER) = PT.MDMDOCID ");
        sb.append("AND extract(MM.OBJECT_VALUE,'/ECMFSpec/'||REPLACE(REPLACE(INITCAP(XMLPCC.\"path\"), 'clip', 'Clip'),'segmentgroup','SegmentGroup')||'/File/Fields/Locator/Description[Text=\"ORIGINAL\"]') IS NULL ");
        sb.append("and extract(MM.OBJECT_VALUE,'/ECMFSpec/'||REPLACE(REPLACE(INITCAP(XMLPCC.\"path\"), 'clip', 'Clip'),'segmentgroup','SegmentGroup')) is not null");
        return sb.toString();
    }
}

