/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.PagingInfo;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.title.search.BulkSearchRecordHandler;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.InvalidSrchException;
import com.tandbergtv.cms.title.search.entities.FileSearchResult;
import com.tandbergtv.cms.title.search.entities.SiteType;
import com.tandbergtv.cms.title.search.entities.TitleSearchResult;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.metadatamanager.model.SeriesInfo;
import com.tandbergtv.metadatamanager.search.AssetSearchQueryBuilder;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.search.FileSearchQueryHelper;
import com.tandbergtv.watchpoint.pmm.title.search.SeasonQueryBuilder;
import com.tandbergtv.watchpoint.pmm.title.search.TitleQuickSearchQueryHelper;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchQueryHelper;
import com.tandbergtv.watchpoint.pmm.title.search.binding.BindVariable;
import com.tandbergtv.watchpoint.pmm.title.search.binding.LongBindVariable;
import com.tandbergtv.watchpoint.pmm.title.search.binding.StringBindVariable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.jdbc.Work;
import org.hibernate.type.FloatType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.Type;

public class TitleSearchService
implements ITitleSearchService {
    private static final Logger logger = Logger.getLogger((String)TitleSearchService.class.getName());
    private TitleSearchQueryHelper searchQueryHelper = new TitleSearchQueryHelper();
    private TitleQuickSearchQueryHelper qsQueryHelper = new TitleQuickSearchQueryHelper();
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final String DATABASE_TIME_PATTERN = "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}[.]{1}\\d{1} [+]{1}\\d{1}:\\d{2}";
    public static final int DATABASE_TIME_START_INDEX = 11;
    public static final int DATABASE_TIME_END_INDEX = 19;
    private final SessionFactory sessionFactory = this.getSessionFactory();

    protected SessionFactory getSessionFactory() {
        try {
            return HibernateContext.getContext().getSessionFactory();
        }
        catch (Exception e) {
            logger.error((Object)"Could not get SessionFactory", (Throwable)e);
            throw new IllegalStateException("Could not get SessionFactory");
        }
    }

    public String getServiceName() {
        return "Title Search";
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean checkExistenceIncludeAllcopies(ExpNode condition) {
        String queryStr = this.searchQueryHelper.getQuery(new TitleFilter(condition, null, new PagingInfo(0, 1)), true, true, true, new ArrayList<Integer>(), SiteType.DISTRIBUTION_SITE, false, new ArrayList<SearchColumn>(), new ArrayList<Long>(), false);
        return this.executeQuery(queryStr).size() > 0;
    }

    public List<Long> getTitleIdsIncludeAllcopies(ExpNode condition) {
        String queryStr = this.searchQueryHelper.getQuery(new TitleFilter(condition, null, null), true, true, true, new ArrayList<Integer>(), SiteType.DISTRIBUTION_SITE, false, new ArrayList<SearchColumn>(), new ArrayList<Long>(), false);
        return this.executeQuery(queryStr);
    }

    @Transactional
    public List<Title> getTitleCopies(Long masterTitleId) {
        Long l = masterTitleId;
        return (List)TitleSearchService.getTitleCopies_aroundBody1$advice(this, l, TransactionEnforcer.aspectOf(), TitleSearchService.class.getDeclaredMethod("getTitleCopies", Long.class).getAnnotation(Transactional.class), null);
    }

    public List<Long> getTitleIds(ExpNode condition) {
        return this.masterSearchHelper(condition, null, null);
    }

    @Transactional
    public List<Title> getTitles(List<Long> titleIds) {
        List<Long> list = titleIds;
        return (List)TitleSearchService.getTitles_aroundBody3$advice(this, list, TransactionEnforcer.aspectOf(), TitleSearchService.class.getDeclaredMethod("getTitles", List.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public List<Title> search(ExpNode condition) {
        ExpNode expNode = condition;
        return (List)TitleSearchService.search_aroundBody5$advice(this, expNode, TransactionEnforcer.aspectOf(), TitleSearchService.class.getDeclaredMethod("search", ExpNode.class).getAnnotation(Transactional.class), null);
    }

    public TitleSearchResult getSearchResults(TitleFilter filter, List<Long> partnerIds, List<SearchColumn> searchColumns, boolean includeCnt) {
        String queryStr = this.searchQueryHelper.getQuery(filter, true, false, false, new ArrayList<Integer>(), null, includeCnt, searchColumns, partnerIds, true);
        try {
            TitleSearchResult results = this.executeQuery(queryStr, searchColumns, includeCnt, filter.getPageInfo(), new ArrayList<BindVariable>(0));
            return results;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<Long> masterSearchHelper(ExpNode condition, PagingInfo pagingInfo, SortingInfo sortInfo) {
        String queryStr = this.searchQueryHelper.getQuery(new TitleFilter(condition, sortInfo, pagingInfo), true, false, false, new ArrayList<Integer>(), null, false, new ArrayList<SearchColumn>(), new ArrayList<Long>(), false);
        return this.executeQuery(queryStr);
    }

    public List<Long> getSiteTitleIds(ExpNode condition, Collection<Integer> siteIds, SiteType siteType) {
        String queryStr = this.searchQueryHelper.getQuery(new TitleFilter(condition), false, false, true, siteIds, siteType, false, new ArrayList<SearchColumn>(), new ArrayList<Long>(), false);
        return this.executeQuery(queryStr);
    }

    public List<Title> getSiteTitle(ExpNode condition, Collection<Integer> siteIds, SiteType siteType) {
        return this.getTitles(this.getSiteTitleIds(condition, siteIds, siteType));
    }

    public List<Long> geAllTitlesIds(TitleFilter filter, Collection<Integer> siteIds, SiteType siteType) {
        String queryStr = this.searchQueryHelper.getQuery(filter, true, true, true, siteIds, siteType, false, new ArrayList<SearchColumn>(), new ArrayList<Long>(), false);
        return this.executeQuery(queryStr);
    }

    public TitleSearchResult getSiteTitleIds(TitleFilter filter, List<SearchColumn> searchColumns, Collection<Integer> siteIds, SiteType siteType, List<Long> partnerIds) {
        String queryStr = this.searchQueryHelper.getQuery(filter, false, false, true, siteIds, siteType, true, searchColumns, partnerIds, false);
        try {
            return this.executeQuery(queryStr, searchColumns, true, filter.getPageInfo(), new ArrayList<BindVariable>(0));
        }
        catch (InvalidSrchException e) {
            throw new RuntimeException(e);
        }
    }

    public TitleSearchResult getTitlesQuickSearch(String searchText, List<Long> partnerIds, PagingInfo pagingInfo, SortingInfo sortInfo, List<SearchColumn> searchColumns, CriteriaMode criteriaMode) throws InvalidSrchException {
        String queryStr = this.qsQueryHelper.buildQuickSearch(partnerIds.size(), pagingInfo != null, true, sortInfo, searchColumns, criteriaMode);
        List<BindVariable> bindVariables = this.getQSParameters(searchText, partnerIds, pagingInfo);
        return this.executeQuery(queryStr, searchColumns, true, pagingInfo, bindVariables);
    }

    private SQLQuery buildQuery(String queryStr, List<SearchColumn> searchColumns, boolean includeCount) {
        SQLQuery query = this.sessionFactory.getCurrentSession().createSQLQuery(queryStr);
        query = query.addScalar("id_", (Type)new LongType());
        for (int i = 0; i < searchColumns.size(); ++i) {
            SearchColumn sc = searchColumns.get(i);
            if (sc.getFieldName().equals("id")) continue;
            Object dataType = sc.getDataType().equals("string") ? new StringType() : (sc.getDataType().equals("integer") ? new LongType() : (sc.getDataType().equals("float") ? new FloatType() : (sc.getDataType().equals("date") ? new TimestampType() : new StringType())));
            query = query.addScalar("sc" + i, (Type)dataType);
        }
        if (includeCount) {
            query = query.addScalar("cnt", (Type)new IntegerType());
        }
        return query;
    }

    private List<Long> executeQuery(final String queryStr) {
        final ArrayList<Long> ids = new ArrayList<Long>();
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                PreparedStatement statement = conn.prepareStatement(queryStr);
                ResultSet results = statement.executeQuery();
                while (results.next()) {
                    ids.add(results.getLong(1));
                }
            }
        };
        this.doWork(work);
        return ids;
    }

    private TitleSearchResult executeQuery(final String queryStr, final List<SearchColumn> searchColumns, final boolean includeCount, final PagingInfo pagingInfo, final List<BindVariable> bindVariables) throws InvalidSrchException {
        final TitleSearchResult tsr = new TitleSearchResult();
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                PreparedStatement statement = conn.prepareStatement(queryStr);
                for (BindVariable bv : bindVariables) {
                    bv.setInStatement(statement);
                }
                ResultSet results = statement.executeQuery();
                boolean fetchedCount = false;
                int maxRecordCnt = Integer.MAX_VALUE;
                if (pagingInfo != null && pagingInfo.getMaxRecordCount() > 0) {
                    maxRecordCnt = pagingInfo.getMaxRecordCount();
                }
                int pageCount = 0;
                while (maxRecordCnt > pageCount && results.next()) {
                    ++pageCount;
                    ArrayList<String> fields = new ArrayList<String>(searchColumns.size());
                    Long id = results.getLong(1);
                    int offset = 2;
                    for (int i = 0; i < searchColumns.size(); ++i) {
                        SearchColumn sc = (SearchColumn)searchColumns.get(i);
                        if (sc.getFieldName().equals("id")) {
                            fields.add(id.toString());
                            offset = 1;
                            continue;
                        }
                        if (results.getObject(i + offset) == null) {
                            fields.add("");
                            continue;
                        }
                        if (sc.getDataType().equals("date")) {
                            fields.add(TitleSearchService.this.dateHelper(sc, i + offset, results));
                            continue;
                        }
                        fields.add(results.getString(i + offset));
                    }
                    if (includeCount && !fetchedCount) {
                        tsr.setCount(results.getInt("cnt"));
                        fetchedCount = true;
                    }
                    tsr.addRow(new TitleSearchResult.SearchRow(id.longValue(), fields));
                }
                if (results.next()) {
                    tsr.setHasMoreResults(true);
                }
            }
        };
        this.doWork(work);
        return tsr;
    }

    private void doWork(Work work) {
        Session session = this.sessionFactory.openSession();
        try {
            session.doWork(work);
        }
        catch (RuntimeException e) {
            try {
                session.cancelQuery();
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw e;
        }
        finally {
            session.close();
        }
    }

    private List<BindVariable> getQSParameters(String searchText, List<Long> partnerIds, PagingInfo pagingInfo) {
        ArrayList<BindVariable> bindVariables = new ArrayList<BindVariable>();
        int paramIndex = 1;
        bindVariables.add(new StringBindVariable(paramIndex++, AssetSearchQueryBuilder.encodeString((String)searchText)));
        for (Long partnerId : partnerIds) {
            bindVariables.add(new LongBindVariable(paramIndex++, partnerId));
        }
        if (pagingInfo != null) {
            bindVariables.add(new LongBindVariable(paramIndex++, pagingInfo.getStartIndex() + 1));
            bindVariables.add(new LongBindVariable(paramIndex++, pagingInfo.getStartIndex() + pagingInfo.getMaxRecordCount() + 1));
        }
        return bindVariables;
    }

    private void setQSParameters(SQLQuery query, String searchText, List<Long> partnerIds, PagingInfo pagingInfo) {
        int paramIndex = 0;
        String encodedSrchTxt = AssetSearchQueryBuilder.encodeString((String)searchText);
        query.setString(paramIndex++, encodedSrchTxt);
        for (Long partnerId : partnerIds) {
            query.setLong(paramIndex++, partnerId.longValue());
        }
        if (pagingInfo != null) {
            query.setInteger(paramIndex++, pagingInfo.getStartIndex() + 1);
            query.setInteger(paramIndex++, pagingInfo.getStartIndex() + pagingInfo.getMaxRecordCount() + 1);
        }
    }

    public ScrollableResults qwikSrchScrollable(String searchText, List<Long> partnerIds, SortingInfo sortInfo, List<SearchColumn> searchColumns, CriteriaMode criteriaMode, int fetchSize) {
        String queryStr = this.qsQueryHelper.buildQuickSearch(partnerIds.size(), false, false, sortInfo, searchColumns, criteriaMode);
        SQLQuery query = this.buildQuery(queryStr, searchColumns, false);
        this.setQSParameters(query, searchText, partnerIds, null);
        query.setFetchSize(fetchSize);
        return query.scroll(ScrollMode.FORWARD_ONLY);
    }

    public ScrollableResults getTitleScrollable(TitleFilter filter, List<Long> partnerIds, List<SearchColumn> searchColumns, int fetchSize) {
        String queryStr = this.searchQueryHelper.getQuery(filter, true, false, false, new ArrayList<Integer>(), null, false, searchColumns, partnerIds, false);
        SQLQuery query = this.buildQuery(queryStr, searchColumns, false);
        query.setFetchSize(fetchSize);
        return query.scroll(ScrollMode.FORWARD_ONLY);
    }

    public List<TitleSearchResult.SearchRow> getSearchResults(List<Long> titleIds, List<SearchColumn> searchColumns) {
        if (titleIds.isEmpty()) {
            return new ArrayList<TitleSearchResult.SearchRow>();
        }
        ExpValue searchCriteria = this.getTitleIdsCriteria(titleIds);
        return this.getSearchResultRows(new TitleFilter((ExpNode)searchCriteria), new ArrayList<Long>(), searchColumns);
    }

    public List<TitleSearchResult.SearchRow> getSearchResultRows(TitleFilter filter, List<Long> partnerIds, List<SearchColumn> searchColumns) {
        String queryStr = this.searchQueryHelper.getQuery(filter, true, false, false, new ArrayList<Integer>(), null, false, searchColumns, partnerIds, false);
        try {
            return this.executeQuery(queryStr, searchColumns, false, new PagingInfo(), new ArrayList<BindVariable>(0)).getRows();
        }
        catch (InvalidSrchException e) {
            throw new RuntimeException(e);
        }
    }

    public List<FileSearchResult> findAssetWithFileName(String filePath, String providerId) {
        final ArrayList<FileSearchResult> searchResults = new ArrayList<FileSearchResult>();
        final String queryStr = FileSearchQueryHelper.getQuery(filePath, providerId);
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                PreparedStatement statement = conn.prepareStatement(queryStr);
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    Long titleId = resultSet.getLong(1);
                    Long assetId = resultSet.getLong(2);
                    searchResults.add(new FileSearchResult(titleId.longValue(), assetId.longValue()));
                }
            }
        };
        this.doWork(work);
        return searchResults;
    }

    private ExpValue getTitleIdsCriteria(List<Long> titleIds) {
        ArrayList<String> titleIdsStr = new ArrayList<String>();
        for (Long id : titleIds) {
            titleIdsStr.add(String.valueOf(id));
        }
        PredicateRightValue condition = new PredicateRightValue("id", "", FieldType.PMM_TITLE, titleIdsStr, LogicalOperator.IN, "integer", Boolean.valueOf(false));
        return new ExpValue((Predicate)condition);
    }

    public List<String> findFieldMatchingCriteria(SearchColumn field, ExpNode criteria) {
        final String queryStr = this.searchQueryHelper.getQuery(criteria, field);
        final ArrayList<String> result = new ArrayList<String>();
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                PreparedStatement statement = conn.prepareStatement(queryStr);
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    result.add(resultSet.getString(1));
                }
            }
        };
        this.doWork(work);
        return result;
    }

    public List<SeriesInfo> getSeriesInfos(ExpNode seasonConditions, ExpNode generalConditions) {
        final ArrayList<SeriesInfo> searchResults = new ArrayList<SeriesInfo>();
        SeasonQueryBuilder sqb = new SeasonQueryBuilder();
        final String queryStr = sqb.getSeasonQuery(seasonConditions, generalConditions);
        logger.debug((Object)("yay search: " + queryStr));
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                PreparedStatement statement = conn.prepareStatement(queryStr);
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    Long seriesDocumentId = resultSet.getLong("mdmDocId");
                    Long seasonAssetId = resultSet.getLong("seasonid");
                    searchResults.add(new SeriesInfo(seriesDocumentId, seasonAssetId));
                }
            }
        };
        this.doWork(work);
        return searchResults;
    }

    public void getTitleBulk(TitleFilter filter, List<Long> partnerIds, List<SearchColumn> searchColumns, int fetchSize, BulkSearchRecordHandler handler) {
        String queryStr = this.searchQueryHelper.getQuery(filter, true, false, false, new ArrayList<Integer>(), null, false, searchColumns, partnerIds, false);
        this.bulkSearchHelper(queryStr, searchColumns, fetchSize, handler, new ArrayList<BindVariable>());
    }

    private void bulkSearchHelper(final String queryStr, final List<SearchColumn> searchColumns, final int fetchSize, final BulkSearchRecordHandler handler, final List<BindVariable> bindVariables) {
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                PreparedStatement statement = conn.prepareStatement(queryStr);
                for (BindVariable bv : bindVariables) {
                    bv.setInStatement(statement);
                }
                ResultSet results = statement.executeQuery();
                results.setFetchSize(fetchSize);
                int offset = 2;
                while (results.next()) {
                    ArrayList<String> fields = new ArrayList<String>(searchColumns.size());
                    Long id = results.getLong(1);
                    for (int i = 0; i < searchColumns.size(); ++i) {
                        SearchColumn sc = (SearchColumn)searchColumns.get(i);
                        if (sc.getFieldName().equals("id")) {
                            fields.add(id.toString());
                            offset = 1;
                            continue;
                        }
                        if (results.getObject(i + offset) == null) {
                            fields.add("");
                            continue;
                        }
                        if (sc.getDataType().equals("date")) {
                            fields.add(TitleSearchService.this.dateHelper(sc, i + offset, results));
                            continue;
                        }
                        fields.add(results.getString(i + offset));
                    }
                    try {
                        handler.handleRecord(new TitleSearchResult.SearchRow(id.longValue(), fields));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.doWork(work);
    }

    public void qwikSrchBulk(String searchText, List<Long> partnerIds, SortingInfo sortInfo, List<SearchColumn> searchColumns, CriteriaMode criteriaMode, int fetchSize, BulkSearchRecordHandler handler) {
        String queryStr = this.qsQueryHelper.buildQuickSearch(partnerIds.size(), false, false, sortInfo, searchColumns, criteriaMode);
        List<BindVariable> bindVariables = this.getQSParameters(searchText, partnerIds, null);
        this.bulkSearchHelper(queryStr, searchColumns, fetchSize, handler, bindVariables);
    }

    private String dateHelper(SearchColumn sc, int pos, ResultSet results) throws SQLException {
        if (sc.isMultiValue()) {
            SimpleDateFormat formatIn = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
            String list = results.getString(pos);
            String[] dates = list.split(",");
            StringBuilder datesBuilder = new StringBuilder();
            for (String date : dates) {
                if (datesBuilder.length() > 0) {
                    datesBuilder.append(",");
                }
                try {
                    datesBuilder.append(this.sdf.format(formatIn.parse(date)));
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
            return datesBuilder.toString();
        }
        Timestamp st = results.getTimestamp(pos);
        return this.sdf.format(new Date(st.getTime()));
    }

    private static final /* synthetic */ List getTitleCopies_aroundBody0(TitleSearchService this_, Long masterTitleId) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(String.valueOf(masterTitleId));
        PredicateRightValue prv = new PredicateRightValue("originalId", "", FieldType.PMM_TITLE, values, LogicalOperator.EQUAL, "integer", Boolean.valueOf(false));
        final String queryStr = this_.searchQueryHelper.getQuery(new TitleFilter((ExpNode)new ExpValue((Predicate)prv)), false, true, true, new ArrayList<Integer>(), SiteType.DISTRIBUTION_SITE, false, new ArrayList<SearchColumn>(), new ArrayList<Long>(), false);
        final ArrayList<Long> titleIds = new ArrayList<Long>();
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                PreparedStatement statement = conn.prepareStatement(queryStr);
                ResultSet results = statement.executeQuery();
                while (results.next()) {
                    titleIds.add(results.getLong(1));
                }
            }
        };
        this_.sessionFactory.getCurrentSession().doWork(work);
        return this_.getTitles(titleIds);
    }

    private static final /* synthetic */ Object getTitleCopies_aroundBody1$advice(TitleSearchService this_, Long masterTitleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleSearchService.getTitleCopies_aroundBody0(this_, masterTitleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleSearchService.getTitleCopies_aroundBody0(this_, masterTitleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getTitles_aroundBody2(TitleSearchService this_, List titleIds) {
        if (titleIds == null || titleIds.isEmpty()) {
            return new ArrayList();
        }
        Criteria crit = this_.sessionFactory.getCurrentSession().createCriteria(Title.class);
        crit.add(Restrictions.in((String)"id", (Object[])titleIds.toArray()));
        crit.addOrder(Property.forName((String)"id").asc());
        return crit.list();
    }

    private static final /* synthetic */ Object getTitles_aroundBody3$advice(TitleSearchService this_, List titleIds, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleSearchService.getTitles_aroundBody2(this_, titleIds);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleSearchService.getTitles_aroundBody2(this_, titleIds);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List search_aroundBody4(TitleSearchService this_, ExpNode condition) {
        List<Long> titleIds = this_.masterSearchHelper(condition, null, null);
        List<Title> titles = this_.getTitles(titleIds);
        Title[] result = new Title[titleIds.size()];
        block0: for (Title t : titles) {
            Long id = t.getId();
            for (int i = 0; i < titleIds.size(); ++i) {
                if (!titleIds.get(i).equals(id)) continue;
                result[i] = t;
                continue block0;
            }
        }
        return Arrays.asList(result);
    }

    private static final /* synthetic */ Object search_aroundBody5$advice(TitleSearchService this_, ExpNode condition, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleSearchService.search_aroundBody4(this_, condition);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleSearchService.search_aroundBody4(this_, condition);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

