/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl;

import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ValidatorHelper {
    private static ValidatorHelper instance = null;
    private Set<ISpecHandler> specHandlersForValidation = new LinkedHashSet<ISpecHandler>();

    public static synchronized ValidatorHelper getInstance() {
        if (instance == null) {
            instance = new ValidatorHelper();
        }
        return instance;
    }

    private ValidatorHelper() {
        this.setSpecificationHandlersForValidation();
    }

    private Collection<ISpecHandler> setSpecificationHandlersForValidation() {
        Map<String, ISpecHandler> specHandlerMap = SpecHandlerFactory.getHandlers();
        HashSet<Set<String>> allTTVIdentifiers = new HashSet<Set<String>>();
        for (ISpecHandler handler : specHandlerMap.values()) {
            Set<String> ttvIdentifier;
            if (handler.getSpecName().equals("TTV") || (ttvIdentifier = this.getTTVIdentifiers(handler)) == null || ttvIdentifier.size() == 0 || allTTVIdentifiers.contains(ttvIdentifier)) continue;
            allTTVIdentifiers.add(ttvIdentifier);
            this.specHandlersForValidation.add(handler);
        }
        return this.specHandlersForValidation;
    }

    private Set<String> getTTVIdentifiers(ISpecHandler handler) {
        HashSet<String> ttvXPaths = new HashSet<String>();
        Map<String, String> identifiers = handler.getIdentifier().getTTVPaths();
        boolean hasPersistenceKey = false;
        for (String ttvPath : identifiers.values()) {
            if (AssetSearchKey.ASSET_ID.toString().equals(ttvPath)) {
                hasPersistenceKey = true;
                break;
            }
            ttvXPaths.add(ttvPath);
        }
        if (hasPersistenceKey) {
            return null;
        }
        return ttvXPaths;
    }

    public Collection<ISpecHandler> getSpecificationHandlersForValidation() {
        return this.specHandlersForValidation;
    }

    public void setSpecKeyValueHasChanged(Asset newAsset, Asset mergedAsset) {
        Collection<ISpecHandler> handlers = this.getSpecificationHandlersForValidation();
        LinkedHashSet<ISpecHandler> assetSpecHandlersForValidation = new LinkedHashSet<ISpecHandler>();
        for (ISpecHandler handler : handlers) {
            Set<String> ttvIdentifiers = this.getTTVIdentifiers(handler);
            boolean specKeyHasChanged = false;
            for (String xpath : ttvIdentifiers) {
                Field oFld = mergedAsset.getFirstField(xpath);
                Field nFld = newAsset.getFirstField(xpath);
                if (oFld == null && nFld == null) continue;
                if (oFld == null || nFld == null) {
                    specKeyHasChanged = true;
                    continue;
                }
                if (oFld.equals(nFld)) continue;
                specKeyHasChanged = true;
            }
            if (!specKeyHasChanged) continue;
            assetSpecHandlersForValidation.add(handler);
        }
        mergedAsset.setSpecHandlersForValidation(assetSpecHandlersForValidation);
        if (assetSpecHandlersForValidation.size() > 0) {
            mergedAsset.setSpecKeyValuesHasChanged(true);
        } else {
            mergedAsset.setSpecKeyValuesHasChanged(false);
        }
    }
}

