/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.converter.spec;

import com.ericsson.converter.spec.FieldOption;
import com.ericsson.converter.spec.OldField;
import com.ericsson.converter.spec.OldSpec;
import com.ericsson.converter.spec.OldTitle;
import com.ericsson.converter.spec.OptionUpdater12;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassOption;
import com.tandbergtv.content.contentclass.hibernate.ContentClassServiceHibernate;
import com.tandbergtv.content.contentclass.jaxb.ContentClassJaxbService;
import com.tandbergtv.content.contentclass.util.HibernateContext;
import com.tandbergtv.content.contentclass.util.HibernateUtil;
import com.tandbergtv.content.contentclass.util.XPathTranslator;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.Specification;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConvertCC12 {
    private static Logger logger = Logger.getLogger(ConvertCC12.class);
    private Map<Object, Object> newProps;

    public void convert(OldSpec oldSpec, Specification specification, Map<Object, Object> map) throws Exception {
        this.newProps = map;
        ContentClass contentClass = this.loadDefaultContentClassTemplate();
        this.updateWithOldSpecData(contentClass, oldSpec);
        logger.info((Object)"Updating options...");
        OptionUpdater12 optionUpdater12 = new OptionUpdater12();
        optionUpdater12.updateOptions(contentClass, specification, map);
        logger.info((Object)"Saving default content class...");
        this.saveContentClass(contentClass);
        logger.info((Object)"Saved default content class.");
    }

    private void updateWithOldSpecData(ContentClass contentClass, OldSpec oldSpec) throws Exception {
        for (OldTitle oldTitle : oldSpec.getAllTitles()) {
            ContentClassAsset contentClassAsset = contentClass.getMetadata().getAsset(oldTitle.path);
            if (contentClassAsset == null) {
                logger.warn((Object)("Default content class doesn't have asset " + oldTitle.path));
                continue;
            }
            logger.info((Object)("Processing asset " + oldTitle.path));
            if (oldTitle.min != null) {
                contentClassAsset.setMin(oldTitle.min < 0 ? 99999 : oldTitle.min);
            }
            if (oldTitle.max != null) {
                contentClassAsset.setMax(oldTitle.max < 0 ? 99999 : oldTitle.max);
            }
            if (oldTitle.batchMin != null) {
                contentClassAsset.setBatchMin(oldTitle.batchMin < 0 ? 99999 : oldTitle.batchMin);
            }
            if (oldTitle.batchMax != null) {
                contentClassAsset.setBatchMax(oldTitle.batchMax < 0 ? 99999 : oldTitle.batchMax);
            }
            contentClassAsset.setRequiresFile(oldTitle.hasAsset);
            contentClassAsset.setHideFileView(oldTitle.hideFileView);
            this.handleCoreFields(oldTitle, contentClassAsset);
            this.handleCustomFields(oldTitle, contentClassAsset);
        }
    }

    private void handleCoreFields(OldTitle oldTitle, ContentClassAsset contentClassAsset) throws Exception {
        for (OldField oldField : oldTitle.getAllCoreFields()) {
            String string = XPathTranslator.instance().old2new(oldField.path);
            ContentClassField contentClassField = contentClassAsset.getField(string);
            if (contentClassField == null) {
                contentClassField = new ContentClassField(string);
                contentClassAsset.addField(contentClassField);
                logger.warn((Object)("Adding field " + string + " (Asset: " + oldTitle.path + ") to Default content class."));
            }
            contentClassAsset.enableFieldAndParents(contentClassField);
            if (oldField.min != null) {
                contentClassField.setMin(oldField.min);
            }
            if (oldField.max != null) {
                contentClassField.setMax(oldField.max);
            }
            contentClassField.setIncludeInBatch(oldField.batch);
            if (oldField.options == null) continue;
            if (contentClassField.getOptions() != null) {
                contentClassField.setOptions(null);
            }
            for (FieldOption fieldOption : oldField.options) {
                String string2 = (String)this.newProps.get(fieldOption.getName());
                if (string2 == null) {
                    string2 = fieldOption.getName();
                }
                contentClassField.addOption(new ContentClassOption(fieldOption.getValue(), string2));
            }
        }
    }

    private void handleCustomFields(OldTitle oldTitle, ContentClassAsset contentClassAsset) {
        Collection<OldField> collection = oldTitle.getAllCustomFields();
        if (!collection.isEmpty()) {
            contentClassAsset.addField(new ContentClassField("/Fields/CustomFields"));
        }
        for (OldField oldField : collection) {
            ContentClassField contentClassField = contentClassAsset.getField(oldField.path);
            if (contentClassField == null) {
                logger.info((Object)("Adding custom field " + oldField.path));
                contentClassField = new ContentClassField(oldField.path);
                contentClassAsset.addField(contentClassField);
            }
            if (oldField.min != null) {
                contentClassField.setMin(oldField.min);
            }
            if (oldField.max != null) {
                contentClassField.setMax(oldField.max);
            }
            contentClassField.setIncludeInBatch(oldField.batch);
            if (oldField.options == null) continue;
            if (contentClassField.getOptions() != null) {
                contentClassField.setOptions(null);
            }
            for (FieldOption fieldOption : oldField.options) {
                String string = (String)this.newProps.get(fieldOption.getName());
                if (string == null) {
                    string = fieldOption.getName();
                }
                contentClassField.addOption(new ContentClassOption(fieldOption.getValue(), string));
            }
        }
    }

    private ContentClass loadDefaultContentClassTemplate() throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("default_content_class.xml")));
        ContentClassJaxbService contentClassJaxbService = new ContentClassJaxbService();
        ContentClassMetadata contentClassMetadata = contentClassJaxbService.unmarshalContentClassMetadata(bufferedReader);
        ContentClass contentClass = new ContentClass();
        contentClass.setDefault(true);
        contentClass.setName("Default");
        contentClass.setDescription("Default content class");
        contentClass.setVersion("2.5");
        contentClass.setMetadata(contentClassMetadata);
        return contentClass;
    }

    private void saveContentClass(ContentClass contentClass) throws Exception {
        HibernateUtil.initHibernate();
        ContentClassServiceHibernate contentClassServiceHibernate = new ContentClassServiceHibernate();
        HibernateContext.getContext().beginTransaction();
        long l = contentClassServiceHibernate.getDefaultContentClassId();
        contentClass.setId(l);
        contentClassServiceHibernate.saveContentClass(contentClass);
        HibernateContext.getContext().commitTransaction();
        HibernateUtil.closeHibernate();
    }
}

