/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.converter.spec;

import com.ericsson.converter.spec.DomUtil;
import com.ericsson.converter.spec.FieldOption;
import com.ericsson.converter.spec.OldField;
import com.ericsson.converter.spec.OldSpec;
import com.ericsson.converter.spec.OldTitle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OldSpecParser12 {
    private OldSpec spec;
    private OldTitle currentTitle;

    public OldSpec parse(String string) throws Exception {
        Document document = DomUtil.readDocument(string);
        Element element = DomUtil.getFirstChildElement(document);
        if (!"specification".equalsIgnoreCase(element.getNodeName())) {
            throw new Exception("Expected <specification>, got <" + element.getNodeName() + ">");
        }
        this.spec = new OldSpec(element.getAttribute("name"));
        this.processChildTitles(element, null);
        return this.spec;
    }

    private void processChildTitles(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("title")) continue;
            this.processTitle((Element)node, string);
        }
    }

    private void processTitle(Element element, String string) {
        Element element2;
        String string2 = DomUtil.getFirstChildElementValue("name", element);
        String string3 = string == null ? string2 : string + "/" + string2;
        OldTitle oldTitle = new OldTitle(string3);
        this.spec.addTitle(oldTitle);
        this.currentTitle = oldTitle;
        oldTitle.min = this.parseInteger(DomUtil.getFirstChildElementValue("min", element));
        oldTitle.max = this.parseInteger(DomUtil.getFirstChildElementValue("max", element));
        oldTitle.batchMin = this.parseInteger(DomUtil.getFirstChildElementValue("batchMin", element));
        oldTitle.batchMax = this.parseInteger(DomUtil.getFirstChildElementValue("batchMax", element));
        oldTitle.hasAsset = this.parseBoolean(DomUtil.getFirstChildElementValue("hasAsset", element));
        oldTitle.hideFileView = this.parseBoolean(DomUtil.getFirstChildElementValue("hideFileView", element));
        Element element3 = DomUtil.getFirstChildElement("metadata", element);
        if (element3 != null) {
            this.processVariables(element3, "/Fields");
        }
        if ((element2 = DomUtil.getFirstChildElement("childTitles", element)) != null) {
            this.processChildTitles(element2, string3);
        }
    }

    private void processVariables(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("variable")) continue;
            Element element2 = (Element)node;
            String string3 = element2.getAttribute("name");
            boolean bl = this.parseBoolean(element2.getAttribute("attribute"));
            String string4 = element2.getAttribute("autoFillProvider");
            boolean bl2 = this.parseBoolean(element2.getAttribute("autoFillable"));
            String string5 = string2 = bl ? string + "/@" + string3 : string + "/" + string3;
            if (this.currentTitle.findCoreFieldByPath(string2) != null || this.currentTitle.findCustomFieldByPath(string2) != null) {
                System.out.println("WARNING: duplicate field: " + string2);
            } else {
                OldField oldField = new OldField(string2);
                String string6 = element2.getAttribute("xsi:type");
                oldField.isAttribute = bl;
                oldField.min = this.parseInteger(element2.getAttribute("min"));
                oldField.max = this.parseInteger(element2.getAttribute("max"));
                oldField.autoFillable = bl2;
                oldField.autoFillProvider = string4;
                oldField.job = this.parseBoolean(element2.getAttribute("jobParameter"));
                oldField.batch = this.parseBoolean(element2.getAttribute("batch"));
                oldField.longFormat = this.parseBoolean(element2.getAttribute("longFormat"));
                this.setOptions(oldField, element2);
                if (string2.startsWith("/Fields/CustomFields/CustomField[")) {
                    this.currentTitle.addCustomFiled(oldField);
                } else {
                    this.currentTitle.addCoreFiled(oldField);
                }
            }
            if (!OldSpecParser12.isEmpty(string4)) {
                this.spec.addAutoFillProvider(string4);
            }
            this.processVariables(element2, string2);
        }
    }

    private void setOptions(OldField oldField, Element element) {
        Element element2 = DomUtil.getFirstChildElement("options", element);
        if (element2 == null) {
            return;
        }
        NodeList nodeList = element2.getChildNodes();
        if (nodeList == null) {
            return;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node = nodeList.item(i);
            if (!"option".equals(node.getNodeName()) || (string = this.getAttribute(node, "name")) == null) continue;
            String string2 = node.getTextContent();
            if (string2 != null) {
                string2 = string2.trim();
            }
            FieldOption fieldOption = new FieldOption(string, string2);
            oldField.addOption(fieldOption);
        }
    }

    private String getAttribute(Node node, String string) {
        if (node.getAttributes() == null) {
            return null;
        }
        Node node2 = node.getAttributes().getNamedItem(string);
        return node2 == null ? null : node2.getNodeValue();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() <= 0;
    }

    private Integer parseInteger(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean parseBoolean(String string) {
        return string != null && string.equalsIgnoreCase("true");
    }
}

