/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.converter.spec;

import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassOption;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.OptionsType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.SimpleVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.TitleType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.VariableType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OptionUpdater12 {
    private static Logger logger = Logger.getLogger(OptionUpdater12.class);
    private ContentClass cc;
    private ContentClassAsset ccAsset;
    private Map<Object, Object> newProps;

    public void updateOptions(ContentClass contentClass, Specification specification, Map<Object, Object> map) {
        this.cc = contentClass;
        this.newProps = map;
        TitleType titleType = specification.getTitle();
        this.walkTitleTree(titleType, null);
        logger.debug((Object)"======================================================");
    }

    private void walkTitleTree(TitleType titleType, String string) {
        String string2 = titleType.getName();
        String string3 = string == null ? string2 : string + "/" + string2;
        this.processTitle(titleType, string3);
        if (titleType.getChildTitles() == null) {
            return;
        }
        List<TitleType> list = titleType.getChildTitles().getTitle();
        for (TitleType titleType2 : list) {
            this.walkTitleTree(titleType2, string3);
        }
    }

    private void processTitle(TitleType titleType, String string) {
        this.ccAsset = this.cc.getMetadata().getAsset(string);
        if (this.ccAsset == null) {
            logger.warn((Object)("Added asset " + string + " to content class."));
            this.ccAsset = new ContentClassAsset(string);
            this.ccAsset.setDisabled(true);
            this.cc.getMetadata().addAsset(this.ccAsset);
        }
        logger.debug((Object)"======================================================");
        logger.debug((Object)string);
        logger.debug((Object)"======================================================");
        List<VariableType> list = titleType.getMetadata().getVariable();
        this.walkVariableTree(list, "/Fields");
    }

    private void walkVariableTree(List<VariableType> list, String string) {
        for (VariableType variableType : list) {
            Object object;
            String string2 = variableType.getName();
            String string3 = string + "/" + string2;
            if (variableType instanceof SimpleVariableType) {
                OptionsType optionsType;
                object = (SimpleVariableType)variableType;
                if (((SimpleVariableType)object).isAttribute()) {
                    string3 = string + "/@" + string2;
                }
                if ((optionsType = ((SimpleVariableType)object).getOptions()) != null) {
                    this.setOptions(optionsType, string3);
                }
            }
            if ((object = variableType.getVariable()) == null || object.isEmpty()) continue;
            this.walkVariableTree((List<VariableType>)object, string3);
        }
    }

    private void setOptions(OptionsType optionsType, String string) {
        List<OptionsType.Option> list = optionsType.getOption();
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<ContentClassOption> arrayList = new ArrayList<ContentClassOption>();
        for (OptionsType.Option option : list) {
            String string2 = option.getName();
            String string3 = (String)this.newProps.get(string2);
            ContentClassOption contentClassOption = new ContentClassOption(option.getValue(), string3);
            arrayList.add(contentClassOption);
        }
        Object object = this.ccAsset.getField(string);
        if (object == null) {
            object = new ContentClassField(string);
            ((ContentClassField)object).setDisabled(true);
            this.ccAsset.addField((ContentClassField)object, false);
        }
        ((ContentClassField)object).setOptions(arrayList);
    }
}

