/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.logging.Logger;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class UniversalConnectionPoolHelper {
    private static final Logger logger = UCPLoggerFactory.createLogger(UniversalConnectionPoolHelper.class.getCanonicalName());
    private UniversalConnectionPoolBase m_connectionPool;

    public UniversalConnectionPoolHelper(UniversalConnectionPoolBase connectionPool) throws UniversalConnectionPoolException {
        if (connectionPool == null) {
            UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(54);
            logger.throwing(this.getClass().getName(), "UniversalConnectionPoolHelper", ucpe);
            throw ucpe;
        }
        this.m_connectionPool = connectionPool;
    }

    protected UniversalPooledConnection[] getAllAvailableConnections() {
        return this.m_connectionPool.getAvailableConnections();
    }

    protected UniversalPooledConnection[] getAllBorrowedConnections() {
        return this.m_connectionPool.getAllBorrowedConnections();
    }

    public UniversalConnectionPoolBase getConnectionPool() {
        return this.m_connectionPool;
    }
}

