/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class FailoverablePooledConnectionHelper {
    private static final Logger logger = UCPLoggerFactory.createLogger(FailoverablePooledConnectionHelper.class.getCanonicalName());
    private static final Map<Class, InvocationVector> oracleConnCache = Collections.synchronizedMap(new HashMap());

    static boolean isUsableOnOracleConnection(Connection oconn) {
        boolean ret_value = false;
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodIsUsable();
            if (null != method) {
                ret_value = (Boolean)method.invoke((Object)oconn, new Object[0]);
                logger.finest("isUsable() invoked successfully");
            } else {
                logger.finest("failed to invoke isUsable(): no such method");
                ret_value = !oconn.isClosed();
            }
        }
        catch (Exception e) {
            logger.log(Level.FINEST, "caught {0}", new Object[]{e});
        }
        logger.log(Level.FINEST, "isUsableOnOracleConnection: {0}", ret_value);
        return ret_value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getSessionInfoOnOracleConnection(Connection oconn) {
        Properties props = new Properties();
        try {
            block5: {
                try {
                    Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodGetServerSessionInfo();
                    if (null != method) {
                        props = (Properties)method.invoke((Object)oconn, new Object[0]);
                        logger.finest("getServerSessionInfo successfully invoked");
                        break block5;
                    }
                    logger.finest("failed to invoke getServerSessionInfo: method not found");
                    props = FailoverablePooledConnectionHelper.getSessionInfoOnOracleConnectionHelper(oconn);
                }
                catch (Exception e) {
                    logger.log(Level.FINEST, "caught {0}", new Object[]{e});
                    Object var4_5 = null;
                    logger.log(Level.FINEST, "getSessionInfoOnOracleConnection returns {0}", props);
                }
            }
            Object var4_4 = null;
            logger.log(Level.FINEST, "getSessionInfoOnOracleConnection returns {0}", props);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            logger.log(Level.FINEST, "getSessionInfoOnOracleConnection returns {0}", props);
            throw throwable;
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties getSessionInfoOnOracleConnectionHelper(Connection connection) throws SQLException {
        Statement stmt;
        Properties props;
        block11: {
            String query = "select sys_context('userenv', 'instance_name'),sys_context('userenv', 'server_host'),sys_context('userenv', 'service_name'),sys_context('userenv', 'db_unique_name') from dual";
            props = new Properties();
            stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = connection.createStatement();
                    rs = stmt.executeQuery(query);
                    while (rs.next()) {
                        String val = null;
                        val = rs.getString(1);
                        if (val != null) {
                            props.setProperty("INSTANCE_NAME", val);
                        }
                        if ((val = rs.getString(2)) != null) {
                            props.setProperty("SERVER_HOST", val);
                        }
                        if ((val = rs.getString(3)) != null) {
                            props.setProperty("SERVICE_NAME", val);
                        }
                        if ((val = rs.getString(4)) == null) continue;
                        props.setProperty("DATABASE_NAME", val);
                    }
                    Object var7_7 = null;
                    if (rs == null) break block11;
                }
                catch (SQLException ea) {
                    logger.log(Level.FINEST, "getting session info", ea);
                    Object var7_8 = null;
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt == null) return props;
                    stmt.close();
                    return props;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (rs != null) {
                    rs.close();
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            rs.close();
        }
        if (stmt == null) return props;
        stmt.close();
        return props;
    }

    static void cancelOnOracleConnection(Connection oconn) throws SQLException {
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodCancel();
            if (null != method) {
                method.invoke((Object)oconn, new Object[0]);
                logger.finest("conn cancelled successfully");
            } else {
                logger.finest("failed to cancel a connection: method not found");
            }
        }
        catch (Exception exc) {
            logger.log(Level.FINEST, "cancel on connection", exc);
        }
    }

    static void enableStatementPooling(Connection oconn, int maxStatements) throws SQLException {
        block6: {
            logger.log(Level.FINEST, "maxStatements: {0}", maxStatements);
            try {
                if (null == oconn) {
                    logger.finest("failed to get SQL conn");
                    return;
                }
                InvocationVector vector = FailoverablePooledConnectionHelper.getInvocationVector(oconn);
                Method method = vector.getMethodSetStatementCacheSize();
                if (null != method) {
                    method.invoke((Object)oconn, maxStatements);
                    logger.finest("setStatementCacheSize invoked");
                }
                if (null != (method = vector.getMethodSetImplicitCachingEnabled())) {
                    method.invoke((Object)oconn, true);
                    logger.finest("setImplicitCachingEnabled invoked");
                }
                if (null != (method = vector.getMethodSetExplicitCachingEnabled())) {
                    method.invoke((Object)oconn, true);
                    logger.finest("setExplicitCachingEnabled invoked");
                }
            }
            catch (Exception e) {
                logger.log(Level.FINEST, "caught {0}", new Object[]{e});
                if (!(e instanceof SQLException)) break block6;
                throw (SQLException)e;
            }
        }
    }

    static void disableStatementPooling(Connection oconn) throws SQLException {
        block6: {
            logger.finest("disableStatementPooling");
            try {
                if (null == oconn) {
                    logger.finest("failed to get SQL conn");
                    return;
                }
                InvocationVector vector = FailoverablePooledConnectionHelper.getInvocationVector(oconn);
                Method method = vector.getMethodSetStatementCacheSize();
                if (null != method) {
                    method.invoke((Object)oconn, 0);
                    logger.finest("setStatementCacheSize invoked");
                }
                if (null != (method = vector.getMethodSetImplicitCachingEnabled())) {
                    method.invoke((Object)oconn, false);
                    logger.finest("setImplicitCachingEnabled invoked");
                }
                if (null != (method = vector.getMethodSetExplicitCachingEnabled())) {
                    method.invoke((Object)oconn, false);
                    logger.finest("setExplicitCachingEnabled invoked");
                }
            }
            catch (Exception e) {
                logger.log(Level.FINEST, "caught {0}", new Object[]{e});
                if (!(e instanceof SQLException)) break block6;
                throw (SQLException)e;
            }
        }
    }

    static boolean pingDatabaseOnOracleConnection(Connection oconn) {
        Object[] arg;
        InvocationVector vector = FailoverablePooledConnectionHelper.getInvocationVector(oconn);
        Method method = vector.getMethodPingDatabase();
        if (null == method) {
            method = vector.getMethodPingDatabaseInt();
            arg = new Object[]{0};
        } else {
            arg = new Object[]{};
        }
        try {
            return vector.getConnClass().getField("DATABASE_OK").getInt(null) == ((Integer)method.invoke((Object)oconn, arg)).intValue();
        }
        catch (Exception e) {
            logger.log(Level.FINEST, "caught {0}", new Object[]{e});
            return true;
        }
    }

    public static void abortOracleConnection(Connection oconn) {
        logger.log(Level.FINEST, "aborting connection: {0}", oconn);
        if (oconn == null) {
            return;
        }
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodAbort();
            if (null != method) {
                method.invoke((Object)oconn, new Object[0]);
                logger.finest("connection aborted");
            } else {
                logger.finest("failed to abort connection: method not found");
            }
        }
        catch (Exception ex) {
            logger.log(Level.FINEST, "caught {0}", new Object[]{ex});
        }
    }

    protected static InvocationVector getInvocationVector(Connection oracleConn) {
        Class<?> connClass = oracleConn.getClass();
        InvocationVector vector = oracleConnCache.get(connClass);
        if (null != vector) {
            return vector;
        }
        Class<?> c = null;
        try {
            c = Class.forName("oracle.jdbc.internal.OracleConnection", true, connClass.getClassLoader());
        }
        catch (Exception e) {
            logger.log(Level.FINEST, "caught {0}", new Object[]{e});
        }
        final Class<?> cls = c;
        vector = new InvocationVector(){
            private final Method abort = this.getMethod("abort");
            private final Method cancel = this.getMethod("cancel");
            private final Method isUsable = this.getMethod("isUsable");
            private final Method setStatementCacheSize = this.getMethod("setStatementCacheSize", Integer.TYPE);
            private final Method setImplicitCachingEnabled = this.getMethod("setImplicitCachingEnabled", Boolean.TYPE);
            private final Method setExplicitCachingEnabled = this.getMethod("setExplicitCachingEnabled", Boolean.TYPE);
            private final Method getServerSessionInfo = this.getMethod("getServerSessionInfo");
            private final Method pingDatabase = this.getMethod("pingDatabase");
            private final Method pingDatabaseInt = this.getMethod("pingDatabase", Integer.TYPE);
            private final Method getVersionNumber = this.getMethod("getVersionNumber");

            private Method getMethod(String method, Class type) {
                if (null != cls) {
                    try {
                        return cls.getMethod(method, type);
                    }
                    catch (NoSuchMethodException e) {
                        logger.log(Level.FINEST, "caught {0}", new Object[]{e});
                        return null;
                    }
                }
                return null;
            }

            private Method getMethod(String method) {
                if (null != cls) {
                    try {
                        return cls.getMethod(method, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        logger.log(Level.FINEST, "caught {0}", new Object[]{e});
                        return null;
                    }
                }
                return null;
            }

            public Class getConnClass() {
                return cls;
            }

            public Method getMethodAbort() {
                return this.abort;
            }

            public Method getMethodCancel() {
                return this.cancel;
            }

            public Method getMethodIsUsable() {
                return this.isUsable;
            }

            public Method getMethodSetStatementCacheSize() {
                return this.setStatementCacheSize;
            }

            public Method getMethodSetImplicitCachingEnabled() {
                return this.setImplicitCachingEnabled;
            }

            public Method getMethodSetExplicitCachingEnabled() {
                return this.setExplicitCachingEnabled;
            }

            public Method getMethodGetServerSessionInfo() {
                return this.getServerSessionInfo;
            }

            public Method getMethodPingDatabase() {
                return this.pingDatabase;
            }

            public Method getMethodPingDatabaseInt() {
                return this.pingDatabaseInt;
            }

            public Method getMethodGetVersionNumber() {
                return this.getVersionNumber;
            }
        };
        oracleConnCache.put(connClass, vector);
        return vector;
    }

    public static int getDatabaseVersion(Connection oconn) throws UniversalConnectionPoolException {
        int dbVersion = 0;
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodGetVersionNumber();
            if (null != method) {
                dbVersion = ((Short)method.invoke((Object)oconn, new Object[0])).intValue();
                logger.finest("db version obtained successfully");
            } else {
                logger.finest("failed to get db version: method not found");
            }
        }
        catch (Exception exc) {
            dbVersion = 0;
            logger.log(Level.FINEST, "getting db version from connection", exc);
        }
        return dbVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getInstanceNumber(Connection connection) throws SQLException {
        Statement stmt;
        int instId;
        block7: {
            String query = "select sys_context('userenv', 'instance') from dual";
            instId = -1;
            stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = connection.createStatement();
                    rs = stmt.executeQuery(query);
                    rs.next();
                    instId = rs.getInt(1);
                }
                catch (SQLException ea) {
                    logger.log(Level.FINEST, "getting instance id", ea);
                    instId = -1;
                    Object var7_6 = null;
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt == null) return instId;
                    stmt.close();
                    return instId;
                }
                Object var7_5 = null;
                if (rs == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (rs != null) {
                    rs.close();
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            rs.close();
        }
        if (stmt == null) return instId;
        stmt.close();
        return instId;
    }

    static interface InvocationVector {
        public Class getConnClass();

        public Method getMethodAbort();

        public Method getMethodCancel();

        public Method getMethodIsUsable();

        public Method getMethodSetStatementCacheSize();

        public Method getMethodSetImplicitCachingEnabled();

        public Method getMethodSetExplicitCachingEnabled();

        public Method getMethodGetServerSessionInfo();

        public Method getMethodPingDatabase();

        public Method getMethodPingDatabaseInt();

        public Method getMethodGetVersionNumber();
    }
}

