/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.oracle.OracleFailoverEventImpl;
import oracle.ucp.util.logging.UCPLoggerFactory;

class ONSDatabaseFailoverEvent
extends OracleFailoverEventImpl {
    private static final Logger logger = UCPLoggerFactory.createLogger(ONSDatabaseFailoverEvent.class.getCanonicalName());
    private static final String ONS_FAILOVER_EVENT_DELIMITER = "{} =";

    ONSDatabaseFailoverEvent(String eventType, byte[] eventBody) throws UniversalConnectionPoolException {
        super(eventType);
        logger.log(Level.FINEST, "eventType: {0}, eventBody: {1}", new Object[]{eventType, new String(eventBody)});
        StringTokenizer strTokens = null;
        try {
            strTokens = new StringTokenizer(new String(eventBody, "UTF-8"), ONS_FAILOVER_EVENT_DELIMITER, true);
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.FINEST, "tokenizer encoding", e);
        }
        String st = null;
        String val = null;
        String key = null;
        while (strTokens.hasMoreTokens()) {
            val = null;
            st = strTokens.nextToken();
            if (st.equals("=") && strTokens.hasMoreTokens()) {
                val = strTokens.nextToken();
            } else {
                key = st;
            }
            if (key.equalsIgnoreCase("version") && val != null && !val.equals("1.0")) {
                logger.log(Level.FINEST, "Invalid Event version {0}", val);
                break;
            }
            if (key.equalsIgnoreCase("service") && val != null) {
                this.setServiceName(val);
                continue;
            }
            if (key.equalsIgnoreCase("instance") && val != null && !val.equals(" ")) {
                this.setInstanceName(val.trim().toLowerCase());
                continue;
            }
            if (key.equalsIgnoreCase("database") && val != null) {
                this.setDbUniqueName(val.trim().toLowerCase());
                continue;
            }
            if (key.equalsIgnoreCase("host") && val != null) {
                this.setHostName(val.trim().toLowerCase());
                continue;
            }
            if (key.equalsIgnoreCase("status") && val != null) {
                this.setStatus(val);
                continue;
            }
            if (key.equalsIgnoreCase("card") && val != null) {
                try {
                    this.setCardinality(Integer.parseInt(val));
                }
                catch (NumberFormatException nfe) {
                    logger.log(Level.FINEST, "setting cardinality", nfe);
                }
                continue;
            }
            if (!key.equalsIgnoreCase("reason") || val == null) continue;
            this.setReason(val.trim().toLowerCase());
        }
        strTokens = null;
    }
}

