/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask;
import oracle.ucp.jdbc.oracle.ONSRuntimeLBEventHandlerTask;
import oracle.ucp.jdbc.oracle.OracleFailoverEvent;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPoolStatistics;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPoolStatisticsImpl;
import oracle.ucp.jdbc.oracle.OracleLoadBalancingEvent;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.jdbc.oracle.RACCallback;
import oracle.ucp.jdbc.oracle.RACInstance;
import oracle.ucp.jdbc.oracle.RACManager;
import oracle.ucp.jdbc.oracle.RACManagerFactory;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.Util;
import oracle.ucp.util.logging.UCPLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleJDBCConnectionPool
extends JDBCConnectionPool
implements RACCallback {
    private static final Logger logger = UCPLoggerFactory.createLogger(OracleJDBCConnectionPool.class.getCanonicalName());
    private final AtomicReference<String> m_onsConfigurationString = new AtomicReference<String>("");
    RACManager m_racManager = null;

    public OracleJDBCConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter);
    }

    @Override
    public UniversalPooledConnection createOnePooledConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        UniversalPooledConnection oupc = super.createOnePooledConnection(connectionRetrievalInfo);
        if (this.isFailoverEnabled()) {
            FailoverablePooledConnection fpc = (FailoverablePooledConnection)((Object)oupc);
            this.m_racManager.connectionOpened(fpc);
        }
        return oupc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void start() throws UniversalConnectionPoolException {
        JDBCUniversalPooledConnection conn;
        super.start();
        String sqlStr = this.getSQLForValidateConnection();
        if (this.getValidateConnectionOnBorrow() && null != sqlStr && !"".equals(sqlStr) && null != (conn = (JDBCUniversalPooledConnection)this.createOnePooledConnection())) {
            boolean invalidSQL;
            block14: {
                Statement stmt;
                block13: {
                    invalidSQL = false;
                    stmt = null;
                    stmt = conn.getSQLConnection(conn.getPhysicalConnection()).createStatement();
                    stmt.execute(sqlStr);
                    Object var12_5 = null;
                    if (null == stmt) break block13;
                    try {
                        stmt.close();
                    }
                    catch (SQLException e2) {
                        // empty catch block
                    }
                }
                this.closePhysicalConnection(conn.getPhysicalConnection());
                {
                    break block14;
                    catch (SQLException e) {
                        int err = e.getErrorCode();
                        for (int perr : this.getWrongSQLCodes()) {
                            if (perr != err) continue;
                            this.setValidateConnectionOnBorrow(false);
                            invalidSQL = true;
                            break;
                        }
                        Object var12_6 = null;
                        if (null != stmt) {
                            try {
                                stmt.close();
                            }
                            catch (SQLException e2) {
                                // empty catch block
                            }
                        }
                        this.closePhysicalConnection(conn.getPhysicalConnection());
                    }
                }
                catch (Throwable throwable) {
                    Object var12_7 = null;
                    if (null != stmt) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e2) {
                            // empty catch block
                        }
                    }
                    this.closePhysicalConnection(conn.getPhysicalConnection());
                    throw throwable;
                }
            }
            if (invalidSQL) {
                UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(151);
                logger.throwing(this.getClass().getName(), "start", ucpe);
                throw ucpe;
            }
        }
    }

    @Override
    public void removeAndCloseOneAvailableConnection(UniversalPooledConnection upc) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "UniversalPooledConnection: {0}", upc);
        super.removeAndCloseOneAvailableConnection(upc);
        if (this.isFailoverEnabled()) {
            FailoverablePooledConnection fpc = (FailoverablePooledConnection)((Object)upc);
            this.m_racManager.connectionClosed(fpc);
        }
    }

    @Override
    public void closeConnection(UniversalPooledConnection pooledConnection) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "UniversalPooledConnection: {0}", pooledConnection);
        super.closeConnection(pooledConnection);
        if (this.isFailoverEnabled()) {
            FailoverablePooledConnection fpc = (FailoverablePooledConnection)((Object)pooledConnection);
            this.m_racManager.connectionClosed(fpc);
        }
    }

    @Override
    public synchronized void purge() throws UniversalConnectionPoolException {
        for (UniversalPooledConnection upc : this.getAvailableConnections()) {
            this.abortConnection(upc);
        }
        for (UniversalPooledConnection upc : this.getAllBorrowedConnections()) {
            this.abortConnection(upc);
        }
        super.purge();
    }

    @Override
    public void setFailoverEnabled(boolean enabled) throws UniversalConnectionPoolException {
        super.setFailoverEnabled(enabled);
        if (this.m_racManager == null) {
            this.m_racManager = RACManagerFactory.getRACManager();
            ConnectionAffinityCallback affCbk = this.getConnectionAffinityCallback();
            if (affCbk != null) {
                this.m_racManager.registerConnectionAffinityCallback(affCbk);
            }
        }
        this.m_racManager.registerRACCallback(this);
        String onsConfig = this.m_onsConfigurationString.get();
        if (onsConfig != null && !onsConfig.equals("")) {
            this.m_racManager.setONSConfiguration(onsConfig);
        }
    }

    @Override
    protected synchronized void startFailover() throws UniversalConnectionPoolException {
        logger.finest("start failover");
        this.m_racManager.start();
    }

    @Override
    protected synchronized void stopFailover() throws UniversalConnectionPoolException {
        logger.finest("stop failover");
        this.m_racManager.stop();
    }

    protected void setFailoverEventHandlerTask(ONSDatabaseEventHandlerTask failoverEventHandlerTask) {
        logger.log(Level.FINEST, "failoverEventHandlerTask: {0}", failoverEventHandlerTask);
        RACManagerImpl racMngr = (RACManagerImpl)this.m_racManager;
        racMngr.setFailoverEventHandlerTask(failoverEventHandlerTask);
    }

    @Override
    public boolean isRuntimeLoadBalancingEnabled() {
        if (this.m_racManager != null) {
            return this.m_racManager.isRuntimeLoadBalancingEnabled();
        }
        return false;
    }

    protected void setRuntimeLoadBalancingEventHandlerTask(ONSRuntimeLBEventHandlerTask rlbEventHandlerTask) {
        logger.log(Level.FINEST, "runtimeLoadBalancingEventHandlerTask: {0}", rlbEventHandlerTask);
        RACManagerImpl racMngr = (RACManagerImpl)this.m_racManager;
        racMngr.setRuntimeLoadBalancingEventHandlerTask(rlbEventHandlerTask);
    }

    @Override
    protected UniversalPooledConnection selectConnectionPerRuntimeLoadBalancing(ConnectionRetrievalInfo cri) {
        logger.log(Level.FINEST, "ConnectionRetrievalInfo: {0}", cri);
        if (this.m_racManager != null) {
            try {
                return (OracleUniversalPooledConnection)this.m_racManager.selectConnectionPerRCLB(cri);
            }
            catch (UniversalConnectionPoolException ucpexc) {
                logger.log(Level.FINEST, "selectConnectionPerRCLB: ", ucpexc);
                return null;
            }
        }
        return null;
    }

    @Override
    public synchronized void registerConnectionAffinityCallback(ConnectionAffinityCallback affCbk) throws UniversalConnectionPoolException {
        super.registerConnectionAffinityCallback(affCbk);
        if (this.m_racManager != null) {
            this.m_racManager.registerConnectionAffinityCallback(affCbk);
        }
    }

    @Override
    public synchronized void removeConnectionAffinityCallback() throws UniversalConnectionPoolException {
        super.removeConnectionAffinityCallback();
        if (this.m_racManager != null) {
            this.m_racManager.unregisterConnectionAffinityCallback(this.getConnectionAffinityCallback());
        }
    }

    @Override
    protected UniversalPooledConnection selectConnectionPerRuntimeLoadBalancingAndAffinity(ConnectionRetrievalInfo cri) {
        if (this.m_racManager != null) {
            try {
                return (OracleUniversalPooledConnection)this.m_racManager.selectConnectionPerRCLBAndAffinity(cri);
            }
            catch (UniversalConnectionPoolException ucpexc) {
                logger.log(Level.FINEST, "selectConnectionPerRCLBAndAffinity: ", ucpexc);
                return null;
            }
        }
        return null;
    }

    UniversalPooledConnection getConnectionToNamedInstance() {
        return this.createOnePooledConnection();
    }

    public String getONSConfiguration() throws UniversalConnectionPoolException {
        return this.m_racManager.getONSConfiguration();
    }

    public void setONSConfiguration(String onsConfigStr) throws UniversalConnectionPoolException {
        String oldOnsConfigStr;
        logger.log(Level.FINEST, "onsConfigStr: {0}", onsConfigStr);
        if (onsConfigStr == null) {
            onsConfigStr = "";
        }
        if (onsConfigStr.equals(oldOnsConfigStr = this.m_onsConfigurationString.getAndSet(onsConfigStr))) {
            return;
        }
        if (this.m_racManager != null) {
            this.m_racManager.setONSConfiguration(onsConfigStr);
        }
    }

    @Override
    public OracleJDBCConnectionPoolStatistics getStatistics() {
        return new OracleJDBCConnectionPoolStatisticsImpl(this);
    }

    public long getSuccessfulAffinityBasedBorrowCount() {
        return this.m_racManager.getSuccessfulAffinityBasedBorrowCount();
    }

    public long getFailedAffinityBasedBorrowCount() {
        return this.m_racManager.getFailedAffinityBasedBorrowCount();
    }

    public long getSuccessfulRCLBBasedBorrowCount() {
        return this.m_racManager.getSuccessfulRCLBBasedBorrowCount();
    }

    public long getFailedRCLBBasedBorrowCount() {
        return this.m_racManager.getFailedRCLBBasedBorrowCount();
    }

    public String getFCFProcessingInfo() {
        return this.m_racManager.getFCFProcessingInfo();
    }

    @Override
    protected void processTimedOutConnection(UniversalPooledConnection pc) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "UniversalPooledConnection: {0}", pc);
        OracleUniversalPooledConnection opc = (OracleUniversalPooledConnection)pc;
        opc.handleTimeout();
    }

    @Override
    public void closePhysicalConnection(final Object physicalConnection) {
        logger.log(Level.FINEST, "physicalConnection: {0}", physicalConnection);
        OracleJDBCConnectionPool.submitWTPTask(new UCPTaskBase(){

            public void run() {
                OracleJDBCConnectionPool.this.superClosePhysicalConnection(physicalConnection);
            }
        });
    }

    private void superClosePhysicalConnection(Object physicalConnection) {
        super.closePhysicalConnection(physicalConnection);
    }

    @Override
    protected void abortConnection(UniversalPooledConnection pooledConnection) throws UniversalConnectionPoolException {
        OracleUniversalPooledConnection oupc = (OracleUniversalPooledConnection)pooledConnection;
        oupc.abortPhysicalConnection();
    }

    @Override
    protected int[] getWrongSQLCodes() {
        return new int[]{942, 904, 923};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initiateDownEventProcessing(OracleFailoverEvent event) {
        try {
            FailoverablePooledConnection[] aconns = this.getAllAvailableFPCs();
            FailoverablePooledConnection[] bconns = this.getAllBorrowedFPCs();
            OracleJDBCConnectionPool oracleJDBCConnectionPool = this;
            synchronized (oracleJDBCConnectionPool) {
                this.m_racManager.markDownConnectionsForDownEvent(aconns, bconns, event);
            }
            oracleJDBCConnectionPool = this;
            synchronized (oracleJDBCConnectionPool) {
                this.m_racManager.cleanupConnectionsForDownEvent(aconns, bconns, event);
            }
        }
        catch (Exception exc) {
            logger.throwing(this.getClass().getName(), "callback processDownEvent failed: ", exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int initiateUpEventProcessing(OracleFailoverEvent event) {
        try {
            OracleJDBCConnectionPool oracleJDBCConnectionPool = this;
            synchronized (oracleJDBCConnectionPool) {
                return this.m_racManager.processUpEvent(this.getAllAvailableFPCs(), this.getAllBorrowedFPCs(), this.getInitialPoolSize(), this.getMaxPoolSize(), event);
            }
        }
        catch (Exception exc) {
            logger.throwing(this.getClass().getName(), "callback processUpEvent failed: ", exc);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FailoverablePooledConnection openNewConnection(String url, RACInstance racInstance) {
        if (url == null || url.equals("")) {
            try {
                OracleJDBCConnectionPool oracleJDBCConnectionPool = this;
                synchronized (oracleJDBCConnectionPool) {
                    this.addNewConnections(this.getConnectionRetrievalInfo(), 1);
                }
            }
            catch (Exception exc) {
                logger.throwing(this.getClass().getName(), "callback openNewConnection failed: ", exc);
            }
        } else {
            JDBCConnectionFactoryAdapter cfa = (JDBCConnectionFactoryAdapter)this.getConnectionFactoryAdapter();
            FailoverablePooledConnection fpc = null;
            String originalUrl = cfa.getUrl();
            String namedInstanceUrl = url;
            if (namedInstanceUrl != null) {
                cfa.setUrl(namedInstanceUrl);
                fpc = (FailoverablePooledConnection)((Object)this.createOnePooledConnection());
                cfa.setUrl(originalUrl);
                return fpc;
            }
            logger.log(Level.FINEST, "URL invalid for connecting to named instance");
        }
        return null;
    }

    @Override
    public String getUrl() {
        JDBCConnectionFactoryAdapter cfa = (JDBCConnectionFactoryAdapter)this.getConnectionFactoryAdapter();
        return cfa.getUrl();
    }

    @Override
    public String getPoolName() {
        return this.getName();
    }

    @Override
    public int getRoomToGrowPool() {
        return this.roomToGrow();
    }

    @Override
    public boolean isValid(FailoverablePooledConnection fpc) {
        OracleUniversalPooledConnection oupc = (OracleUniversalPooledConnection)fpc;
        return oupc.isValid();
    }

    private FailoverablePooledConnection[] getAllAvailableFPCs() {
        UniversalPooledConnection[] upcs = this.getAvailableConnections();
        if (upcs != null) {
            FailoverablePooledConnection[] aconns = new FailoverablePooledConnection[upcs.length];
            int i = 0;
            for (UniversalPooledConnection upc : upcs) {
                aconns[i++] = (FailoverablePooledConnection)((Object)upc);
            }
            return aconns;
        }
        return null;
    }

    private FailoverablePooledConnection[] getAllBorrowedFPCs() {
        UniversalPooledConnection[] upcs = this.getAllBorrowedConnections();
        if (upcs != null) {
            FailoverablePooledConnection[] bconns = new FailoverablePooledConnection[upcs.length];
            int i = 0;
            for (UniversalPooledConnection upc : upcs) {
                bconns[i++] = (FailoverablePooledConnection)((Object)upc);
            }
            return bconns;
        }
        return null;
    }

    @Override
    public FailoverablePooledConnection getAvailableConnectionToInstance(ConnectionRetrievalInfo cri, RACInstance racInstance) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "cri: {0}, racInstance: {1}", new Object[]{cri, racInstance});
        FailoverablePooledConnection pc = null;
        FailoverablePooledConnection tmpPc = null;
        Collection conns = this.getAvailablePhysicalConnections(cri);
        int sz = conns.size();
        int numToClose = 0;
        UniversalPooledConnection[] connectionsToClose = new UniversalPooledConnection[sz];
        for (UniversalPooledConnection conn : conns) {
            UniversalPooledConnectionStatus status = conn.getStatus();
            if (!status.equals(UniversalPooledConnectionStatus.STATUS_NORMAL)) continue;
            boolean needValidateOnBorrow = this.getValidateConnectionOnBorrow();
            if (needValidateOnBorrow) {
                conn.validate();
            }
            if (!needValidateOnBorrow || conn.isValid()) {
                tmpPc = (FailoverablePooledConnection)((Object)conn);
                if (!Util.sameOrEqual(tmpPc.getInstance(), racInstance.getInstance()) || !Util.sameOrEqual(tmpPc.getDatabase(), racInstance.getDatabase())) continue;
                pc = tmpPc;
                break;
            }
            connectionsToClose[numToClose] = conn;
            ++numToClose;
        }
        for (int j = 0; j < numToClose; ++j) {
            try {
                this.removeAndCloseOneAvailableConnection(connectionsToClose[j]);
                continue;
            }
            catch (UniversalConnectionPoolException exc) {
                logger.log(Level.FINEST, "closing onnection failed", exc);
            }
        }
        logger.log(Level.FINEST, "Returning fpc: {0}, racInstance: {1}", new Object[]{pc, racInstance});
        return pc;
    }

    @Override
    public Collection<FailoverablePooledConnection> getAvailableConnections(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        Collection upcs = this.getAvailablePhysicalConnections(cri);
        HashSet<FailoverablePooledConnection> fpcs = new HashSet<FailoverablePooledConnection>(upcs.size());
        for (UniversalPooledConnection upc : upcs) {
            fpcs.add((FailoverablePooledConnection)((Object)upc));
        }
        return fpcs;
    }

    @Override
    public void lbaEventOccurred(OracleLoadBalancingEvent rlbEvent) throws UniversalConnectionPoolException {
    }

    void setRACManager(RACManagerImpl racMngr) {
        this.m_racManager = racMngr;
    }
}

