<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
 	xmlns:fn="http://www.w3.org/2005/xpath-functions" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema" 
	version="1.0"
	exclude-result-prefixes="tns fn xs" >

	<xsl:output method="xml" indent="yes"/>
	<xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'" />
	<xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
	
	<xsl:template match="@*|node()">
  		<xsl:copy>
    		<xsl:apply-templates select="@*|node()"/>
  		</xsl:copy>
	</xsl:template>

	<xsl:template match="Title/Fields/CustomFields">
		<xsl:if test="count(CustomField[@name='TitleLanguage']) = 1">
		   <Languages>
		   	<Language>
		   		<xsl:attribute name="value"><xsl:value-of select="CustomField[@name='TitleLanguage']/Value"/></xsl:attribute>
		   	</Language>
		</Languages>
		</xsl:if>
		<xsl:copy>
		 	<xsl:apply-templates select="@*|node()"/>
  		</xsl:copy>
	</xsl:template>
	
	<!-- Custom fields - Language - Display -->			
	<xsl:template match="Display/Fields/Language">
    	<Languages>
    		<xsl:copy>
	    		<xsl:apply-templates select="@*|node()"/>
    		</xsl:copy>
    	</Languages>
	</xsl:template>
	
 				
	<!-- UnparsableFields -->			
	<xsl:template match="UnparsableField">
  			<xsl:copy>
    			<xsl:apply-templates select="@*|node()"/>
    			<xsl:if test="@xpath = '/Fields/Avail/TimeCodeOne'">
    				<xsl:attribute name="xpath">/Fields/Avails/Avail/TimeCodeOne</xsl:attribute>
    				<xsl:attribute name="indices">1,1,1,1</xsl:attribute>
    			</xsl:if>
    			<xsl:if test="@xpath = '/Fields/Avail/TimeCodeTwo'">
    				<xsl:attribute name="xpath">/Fields/Avails/Avail/TimeCodeTwo</xsl:attribute>
    				<xsl:attribute name="indices">1,1,1,1</xsl:attribute>
    			</xsl:if>
    			<xsl:if test="@xpath = '/Fields/Avail/TimeCodeThree'">
    				<xsl:attribute name="xpath">/Fields/Avails/Avail/TimeCodeThree</xsl:attribute>
    				<xsl:attribute name="indices">1,1,1,1</xsl:attribute>
    			</xsl:if>
    			<xsl:if test="@xpath = '/Fields/Avail/TimeCodeFour'">
    				<xsl:attribute name="xpath">/Fields/Avails/Avail/TimeCodeFour</xsl:attribute>
    				<xsl:attribute name="indices">1,1,1,1</xsl:attribute>
    			</xsl:if>
			</xsl:copy>
	</xsl:template>

	<!-- Avail -->			
	<xsl:template match="Avail">
		<Avails>
			<xsl:copy>
    			<xsl:apply-templates select="@*|node()"/>
			</xsl:copy>
		</Avails>
	</xsl:template>

	<!-- Viewing Window -->			
	<xsl:template match="ViewingWindow">
		<ViewingWindows>
  			<xsl:copy>
    			<xsl:apply-templates select="@*|node()"/>
  			</xsl:copy>
		</ViewingWindows>
	</xsl:template>

	<!-- AssociationId -->			
	<xsl:template match="AssociationId">
		<AssociationIds>
  			<xsl:copy>
    			<xsl:apply-templates select="@*|node()"/>
  			</xsl:copy>
		</AssociationIds>
	</xsl:template>

	<!-- EquipCapabilityProfile -->			
	<xsl:template match="EquipCapabilityProfile">
		<EquipCapabilityProfileList>
  			<xsl:copy>
    			<xsl:apply-templates select="@*|node()"/>
  			</xsl:copy>
		</EquipCapabilityProfileList>
	</xsl:template>

	<!-- AlternateBitRateResolution -->			
	<xsl:template match="AlternateBitRateResolution">
		<AlternateBitRateResolutionList>
  			<xsl:copy>
    			<xsl:apply-templates select="@*|node()"/>
  			</xsl:copy>
		</AlternateBitRateResolutionList>
	</xsl:template>
</xsl:stylesheet>
