set FEEDBACK off

CREATE OR REPLACE PACKAGE PURGE_WFS AS
	PROCEDURE PURGE_OLDDATA(cutoffdate_in IN DATE,fastdelete IN VARCHAR2 default 'TRUE');
  PROCEDURE ENABLE_DISABLE_FOREIGNKEYS (V_ENABLE_DISABLE IN VARCHAR2);
  PROCEDURE enable_disable_const(p_table_name IN VARCHAR2, p_enable_disable IN VARCHAR2, p_mask_msg VARCHAR2 DEFAULT 'N');
  vsql varchar2(32767);
END;
/

CREATE OR REPLACE PACKAGE BODY purge_wfs AS
/* Procedure: CreateObject. Executes a dynamic SQL statement and logs error in delete_log table */
  procedure createobject(vsql varchar2,errmsg varchar2 default null, mask varchar2 default 'N') is
    verrmsg varchar2(32000);
  BEGIN
    --dbms_output.put_line('SQL:'||vsql);
    EXECUTE IMMEDIATE VSQL;
  EXCEPTION
    WHEN OTHERS THEN
          verrmsg := substr(errmsg ||' '||sqlerrm,1,4000);
          --dbms_output.put_line(verrmsg);
      IF UPPER(MASK) != 'Y' THEN
          EXECUTE IMMEDIATE 'INSERT INTO delete_log values('''||REPLACE(verrmsg,'''')||''','''||SYSDATE||''')';
          COMMIT;
          RAISE;
      END IF;
  END CREATEOBJECT;

	PROCEDURE enable_disable_foreignkeys (V_ENABLE_DISABLE IN VARCHAR2) IS
		err_msg	VARCHAR2(500);
    CURSOR CUR_CONST IS SELECT TABLE_NAME, CONSTRAINT_NAME 
                          FROM USER_CONSTRAINTS WHERE CONSTRAINT_TYPE='R' AND R_CONSTRAINT_NAME IN (
                           SELECT CONSTRAINT_NAME FROM USER_CONSTRAINTS 
                            WHERE TABLE_NAME IN ('JBPM_TOKEN','JBPM_PROCESSINSTANCE','JBPM_MODULEINSTANCE',
                                                 'JBPM_TOKENVARIABLEMAP','JBPM_VARIABLEINSTANCE','JBPM_LOG','TTV_MESSAGELOG',
												 'TTV_PROCESSINSTANCENOTE','JBPM_TASKINSTANCE')
                              AND CONSTRAINT_TYPE='P' )
                              AND CONSTRAINT_NAME NOT IN (SELECT REF_PTN_CONSTRAINT_NAME
                                      FROM USER_PART_TABLES 
                                      WHERE PARTITIONING_TYPE='REFERENCE');
  
 	BEGIN    
    FOR CONST_REC IN CUR_CONST
    LOOP
      IF (V_ENABLE_DISABLE='DISABLE') THEN
         DBMS_OUTPUT.PUT_LINE('ALTER TABLE '||CONST_REC.TABLE_NAME||' DISABLE CONSTRAINT '||CONST_REC.CONSTRAINT_NAME);
         CREATEOBJECT('ALTER TABLE '||CONST_REC.TABLE_NAME||' DISABLE CONSTRAINT '||CONST_REC.CONSTRAINT_NAME,'Err Msg','Y');
         
      ELSIF (V_ENABLE_DISABLE='ENABLE') THEN
         CREATEOBJECT('ALTER TABLE '||CONST_REC.TABLE_NAME||' MODIFY CONSTRAINT '||CONST_REC.CONSTRAINT_NAME||' ENABLE NOVALIDATE INITIALLY DEFERRED DEFERRABLE',
                       'ENABLE CONST '||CONST_REC.CONSTRAINT_NAME);
      END IF;
    END LOOP;
	END ENABLE_DISABLE_FOREIGNKEYS;
	
  PROCEDURE enable_disable_const(p_table_name IN VARCHAR2, p_enable_disable IN VARCHAR2, p_mask_msg VARCHAR2 DEFAULT 'N') IS    
    enable_disable varchar2(50);
    MSG_STR varchar2(100);
    
  BEGIN
    IF UPPER(P_ENABLE_DISABLE)='E' THEN
      enable_disable:= 'ENABLE NOVALIDATE';
      msg_str := 'Enabled constraints';
    ELSIF UPPER(P_ENABLE_DISABLE)='D' THEN
      enable_disable:= 'DISABLE';
      msg_str := 'Disabled constraints';
    END IF;

    FOR c_const_rec IN (SELECT 'ALTER TABLE '||owner||'.'||table_name||' '||enable_disable||' CONSTRAINT '||constraint_name AS CONST_STR
                          FROM USER_CONSTRAINTS WHERE CONSTRAINT_TYPE='R' AND R_CONSTRAINT_NAME IN (SELECT CONSTRAINT_NAME FROM USER_CONSTRAINTS
                         WHERE constraint_type='P' AND table_name=''||upper(p_table_name)||'')) 
    LOOP
         createobject(C_CONST_REC.CONST_STR,C_CONST_REC.CONST_STR,p_mask_msg);
    END LOOP;
    dbms_output.put_line(msg_str||' on '||p_table_name);
  END enable_disable_const;
  
	PROCEDURE PURGE_OLDDATA(CUTOFFDATE_IN IN DATE,fastdelete IN VARCHAR2 default 'TRUE') IS
		wk_message	VARCHAR2(500);
		vcntpart		NUMBER;
		err_msg		  VARCHAR2(500);
    TYPE t_date IS TABLE OF DATE;
    v_datearray t_date := t_date();
    TYPE t_long IS TABLE OF LONG;
    v_longarray t_long := t_long();
    v_highdtinterval date;

	BEGIN
    -- Drop the delete_log
    VSQL:='Drop table DELETE_LOG';
		CREATEOBJECT(vsql,'DROP DELETE_LOG','Y');

    -- Create delete_log table
    VSQL:='CREATE TABLE delete_log(Message varchar2(4000), recordTime timestamp default systimestamp)';
		CREATEOBJECT(vsql,'CREATE DELETE_LOG');

    VSQL:='INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''Script started'',systimestamp)';
    CREATEOBJECT(vsql,'INSERT DELETE_LOG');    
    
    --PURGE_WFS.ENABLE_DISABLE_FOREIGNKEYS ('DISABLE');
    
    SELECT COUNT(*) INTO vcntpart FROM user_tab_partitions WHERE table_name='JBPM_TOKEN';
    
    IF (VCNTPART > 0 AND FASTDELETE='TRUE' AND (SYSDATE > CUTOFFDATE_IN)) THEN
      
      SELECT HIGH_VALUE 
      BULK COLLECT INTO V_LONGARRAY 
      FROM USER_TAB_PARTITIONS 
      WHERE TABLE_NAME='JBPM_TOKEN'
      order by PARTITION_POSITION;

      IF V_LONGARRAY.COUNT >0 THEN
        
        FOR i IN 1..(v_longarray.COUNT) LOOP
        --dbms_output.put_line(to_date(substr(v_longarray(i),12,19),'YYYY-MM-DD HH24:MI:SS'));
          IF (to_date(substr(v_longarray(i),12,19),'YYYY-MM-DD HH24:MI:SS') < cutoffdate_in) THEN
          --dbms_output.put_line(SUBSTR(V_LONGARRAY(I),12,19));
            V_DATEARRAY.EXTEND; 
            V_DATEARRAY(I) := TO_DATE(SUBSTR(V_LONGARRAY(I),12,19),'YYYY-MM-DD HH24:MI:SS');
          END IF;
        END LOOP;
      END IF;
    
      IF (v_datearray.COUNT > 0) THEN
        --dbms_output.put_line(v_datearray(v_datearray.COUNT));
        V_HIGHDTINTERVAL :=  V_DATEARRAY(V_DATEARRAY.COUNT) ; 
      
        --dbms_output.put_line(v_highdtinterval);
        -- Drop and recreate the table tmppurgewo
/*
        VSQL:='Drop table tmppurgewo';
        CREATEOBJECT(VSQL,'DROP tmppurgewo','Y');
      
        VSQL:='CREATE TABLE tmppurgewo(jp_id, jt_id, PRIMARY KEY(jp_id, jt_id)) 
                 ORGANIZATION INDEX 
                 NOLOGGING
                 AS SELECT DISTINCT JP.ID_,JT.ID_
                        FROM JBPM_TOKEN JT, JBPM_PROCESSINSTANCE JP
                        WHERE JT.PROCESSINSTANCE_ = JP.ID_
                        and JT.createDate < to_date('''||TO_CHAR(v_highdtinterval,'YYYY-MM-DD')||''',''YYYY-MM-DD'')';
        CREATEOBJECT(vsql,'CREATE tmppurgewo');

        VSQL:='INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''Created temp table tmppurgewo'',systimestamp)';
        CREATEOBJECT(vsql,'INSERT DELETE_LOG');

        ENABLE_DISABLE_FOREIGNKEYS('DISABLE');
*/    
        DELETE FROM TTV_MONITOREDDRIVEHISTORY
        WHERE createdate < v_highdtinterval;
        
        VSQL :='INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''FINISHED TTV_MONITOREDDRIVEHISTORY'',systimestamp)';
        CREATEOBJECT(VSQL,'insert delete_log ttvmdh');
      
        DELETE FROM alert_actions_hist
        WHERE hist_key IN ( SELECT  hist_key
                           FROM    ALERTS_HIST 
                           WHERE   TIME_KEY < v_highdtinterval);
        
        VSQL :='INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''Finished alert_actions_hist'',systimestamp)';
        CREATEOBJECT(VSQL,'insert delete_log aah');
                           
        DELETE FROM alerts_hist 
        WHERE   TIME_KEY < v_highdtinterval;
        
        VSQL :='INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''Finished alerts_hist'',systimestamp)';
        CREATEOBJECT(VSQL,'insert delete_log ah');
      
/*      
        VSQL := 'DELETE FROM TTV_RESOURCEGROUPQUEUEITEM WHERE TOKENID IN ( SELECT jt_id from tmppurgewo)';
        CREATEOBJECT(VSQL,'delete TTV_RESOURCEGROUPQUEUEITEM');
  
        VSQL := 'INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''Finished TTV_RESOURCEGROUPQUEUEITEM'',systimestamp)';
        CREATEOBJECT(VSQL,'insert delete_log trgqi');
        
        vsql := 'DELETE FROM ttv_resourceusagehistory WHERE processinstanceid IN (SELECT jp_id FROM tmppurgewo)';
        CREATEOBJECT(VSQL,'delete ttv_resourceusagehistory');
        
        vsql := 'INSERT INTO DELETE_LOG (MESSAGE, RECORDTIME) VALUES(''Finished ttv_resourceusagehistory'',SYSTIMESTAMP)';
        CREATEOBJECT(VSQL,'insert delete_log truh');
*/
/*
        VSQL := 'DELETE FROM ttv_PROCESSINSTANCENOTE WHERE processinstanceid IN (SELECT jp_id FROM tmppurgewo)';
        CREATEOBJECT(VSQL,'delete ttv_processinstancenote');
        
        VSQL := 'INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''Finished ttv_PROCESSINSTANCENOTE'',systimestamp)';
        CREATEOBJECT(VSQL,'insert delete_log tpin');
*/
	    FOR I IN 1..V_DATEARRAY.COUNT LOOP
	        IF (V_DATEARRAY(I) < CUTOFFDATE_IN) THEN
	          VSQL:='Alter table jbpm_token drop partition for (to_date('''||TO_CHAR(V_DATEARRAY(I) - numtodsinterval(1,'SECOND'),'YYYY-MM-DD')||''',''YYYY-MM-DD'')) update indexes';        
	          CREATEOBJECT(VSQL,'Drop partition');
	          dbms_output.put_line('Dropped the partition before '||TO_CHAR(V_DATEARRAY(I)));
	        END IF;
	    END LOOP;

      VSQL :='INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''Finished JBPM_TOKEN'',systimestamp)';        
      CREATEOBJECT(VSQL,'insert delete_log jbpm_token');

      END IF;
    
    ELSIF (sysdate > cutoffdate_in) THEN
   
      -- Drop and recreate the table tmppurgewo to store all delete candidate records
      vsql:='Drop table tmppurgewo';
      CREATEOBJECT(VSQL,'DROP tmppurgewo','Y');

      VSQL:='CREATE TABLE tmppurgewo(jp_id,jt_id,jl_id,PRIMARY KEY(jp_id,jt_id,jl_id)) 
       ORGANIZATION INDEX 
       NOLOGGING
       AS SELECT DISTINCT JP.ID_,JT.ID_,nvl(JL.ID_,0)
              FROM JBPM_TOKEN JT, JBPM_PROCESSINSTANCE JP,JBPM_Log JL
              WHERE JT.PROCESSINSTANCE_ = JP.ID_
              and jt.ID_ = JL.token_ (+)
              and JP.createDate < to_date('''||to_char(cutoffdate_in,'YYYY-MM-DD')||''',''YYYY-MM-DD'')';
      CREATEOBJECT(VSQL,'CREATE tmppurgewo','Y');
		 
     	DELETE FROM TTV_MONITOREDDRIVEHISTORY
			WHERE createdate < cutoffdate_in;
			
			VSQL :='INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''FINISHED TTV_MONITOREDDRIVEHISTORY'',systimestamp)';
      CREATEOBJECT(VSQL,'insert delete_log ttvmdh');
		
			DELETE FROM alert_actions_hist
			WHERE hist_key IN ( SELECT  hist_key
			                   FROM    alerts_hist 
			                   WHERE   time_key < cutoffdate_in);
			
			VSQL :='INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''Finished alert_actions_hist'',systimestamp)';
      CREATEOBJECT(VSQL,'insert delete_log aah');
			                   
			DELETE FROM alerts_hist 
			WHERE   time_key < cutoffdate_in;
			
			VSQL :='INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''Finished alerts_hist'',systimestamp)';
      CREATEOBJECT(VSQL,'insert delete_log ah');
		
			VSQL := 'DELETE FROM TTV_MESSAGELOG WHERE LOGID IN  (select jl_id from tmppurgewo where jl_id is not null)';
      CREATEOBJECT(VSQL,'delete ttv_messagelog');
      
			VSQL := 'INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''Finished ttv_messagelog'',systimestamp)';
			CREATEOBJECT(VSQL,'insert delete_log tml');

      enable_disable_const('JBPM_LOG','D','Y');
			VSQL := 'DELETE FROM JBPM_LOG WHERE token_ IN (	SELECT jt_id from tmppurgewo)';
			CREATEOBJECT(VSQL,'delete jbpm_log');
      enable_disable_const('JBPM_LOG','E','Y');			

			VSQL := 'INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''Finished jbpm_log'',systimestamp)';
			CREATEOBJECT(VSQL,'insert delete_log tml');
		
      enable_disable_const('JBPM_VARIABLEINSTANCE','D','Y');
			vsql := 'DELETE FROM jbpm_variableinstance WHERE processinstance_ IN (SELECT jp_id FROM tmppurgewo)';
			CREATEOBJECT(VSQL,'delete jbpm_variableinstance');
      enable_disable_const('JBPM_VARIABLEINSTANCE','E','Y');
      
			VSQL := 'INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''Finished jbpm_variableinstance'',systimestamp)';
			CREATEOBJECT(VSQL,'insert delete_log jvi');
      
			VSQL := 'DELETE FROM jbpm_tokenvariablemap WHERE token_  IN (	SELECT jt_id from tmppurgewo)';
			CREATEOBJECT(VSQL,'delete jbpm_tokenvariablemap');
			
			VSQL := 'INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''Finished jbpm_tokenvariablemap'',systimestamp)';
			CREATEOBJECT(VSQL,'insert delete_log jtvm');

			VSQL := 'DELETE FROM jbpm_taskinstance WHERE TOKEN_ IN ( SELECT jt_id from tmppurgewo)';
			CREATEOBJECT(VSQL,'delete jbpm_taskinstance');
			                 
			VSQL := 'INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''Finished jbpm_moduleinstance'',systimestamp)';
			CREATEOBJECT(VSQL,'insert delete_log jmi');
		
			VSQL := 'DELETE FROM jbpm_moduleinstance WHERE processinstance_ IN (SELECT jp_id FROM tmppurgewo)';
			CREATEOBJECT(VSQL,'delete jbpm_moduleinstance');
			
      VSQL := 'INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''Finished jbpm_moduleinstance'',systimestamp)';
			CREATEOBJECT(VSQL,'insert delete_log jmi');

/*		
      VSQL := 'DELETE FROM TTV_RESOURCEGROUPQUEUEITEM WHERE TOKENID IN ( SELECT jt_id from tmppurgewo)';
			CREATEOBJECT(VSQL,'delete TTV_RESOURCEGROUPQUEUEITEM');

      VSQL := 'INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''Finished TTV_RESOURCEGROUPQUEUEITEM'',systimestamp)';
			CREATEOBJECT(VSQL,'insert delete_log trgqi');

			vsql := 'DELETE FROM ttv_resourceusagehistory WHERE processinstanceid IN (SELECT jp_id FROM tmppurgewo)';
			CREATEOBJECT(VSQL,'delete ttv_resourceusagehistory');
			
			vsql := 'INSERT INTO DELETE_LOG (MESSAGE, RECORDTIME) VALUES(''Finished ttv_resourceusagehistory'',SYSTIMESTAMP)';
			CREATEOBJECT(VSQL,'insert delete_log truh');
*/		
			VSQL := 'DELETE FROM ttv_PROCESSINSTANCENOTE WHERE processinstanceid IN (SELECT jp_id FROM tmppurgewo)';
			CREATEOBJECT(VSQL,'delete ttv_processinstancenote');
			
			VSQL := 'INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''Finished ttv_PROCESSINSTANCENOTE'',systimestamp)';
			CREATEOBJECT(VSQL,'insert delete_log tpin');

			VSQL := 'UPDATE jbpm_token SET ProcessInstance_ = NULL WHERE id_ in (SELECT jt_id FROM tmppurgewo)';
			CREATEOBJECT(VSQL,'UPDATE jbpm_token');
			
      Vsql := 'INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''updated jbpm_token'',systimestamp)';
			CREATEOBJECT(VSQL,'insert delete_log jmi');
		
      enable_disable_const('JBPM_PROCESSINSTANCE','D','Y');
			vsql := 'DELETE FROM jbpm_processinstance WHERE id_ in (select jp_id from tmppurgewo)';
			CREATEOBJECT(VSQL,'delete jbpm_processinstance');
      enable_disable_const('JBPM_PROCESSINSTANCE','E','Y');
      
			VSQL := 'INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''Finished jbpm_processinstance'',systimestamp)';
			CREATEOBJECT(VSQL,'insert delete_log jpi');

      enable_disable_const('JBPM_TOKEN','D','Y');		
			VSQL := 'DELETE FROM jbpm_token WHERE id_ IN (SELECT jt_id FROM tmppurgewo)';
			CREATEOBJECT(VSQL,'delete jbpm_token');
      enable_disable_const('JBPM_TOKEN','E','Y');
      
      VSQL := 'INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''Finished jbpm_token'',systimestamp)';
			CREATEOBJECT(VSQL,'insert delete_log jmi');

			VSQL := 'INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''Finished Purge Process'',systimestamp)';
			CREATEOBJECT(VSQL,'Finish Purge');

    END IF;
    
    COMMIT;
    VSQL:='INSERT INTO DELETE_LOG (Message, recordTime) VALUES(''Script finished successfully'',systimestamp)';
    CREATEOBJECT(vsql,'INSERT DELETE_LOG'); 		
	EXCEPTION
	  WHEN OTHERS THEN
	  		ROLLBACK;
	  		ERR_MSG :=SUBSTR(SQLERRM, 1, 500);
			VSQL := 'INSERT INTO DELETE_LOG (MESSAGE, RECORDTIME) VALUES(err_msg, SYSTIMESTAMP)';
			CREATEOBJECT(VSQL,'insert delete_log ERROR!');
			COMMIT;
	END PURGE_OLDDATA;
END PURGE_WFS;
/

exit
