#!/bin/sh
if [ `whoami` != "oracle" ]; then
   echo "**************************************************"
   echo " Only oracle user can run this script."
   echo " Please log in as an oracle user and try again...!" 
   echo "**************************************************"
   exit 1
fi
echo "*********************************************************************"

mkdir -p /home/oracle/scripts/
export ORACLE_SID=ttv

/opt/oracle/product/11.2.0/dbhome_1/bin/sqlplus -s /nolog << EOM
connect / as sysdba
set echo off
set feedback off
set head off
spool /home/oracle/scripts/db_maintenance.log

select 'Database maintenance script started at '||to_char(systimestamp,'mm/dd/yyyy hh24:mi:ss') from dual;

CREATE OR REPLACE PROCEDURE CREATE_OBJECT(vsql varchar2,errmsg varchar2, mask varchar2 default 'N') IS
    verrmsg varchar2(32000);
  BEGIN
    execute immediate vsql;
  EXCEPTION
    WHEN others THEN
          verrmsg := substr(errmsg ||' '||sqlerrm,1,4000);
      IF upper(mask) != 'Y' THEN
          EXECUTE IMMEDIATE 'INSERT INTO install_table values('''||sysdate||''','''||replace(verrmsg,'''')||''')';
          COMMIT;
          raise;
      END IF;
END CREATE_OBJECT;
/

set echo on
set serveroutput on

DECLARE
  vsql varchar2(2000);
  VSCHEMA varchar2(10):='WFS';
BEGIN

      VSQL := 'DROP INDEX '||VSCHEMA||'.mdm_index_xmltype';
      CREATE_OBJECT(vsql,'Unable to DROP INDEX '||vschema||'.mdm_index_xmltype','Y');

      VSQL := 'DROP INDEX '||VSCHEMA||'.ecmfspec_xmlindex';
      CREATE_OBJECT(VSQL,'Unable to DROP INDEX '||VSCHEMA||'.ecmfspec_xmlindex','Y');

      VSQL := 'DROP INDEX '||VSCHEMA||'.ecmfspec_rev_xmlindex';
      CREATE_OBJECT(VSQL,'Unable to DROP INDEX '||VSCHEMA||'.ecmfspec_rev_xmlindex','Y');

      VSQL := 'DROP INDEX '||VSCHEMA||'.idx_xml_path_tab';
      CREATE_OBJECT(VSQL,'Unable to DROP INDEX '||VSCHEMA||'.idx_xml_path_tab','Y');

      VSQL := 'DROP INDEX '||VSCHEMA||'.idx_ecmfdisplaytab_ttvid';
      CREATE_OBJECT(VSQL,'Unable to DROP INDEX '||VSCHEMA||'.idx_xml_path_tab','Y');

      --STRUCTURED Index for display fields
      VSQL := 'BEGIN dbms_xmlindex.dropparameter(''ecmfstructuredxml_idx''); END;';
      CREATE_OBJECT(vsql,'Unable to dropparameter of xmlindex ecmfstructuredxml_idx','Y');
      
      --context index 
      vsql := 'CREATE INDEX '||vschema||'.mdm_index_xmltype ON '||vschema||'.MDM_METADATA(OBJECT_VALUE) INDEXTYPE IS CTXSYS.CONTEXT PARAMETERS (''SYNC (ON COMMIT)'')';
      CREATE_OBJECT(vsql,'Unable to CREATE INDEX '||vschema||'.mdm_index_xmltype');
      
      --Unstructed Index on MDM_METADATA
      vsql := 'CREATE INDEX '||vschema||'.ecmfspec_xmlindex ON '||vschema||'.mdm_metadata(OBJECT_VALUE) INDEXTYPE IS XDB.XMLIndex PARAMETERS (''PATH TABLE path_tab ASYNC (SYNC ALWAYS)'')';
      CREATE_OBJECT(vsql,'Unable to CREATE INDEX '||vschema||'.ecmfspec_xmlindex');
      
      VSQL := 'create index '||VSCHEMA||'.idx_xml_path_tab on '||VSCHEMA||'.path_tab(rid,sys_orderkey_depth(order_key),order_key)';
      CREATE_OBJECT(VSQL,'Unable to CREATE INDEX '||VSCHEMA||'.idx_xml_path_tab');
      
      vsql := 'BEGIN
                   dbms_xmlindex.registerparameter(
                      ''ecmfstructuredxml_idx'',
                      ''ADD_GROUP GROUP ecmfdisplayfields
                      XMLTable ecmfdisplay_tab ''''/ECMFSpec''''
                      COLUMNS ttvid number path ''''@documentId'''',
                      PackageAssetId varchar2(4000 CHAR) path ''''Package/Fields/Identifier/Id'''',
                      titlebrief varchar2(4000 CHAR) path ''''Package/Title/Fields/Title/ShortTitle/Value'''',
                      versionmajor number path ''''Package/Fields/Version/Major'''',
                      licwinstrt timestamp(0) path ''''Package/Title/Fields/Rights/LicensingWindowStart'''',
                      licwinend timestamp(0) path ''''Package/Title/Fields/Rights/LicensingWindowEnd'''',
                      Assetname varchar2(4000 CHAR) path ''''Package/Fields/AssetName'''',
                      PriceValue number path ''''Package/Title/Fields/BillingInfo/SuggestedPrice/Value'''',
                      Duration varchar2(4000 CHAR) path ''''Package/Title/Fields/Duration/Duration'''',
                      TProviderId varchar2(4000 CHAR) path ''''Package/Title/Fields/ProviderInfo/Identifier/Id'''',
                      PProviderId varchar2(4000 CHAR) path ''''Package/Fields/ProviderInfo/Identifier/Id''''
                      '');
                END;';
      CREATE_OBJECT(vsql,'Unable to registerparameter for xmlindex');

      --Add Structured index to unstructed index
      vsql := 'ALTER INDEX '||vschema||'.ecmfspec_xmlindex parameters(''PARAM ecmfstructuredxml_idx'')';
      CREATE_OBJECT(vsql,'Unable to ALTER INDEX '||vschema||'.ecmfspec_xmlindex parameters');

      VSQL := 'create index '||VSCHEMA||'.ecmfspec_rev_xmlindex on '||VSCHEMA||'.mdm_metadata_revision(object_value) '||
              ' indextype is xdb.xmlindex parameters (''PATH TABLE path_rev_tab ASYNC (SYNC ALWAYS) '||
              ' PATHS (INCLUDE (/ECMFSpec/@documentId  /ECMFSpec/@revision))'')';
      CREATE_OBJECT(VSQL,'Unable to create index '||VSCHEMA||'.ecmfspec_rev_xmlindex on mdm_metadata_revision(object_value)');
      
      VSQL := 'create index '||VSCHEMA||'.idx_ecmfdisplaytab_ttvid on '||VSCHEMA||'.ecmfdisplay_tab(ttvid)';
      CREATE_OBJECT(VSQL,'Unable to create index '||VSCHEMA||'.idx_ecmfdisplaytab_ttvid on ecmfdisplay_tab(ttvid)');
      
      dbms_stats.unlock_table_stats('WFS','MDM_METADATA');
      dbms_stats.gather_schema_stats(ownname=>'WFS');
      dbms_stats.lock_table_stats('WFS','MDM_METADATA');
      
      dbms_output.put_line('');
      dbms_output.put_line('    
        - Rebuilding of XML INDEXES completed SUCCESSFULLY.');
      dbms_output.put_line('');
END;
/

select 'Script completed at '||to_char(systimestamp,'mm/dd/yyyy hh24:mi:ss') from dual;
spool off
exit
EOM

echo ""
echo "*********************************************************************"

