#!/bin/sh
##############################################################
# Name of the file : purge_cms_data.sh                       #
##############################################################
# Description : Script to purge the CMS(v1.5) Titles and WOs #
#               data.  This script calls the Title and Work  #
#               order scripts sequentially to purge the data.#
#                                                            #
# Created by  : Suresh Neravati                              #
# Version #   : 1.0                                          #
# Date        : 11/02/2011                                   #
#                                                            #
##############################################################

# Define the below three parameters for your database.
TITLES_TOBE_DELETED=""
TITLE_RETENSION_MARGIN=""
WORKORDER_RETENSION_DAYS=""

# Oracle sid is ttv, if not change this value in all the scripts.
ORA_SID="ttv"
PDIR="/home/oracle/scripts/cms"

# only oracle user can run this script.
if [ `whoami` !=  "oracle" ]; then
  echo "**************************************************************"
  echo " You can run this script as an oracle user only,"
  echo " Please try again as an oracle user....!"
  echo "**************************************************************"
  exit 1
fi

if [ "X${TITLES_TOBE_DELETED}" = "X" ] || [ "X${TITLE_RETENSION_MARGIN}" = "X" ] || [ "X${WORKORDER_RETENSION_DAYS}" = "X" ]; 
then
  echo "Run the script with right parameters in the script"
  exit 1
fi
if ! [[ "${TITLES_TOBE_DELETED}" =~ ^[0-9]+$ ]] ; then
  echo "TITLES_TOBE_DELETED is not a number"; 
  exit 1
fi
if ! [[ "${TITLE_RETENSION_MARGIN}" =~ ^[0-9]+$ ]] ; then
  echo "TITLE_RETENSION_MARGIN is not a number"; 
  exit 1
fi
if [ ${WORKORDER_RETENSION_DAYS} -lt 1 ]; then
   echo "Work order retention days should be greater than one day, please try again..."
   exit 1
fi

sh ${PDIR}/purge_cms_titles.sh ${TITLES_TOBE_DELETED} ${TITLE_RETENSION_MARGIN}
sh ${PDIR}/purge_cms_wos.sh ${WORKORDER_RETENSION_DAYS}

exit 0 

