##############################################################################################################
##    Script Name    : app_upgrade_rhel.sh                                                                  ##
##    Author         : Matthew Kruer                                                                        ##
##    Created on     : 08/05/2013                                                                           ##
##    Usage          : ./app_upgrade_rhel.sh                                                                ##
##    Purpose        : Back up of CMS 2.5 config and installed/updates to CMS 3.1                           ##
##                                                                                                          ##
##############################################################################################################
#!/bin/bash

#################################################################
# Backup Config Files
#################################################################
CONFIG_FILES=(
    "/etc/cron.d/sysstat"
    "/etc/cron.monthly/purgeOldXportLogs.cron"
    "/etc/init.d/alerts"
    "/etc/init.d/cms"
    "/etc/init.d/RCSSchedulerService"
    "/etc/init.d/rcssnmpsubagent"
    "/etc/modprobe.d/bonding.conf"
    "/opt/tandbergtv/cms/conf/categoryMgmt/category.properties"
    "/opt/tandbergtv/cms/conf/contentMgmt/fileupload.properties"
    "/opt/tandbergtv/cms/conf/contentMgmt/imageeditor.properties"
    "/opt/tandbergtv/cms/conf/contentMgmt/SearchFieldNames.properties"
    "/opt/tandbergtv/cms/conf/contentMgmt/searchFields.xml"
    "/opt/tandbergtv/cms/conf/contentMgmt/seriesidentifiers.properties"
    "/opt/tandbergtv/cms/conf/contentMgmt/SeriesSearchFieldNames.properties"
    "/opt/tandbergtv/cms/conf/contentMgmt/seriesSearchFields.xml"
    "/opt/tandbergtv/cms/conf/contentMgmt/ui.properties"
    "/opt/tandbergtv/cms/conf/contentMgmt/videoplayer.properties"
    "/opt/tandbergtv/cms/conf/monitoring/agent.properties"
    "/opt/tandbergtv/cms/conf/pmm/assettypes.txt"
    "/opt/tandbergtv/cms/conf/pmm/auth.xml"
    "/opt/tandbergtv/cms/conf/pmm/job.properties"
    "/opt/tandbergtv/cms/conf/pmm/pmm.properties"
    "/opt/tandbergtv/cms/conf/pmm/progress.xml"
    "/opt/tandbergtv/cms/conf/pmm/requiredFileFields.txt"
    "/opt/tandbergtv/cms/conf/pmm/search-page-config.xml"
    "/opt/tandbergtv/cms/conf/pmm/table-config.xml"
    "/opt/tandbergtv/cms/conf/pmm/ui.properties"
    "/opt/tandbergtv/cms/conf/rcs/ETV_EPG.xsd"
    "/opt/tandbergtv/cms/conf/rcs/properties/Config.properties"
    "/opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties"
    "/opt/tandbergtv/cms/conf/report/report-config.xml"
    "/opt/tandbergtv/cms/conf/scheduler/scheduler.properties"
    "/opt/tandbergtv/cms/conf/scheduler/ui.properties"
    "/opt/tandbergtv/cms/conf/services/ingest.properties"
    "/opt/tandbergtv/cms/conf/site/dist-templates.xml"
    "/opt/tandbergtv/cms/conf/site/MSOOverridables.dat"
    "/opt/tandbergtv/cms/conf/site/ui.properties"
    "/opt/tandbergtv/cms/conf/titleListMgmt/titleListMgmt.properties"
    "/opt/tandbergtv/cms/conf/tools/LinkName.properties"
    "/opt/tandbergtv/cms/conf/tools/links.xml"
    "/opt/tandbergtv/cms/conf/workflow/auth.xml"
    "/opt/tandbergtv/cms/conf/workflow/cluster.properties"
    "/opt/tandbergtv/cms/conf/workflow/report-config.xml"
    "/opt/tandbergtv/cms/conf/workflow/repositorybrowser-config.properties"
    "/opt/tandbergtv/cms/conf/workflow/search-page-config.xml"
    "/opt/tandbergtv/cms/conf/workflow/table-config.xml"
    "/opt/tandbergtv/cms/conf/workflow/ui.properties"
    "/opt/tandbergtv/cms/conf/workflow/url-config.xml"
    "/opt/tandbergtv/cms/conf/workflow/watchfolder.xml"
    "/opt/tandbergtv/cms/jboss/server/standard/deploy/adiserver.ear/adi.properties"
    "/opt/tandbergtv/cms/jboss/server/standard/deploy/adiserver.ear/fileURIConverter.properties"
    "/opt/tandbergtv/cms/jboss/server/standard/deploy/adiserver.ear/jacorb.properties"
    "/opt/tandbergtv/cms/jboss/server/standard/deploy/adiserver.ear/version.properties"
    "/opt/tandbergtv/cms/jboss/server/standard/deploy/mail-service.xml"
    "/opt/tandbergtv/cms/plugins/content/com.ericsson.metadata.series/resources/mapping.dat"
    "/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/plugin.xml"
    "/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/definition.xml"
    "/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/ecmf.properties"
    "/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/previewstylesheet.xsl"
    "/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/series_definition.xml"
    "/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/series_ecmf.properties"
    "/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/tableconfiguration.xml"
    "/opt/tandbergtv/watchpoint/tomcat/webapps/filemanager/WEB-INF/classes/com/tandbergtv/workflow/webservice/filesubsystem/ftpconfiguration.txt"
    "/opt/tandbergtv/watchpoint/tomcat/webapps/filemanager/WEB-INF/classes/log4j.xml"
    "/opt/tandbergtv/watchpoint/tomcat/webapps/watchfolder/WEB-INF/classes/log4j.xml"
    "/opt/tandbergtv/watchpoint/tomcat/webapps/watchfolder/WEB-INF/classes/watchfolder.properties"
    "/opt/tandbergtv/watchpoint/tomcat/webapps/watchfolder/WEB-INF/classes/watchfolder.xml"
    "/usr/local/acsserver/scripts/AdiNameService"
    "/usr/local/n2bb/alerts/conf/AlertEmail.template"
    "/usr/local/n2bb/alerts/conf/jacorb.properties"
    "/usr/local/n2bb/conf/alerts_settings.conf"
    "/usr/local/platform/backup/bin/commonbackup_oracle_full_back.sh"
    "/usr/local/platform/backup/bin/commonbackup_oracle_inc_back.sh"
    "/usr/local/platform/backup/conf/cms/cms_directories.txt"
    "/usr/local/platform/backup/conf/cms/cms_files.txt"
    "/usr/local/platform/warmstandby/conf/warmstandby.cfg"
)

## Application Packages
                #cablelabs1_1 Excluded
APP_PACKAGES="  adi11-resourcetype
                aide
                alerts
                cablelabs-parser-resourcetype
                category-management-resourcetype
                cms-monitoring
                cms-userguide
                content-management-resourcetype
                content-trafficking-resourcetype
                contract-manager-resourcetype
                ffmpeg
                ffmpeg-resourcetype
                ffmpeg-webservice
                filemanager
                filesubsystem-resourcetype
                ftp
                glibc
                gtk2
                Helix
                human-resourcetype
                ImageMagick
                imagemagick-resourcetype
                imagemagick-webservice
                info-cms
                info-nobody
                info-platform
                info-sftpuser
                info-tstv
                jack-audio-connection-kit
                jboss
                jdk-cacerts-tstv-cfg
                libfaac0
                licensing-test
                mediawareeditcl
                mediaware-resourcetype
                metadata-enhancement-resourcetype
                path-converter-resourcetype
                RCS
                rpcbind
                rule-engine-resourcetype
                scac-tools
                site-manager-resourcetype
                sysprep
                tomcat
                utilities-resourcetype
                vcs-cfg
                vsftpd
                vsftpd-tstv-cfg
                warmstandby
                watchfolder
                watch-folder-resourcetype
                watchpoint-cms
                x264
                xportcombinerwebservice
                xportmanager
                xporttomcat
                xportverifier
                xport-verifier-resourcetype
                xportverifierwebservice"
                
## 3rd Party Packages 
ACC_PACKAGES="  VRTSamf
                VRTSatClient
                VRTSatServer
                VRTScps
                VRTSgab
                VRTSllt
                VRTSperl
                VRTSspt
                VRTSvcs
                VRTSvcsag
                VRTSvcsdr
                VRTSvcsea
                VRTSvcsm
                VRTSvlic
                VRTSvxfen"

## Base OS Packages installed as part of the Kickstart
BASE_PACKAGES=" @Core
                bc
                cmsstaging
                cms-systems-audit
                commonbackup
                dmidecode
                dos2unix
                eject
                file
                jdk
                man
                mutt
                net-snmp
                net-snmp-utils
                nfs-utils
                ntp
                sysstat
                system-config-network-tui
                tcpdump
                zip
                samba
                hpacucli
                bwm-ng"

#Service to stop
SERVICE=(   'alerts'
            'cms'
            'rmserver'
            'tomcat'
            'xportmanager'
            'xporttomcat'
            'RCSSchedulerService'
)

#Files that need to be removed
CLEANUP=(   '/jboss/server/standard/lib/commons-httpclient-3.0.1.jar'
            '/jboss/server/standard/lib/h2-1.2.124.jar'
            '/jboss/server/standard/lib/milyn-commons-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-edisax-parser-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-magger-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-scribe-core-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-scribe-hibernate-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-scribe-ibatis-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-scribe-jpa-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-calc-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-core-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-css-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-csv-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-edi-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-ejc-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-fixed-length-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-javabean-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-json-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-misc-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-persistence-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-routing-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-rules-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-scripting-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-templating-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-validation-1.3.1.jar'
            '/jboss/server/standard/lib/opencsv-1.8.jar'
            '/jboss/server/standard/lib/persistence-api-1.0.jar'
            '/jboss/server/standard/lib/picketlink-bindings-1.0.3.final.jar'
            '/jboss/server/standard/lib/picketlink-bindings-jboss-1.0.3.final.jar'
            '/jboss/server/standard/lib/picketlink-fed-api-1.0.3.final.jar'
            '/jboss/server/standard/lib/picketlink-fed-core-1.0.3.final.jar'
            '/jboss/server/standard/lib/picketlink-fed-model-1.0.3.final.jar'
            '/jboss/server/standard/lib/picketlink-web-1.0.3.final.jar'
            '/jboss/server/standard/lib/picketlink-xmlsec-model-1.0.3.final.jar'
            '/jboss/server/standard/lib/stringtemplate-2.2.jar'
            '/jboss/server/standard/lib/xpp3_min-1.1.3.4.O.jar'
            '/jboss/server/standard/deploy/contract.war'
            '/jboss/server/standard/deploy/date.xsl'
            '/jboss/server/standard/deploy/ESBfile.esb'
            '/jboss/server/standard/deploy/ESBftp.esb'
            '/jboss/server/standard/deploy/ESBIngest.esb'
            '/jboss/server/standard/deploy/ESBxmltv.esb'
            '/jboss/server/standard/deploy/jbossesb.esb'
            '/jboss/server/standard/deploy/jbossesb-registry.sar'
            '/jboss/server/standard/deploy/jbossesb.sar'
            '/jboss/server/standard/deploy/jbpm.esb'
            '/jboss/server/standard/deploy/jbrules.esb'
            '/jboss/server/standard/deploy/properties-service.xml'
            '/jboss/server/standard/deploy/slsb.esb'
            '/jboss/server/standard/deploy/smooks.esb'
            '/jboss/server/standard/deploy/soap.esb'
            '/jboss/server/standard/deploy/soapui-client.sar'
            '/jboss/server/standard/deploy/spring.esb'
            '/jboss/server/standard/deployers/esb.deployer'
            '/workflow/lib/com.ericsson.cms.templates.jar'
            '/workflow/templates/Target Title.par'
)

#########################################################################################
# Settings
#########################################################################################

START=$(date +%s)
TIMESTAMP=`date --utc -d "@$(( $START ))" +%Y%m%d_%H%M%S`
LOGPATH="/home/upgrade"
FULL_LOG="$LOGPATH/app_upgrade_rhel.$HOSTNAME.$TIMESTAMP.log"
YUM_REPO="/etc/yum.repos.d/upgrade.repo"
YUM_REPO_SOURCE=""
Color_Off='\e[0m'       # Text Reset
Black='\e[0;30m'        # Black
Red='\e[0;31m'          # Red
Green='\e[0;32m'        # Green
Yellow='\e[0;33m'       # Yellow
Blue='\e[0;34m'         # Blue
Purple='\e[0;35m'       # Purple
Cyan='\e[0;36m'         # Cyan
White='\e[0;37m'        # White

## Abort Loop
die() {
    printf -v f "\n\n%65s";printf "%s\n" "${f// /#}" 
    printf "Error: $1\n"
    printf "Please Review Log File $FULL_LOG\n"
    printf -v f "%65s";printf "%s\n" "${f// /#}" 
    printf "%-15s${Red}%-5s${Color_Off}\n\n\n" "Update Status: " "Failed!"
    exit 1
}

startupgrade  () {
    printf -v f "\n\n%65s";printf "%s\n" "${f// /#}" 
    printf "[`date -d @$(date +%s) +'%Y-%m-%d %H:%M:%S'`]\n"
    printf "Logging Update output to $FULL_LOG\n"
    printf "$1\n"
    printf -v f "%65s";printf "%s\n" "${f// /#}" 
}

stepduration () {
    printf -v f "\n%65s";printf "%s\n" "${f// /#}" 
    printf "[`date -d @$(date +%s) +'%Y-%m-%d %H:%M:%S'`]\n"
    printf "$1\n"
    printf "${Green}%-5s${Color_Off}\n" "Status: Success"
    printf "Step Duration [`date --utc -d "@$(( $(date +%s) - $STEP_START ))" +%T`]\n"
    printf -v f "%65s";printf "%s\n\n\n" "${f// /#}" 
}

totalduration  () {
    printf -v f "\n\n%65s";printf "%s\n" "${f// /#}" 
    printf "[`date -d @$(date +%s) +'%Y-%m-%d %H:%M:%S'`]\n"
    printf "Logging Update output to $FULL_LOG\n"
    printf "$1\n"
    printf "${Green}%-5s${Color_Off}\n" "Status: Success"
    printf "Total Update Duration [`date --utc -d "@$(( $(date +%s) - $START ))" +%T`]\n"
    printf -v f "%65s";printf "%s\n" "${f// /#}" 
}

#########################################################################################
# Create log folder if it does exists
#########################################################################################
if [[ ! -d "$LOGPATH" ]]; then
    mkdir $LOGPATH
    echo "Creating $LOGPATH"
    printf "${Green}%-5s${Color_Off}\n" "Done."    
fi

(
startupgrade "Starting Application Upgrade"

#########################################################################################
# Stop Service
#########################################################################################
STEP_START=$(date +%s)
for i in "${!SERVICE[@]}"
do
    if [[ -e /etc/init.d/${SERVICE[i]} ]] ; then 
    echo "Service ${SERVICE[i]} exists"
    echo "Stopping ${SERVICE[i]} prior to system update"
    service ${SERVICE[i]} stop
    else
    echo "Service ${SERVICE[i]} not installed on system"
    fi
done
stepduration "Completed stopping all services"

#########################################################################################
# Create upgrade repository if it does not exists
#########################################################################################
while [[ $CORRECT != "y" ]]
do
    printf "Checking for Upgrade Repository\n"
    if [ ! -f ${YUM_REPO} ] ; then
        printf "%-50s\n" "Upgrade Repository not found, Please Enter Repository URL"
        printf "%-50s\n" "Examples:"
        printf "%-50s\n" "  http://www.my-repository.com/software/"
        printf "%-50s\n" "  ftp://www.my-repository.com/software/"
        printf "%-50s\n" "  file:///mnt/cdrom/"
        printf           "Enter Repository URL: "
        
        while [[ -z $YUM_REPO_SOURCE ]] ; do
        read YUM_REPO_SOURCE
        regex='(https?|ftp|file)://[-A-Za-z0-9\+&@#/%?=~_|!:,.;]*[-A-Za-z0-9\+&@#/%=~_|]'
            if [[ $YUM_REPO_SOURCE =~ $regex ]] ; then
                YUM_REPO_SOURCE=$YUM_REPO_SOURCE
            else [[ $YUM_REPO_SOURCE == "" ]]
                printf "Invalid Repository URL, Please enter again:"
                YUM_REPO_SOURCE=""
            fi
        done
    else
        YUM_REPO_SOURCE=`cat /etc/yum.repos.d/upgrade.repo |grep "baseurl" | awk -F= '{print $2}'`
    fi
    printf "%-50s\n" "Repository URL is $YUM_REPO_SOURCE"
    printf "Is this correct? [y/n] "
    read CORRECT
    if [[ $CORRECT != "y" ]] ; then
        YUM_REPO_SOURCE=""
        if [[ -f $YUM_REPO ]] ; then
            rm  $YUM_REPO
        fi
    fi
done

printf "%-45s\n" "Creating Upgrade $YUM_REPO"
echo "[Upgrade_Repository]"     >> ${YUM_REPO}
echo "name=Upgrade Repository"  >> ${YUM_REPO}
echo "baseurl=$YUM_REPO_SOURCE" >> ${YUM_REPO}
echo "enabled=1"                >> ${YUM_REPO}
echo "gpgcheck=0"               >> ${YUM_REPO}

#########################################################################################
# Check Dependencies of RPMs being installed
#########################################################################################
STEP_START=$(date +%s)
yum clean all
yum deplist ${BASE_PACKAGES} ${ACC_PACKAGES} ${APP_PACKAGES} > yum_deplist.log
if [[ -n `cat yum_deplist.log | grep "Unsatisfied dependency"` ]] ; then
    die "Missing: Dependencies; Review yum_deplist.log"
fi
stepduration "Completed Checking yum Dependencies"

#########################################################################################
# Backup Configuration Files
#########################################################################################
STEP_START=$(date +%s)
printf "%-7s" "Backing up config Files:"
BACKUP_DIR="/tmp/backup"
for c in "${CONFIG_FILES[@]}"
do
    if [[ -e "$c" ]]; then 
        printf "%-9s%s\n" "  [ OK ]" "Backing up $c to /tmp$c"
        DIRNAME=`dirname "${c}"`
        BASENAME=`basename "${c}"`
        if [ ! -d "$BACKUP_DIR"/"$DIRNAME" ] ; then
           mkdir -p "$BACKUP_DIR"/"$DIRNAME"
        fi
        cp -p "$c" "$BACKUP_DIR"/"$c"
    else 
        printf "%-9s%s\n" "  [WARN]" "Missing file $c"
    fi
done
stepduration "Completed Backing up of Old Config Files"

#########################################################################################
# Cleanup removed Files 
#########################################################################################
STEP_START=$(date +%s)
cms_root="/opt/tandbergtv/cms"
echo "Cleaning up Legacy Files and Directory"
for i in "${!CLEANUP[@]}" ; do
    if [[ -f "$cms_root${CLEANUP[i]}" ]]; then
        rm -rvf "$cms_root${CLEANUP[i]}"
    elif [[ -d "$cms_root${CLEANUP[i]}" ]]; then
        rm -rvf "$cms_root${CLEANUP[i]}"
    else
        echo "" > /dev/null 2>&1
    fi
done
stepduration "Completed Cleaning up Legacy Files and Directory"

#########################################################################################
# Remove problematic RPMs
#########################################################################################
STEP_START=$(date +%s)
erase_rpm=`rpm -qa | grep cms-upgrade-2.5`
if [ -n "$erase_rpm" ] ; then
    rpm -e $erase_rpm
fi
stepduration "Completed Removal of Problematic RPMs"

#########################################################################################
# If rPath found remove it
#########################################################################################
STEP_START=$(date +%s)
if [ -x /usr/bin/conary ] ; then
    printf "%-45s" "Removing Conary:"
    conary erase iconfig
    conary erase conary-cim-configuration
    conary erase conary-cim rpath-tools
    conary erase conary
    printf "${Green}%-5s${Color_Off}\n" "Done."
else
    echo "Conary Not Installed"
fi
stepduration "Completed Removing Conary"

#########################################################################################
# Updating Existing System Packages
#########################################################################################
STEP_START=$(date +%s)
printf "%-45s\n" "Updating Existing System Packages:"
yum update -v -d 10 --assumeyes                   2>&1 || die "Missing: System RPMs Not Found In Repository"
stepduration "Completed Updating Existing System Packages"

#########################################################################################
# Installing New System and Appliance Packages
#########################################################################################
STEP_START=$(date +%s)
printf "%-45s\n" "Installing New System and Appliance Packages:"
yum install -v -d 10 --assumeyes ${BASE_PACKAGES} 2>&1 || die "Missing: System RPMs Not Found In Repository"
stepduration "Completed Installing New System and Appliance Packages"

## Install 3rd Party RPMs
STEP_START=$(date +%s)
yum install -v -d 10 --assumeyes ${ACC_PACKAGES}  2>&1 || die "Missing: 3rd Party RPMs Not Found In Repository"
stepduration "Completed Installing 3rd Party Packages"

## Install App
STEP_START=$(date +%s)
rm /opt/tandbergtv/cms/jboss
rm /opt/tandbergtv/watchpoint/tomcat
yum install -v -d 10 --assumeyes ${APP_PACKAGES}  2>&1 || die "Missing: Appliance RPMs Not Found In Repository"
printf "${Green}%-5s${Color_Off}\n" "Done."
stepduration "Completed Installing Appliance Packages"

#########################################################################################
# Update Service Start Order
#########################################################################################
STEP_START=$(date +%s)
for i in "${!SERVICE[@]}"
do
    if [[ -e /etc/init.d/${SERVICE[i]} ]] ; then 
    echo "Service ${SERVICE[i]} exists"
    echo "Updating start order for ${SERVICE[i]}"
    chkconfig --add ${SERVICE[i]}
    chkconfig ${SERVICE[i]} on
    else
    echo "Service ${SERVICE[i]} not installed on system"
    fi
done
stepduration "Completed Updating Services Startup Order"

#########################################################################################
# Post Upgrade Fixs 
#########################################################################################
STEP_START=$(date +%s)
echo "Updating symbolic link for java"
ln -svf /usr/java/default/bin/java /usr/bin/java
stepduration "Completed Updating Symbolic Link for java"

STEP_START=$(date +%s)
echo "Clearing JacOrb cache"
find /opt/tandbergtv/cms/jboss/bin -name "_nsdb_*" -exec rm -rvf {} \;
stepduration "Completed Clearing JacOrb cache"


#########################################################################################
# Merge/Update Config Files 
#########################################################################################
#cp -pv "$BACKUP_DIR" /
#cp "$BACKUP_DIR" /

totalduration "Finished Updating Appliance"

) 2>&1 | tee -a ${FULL_LOG}
