##############################################################################################################
##    Script Name    : attCustomUpgradesFromCMS1_2.sh                                                       ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/30/2013                                                                           ##
##    Usage          : ./attCustomUpgradesFromCMS1_2.sh                                                     ##
##    Purpose        : Upgrade tasks required only if upgrading for ATT from CMS 1.2.                       ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## This upgrade script does upgrades which are required only if upgrading for ATT from  
##      CMS version 1.2.
##

logMsg "attCustomUpgradesFromCMS1_2.sh invoked with args: $*"

ACTIVITY="performing upgrades required only when upgrading for ATT from CMS version $CMS_VERSION_1_2"

activitySeparator

logBeginMsg "$ACTIVITY"
        
## Custom upgrade tasks required for ATT 1.2->3.1 upgrade only.
./attCustomUpgradeTasks.sh
     
activitySeparator

cd $SCRIPTS_DIR
	
## Upgrade Custom Rules
./attUpgradeCustomRules.sh
    
activitySeparator

cd $SCRIPTS_DIR
     
## Insert ATT Jobs
./insertATTJobs.sh
  
activitySeparator

cd $SCRIPTS_DIR

logDoneMsg "$ACTIVITY"
   
activitySeparator
    