##############################################################################################################
##    Script Name    : attUpgradeCustomRules.sh                                                             ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/13/2013                                                                           ##
##    Usage          : ./attUpgradeCustomRules.sh                                                           ##
##    Purpose        : Upgrade ATT CMS 1.2 custom rules to CMS 3.1.                                         ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## This script executes upgrades custom rules from ATT CMS 1.2 to CMS 3.1.
##

me="attUpgradeCustomRules.sh"

logMsg "$me invoked with args: $*"

ACTIVITY="upgrading ATT custom rules"

logBeginMsg "$ACTIVITY"

homedir=$(pwd) 

ATT_CUSTOM_RULES_JAR_NAME=att_custom_rules.jar
ATT_CUSTOM_RULES_JAR_PATH=$LIB_PATH/$ATT_CUSTOM_RULES_JAR_NAME
ATT_CUSTOM_RULE_REPLAEMENTS_PATH=$CONF_PATH/att_custom_rule_replacements_2_0
CMS_CUSTOM_RULES_JAR_FOLDER=/opt/tandbergtv/cms/plugins/rules
CMS_RULES_REPLACEMENTS_FOLDER=$CMS_CUSTOM_RULES_JAR_FOLDER/ruleReplacements
CMS_RULES_FILES_PATTERN=*.xml

cp -vf $ATT_CUSTOM_RULES_JAR_PATH $CMS_CUSTOM_RULES_JAR_FOLDER/

cp -vf $ATT_CUSTOM_RULE_REPLAEMENTS_PATH/$CMS_RULES_FILES_PATTERN $CMS_RULES_REPLACEMENTS_FOLDER/

cd $homedir

logDoneMsg "$ACTIVITY"
