##############################################################################################################
##    Script Name    : backupContentUiPlugins1_2-3_1.sh                                                     ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 07/10/2013                                                                           ##
##    Usage          : ./backupContentUiPlugins1_2-3_1.sh                                                   ##
##    Purpose        : Backup content ui plugins before upgrade                                             ##
##                         from CMS 1.2 to 3.1                                                              ##
##############################################################################################################

#!/bin/sh

##
## Backup content ui plugins before upgrade from CMS 1.2 to 3.1. 
##

ACTIVITY="backing up content ui plugins"

logBeginMsg "$ACTIVITY"

homedir="$(pwd)" 

CONTENT_PLUGINS_PATH="/opt/tandbergtv/cms/plugins/content"
PLUGIN_NAME_MSTV_UI="com.tandbergtv.metadata.mstv.ui"
PLUGIN_PATH_MSTV_UI="$CONTENT_PLUGINS_PATH/$PLUGIN_NAME_MSTV_UI"
PLUGIN_NAME_CABLELABSVOD11_UI="com.tandbergtv.metadata.cablelabsvod11.ui"
PLUGIN_PATH_CABLELABSVOD11_UI="$CONTENT_PLUGINS_PATH/$PLUGIN_NAME_CABLELABSVOD11_UI"

if [ -d "$PLUGIN_PATH_MSTV_UI" ]; then
    mv -vf "$PLUGIN_PATH_MSTV_UI" "$backupdir/"
fi

if [ -d "$PLUGIN_PATH_CABLELABSVOD11_UI" ]; then
    mv -vf "$PLUGIN_PATH_CABLELABSVOD11_UI" "$backupdir/"

    if [[ $? -ne 0 ]]; then
        exit 1
    fi
elif [ ! -d "$backupdir/$PLUGIN_NAME_CABLELABSVOD11_UI" ]; then
    logMsg "Content Plugin $PLUGIN_NAME_CABLELABSVOD11_UI not found in either $CONTENT_PLUGINS_PATH or $backupdir."
    logMsg "Aborting content ui plugins backup script..."
    exit 1
fi

cd "${homedir}"

logDoneMsg "$ACTIVITY"
