##############################################################################################################
##    Script Name    : customUpgradesFromCMS1_2.sh                                                          ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/30/2013                                                                           ##
##    Usage          : ./customUpgradesFromCMS1_2.sh                                                        ##
##    Purpose        : Upgrade tasks required only if upgrading for from CMS 1.2.                           ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## This upgrade script does upgrades which are required only if upgrading from  
##      CMS version 1.2.
## NOTE: This is currently not used.
##

logMsg "customUpgradesFromCMS1_2.sh invoked with args: $*"

ACTIVITY="performing upgrades required only when upgrading from CMS version $CMS_VERSION_1_2"

activitySeparator

logBeginMsg "$ACTIVITY"
		
## Upgrade /opt/tandbergtv/cms/conf/contentMgmt/contentMgmt.properties. 
./upgradeContentMgmtPropertiesFile.sh
	
activitySeparator

cd $SCRIPTS_DIR

## Upgrade plugins/content/com.tandbergtv.metadata/plugin.xml.
./upgradeMetadataPluginXml.sh
    
activitySeparator

cd $SCRIPTS_DIR

## Upgrade Lookup Keys
./upgradeLookupKeys.sh
    
activitySeparator

cd $SCRIPTS_DIR
     
## Upgrade permissions
./upgradePermissions.sh
    
activitySeparator

cd $SCRIPTS_DIR
     
## Upgrade cms/conf/workflow/table-config.xml
./upgradeWorkflowTableConfig.sh
    
activitySeparator

cd $SCRIPTS_DIR

## Upgrade Metadata Format for sites
./upgradeSiteMetadataFormats.sh

activitySeparator

cd $SCRIPTS_DIR

## Annotate Templates
./annotateTemplates.sh
  
activitySeparator

cd $SCRIPTS_DIR

## Upgrade Metadata
./upgradeMetadata.sh
  
activitySeparator

cd $SCRIPTS_DIR
    
logDoneMsg "$ACTIVITY"
 
activitySeparator
    