#!/bin/sh
EVLVEREQ="$1"
UPGRDREQ="$2"
DWUPGREQ="$3"
DBVER="$4" 
LATEST_DBVER="$5" 
ERROR_IN_SCRIPT=""
function cms_version_before_upg
{
PREVER="$1"
su - oracle -c "sqlplus -S /nolog<<ABC
  connect / as sysdba
  set pages 0
  set feedback off
MERGE INTO wfs.system_settings ss
   USING (SELECT 'CMS_VERSION_BEFORE_UPG' as setting_type,'${PREVER}' as setting_value, 
                 systimestamp as createdate FROM dual) d ON (d.setting_type = ss.setting_type)
   WHEN MATCHED THEN UPDATE SET ss.setting_value = d.setting_value
   WHEN NOT MATCHED THEN INSERT (ss.setting_type, ss.setting_value) values ('CMS_VERSION_BEFORE_UPG','${PREVER}');
  exit
ABC"
}
function validate_db_ojbects
{
su - oracle -c "sqlplus -S /nolog<<GGG
  connect / as sysdba
  set serveroutput on
  set echo off
  set head on
  spool /home/oracle/scripts/install/installcms/recompile_invalid_objects.log
  @?/rdbms/admin/utlprp.sql 1 
  spool off
  exit
GGG"
}
function db_inst_verify
{
if  grep -q "ORA-\|SP2-\|Warning\|Permission denied\|SQL-" "$2"
then
   echo -e "\n$1 DB install/upgrade script probably failed! "
   echo -e "    Check $2 file for any errors.\n"
   if [ "X$ERROR_IN_SCRIPT" = "X" ]; then
      ERROR_IN_SCRIPT="$1"
   else
      ERROR_IN_SCRIPT="$ERROR_IN_SCRIPT,$1"
   fi;
fi
}
function new_db_vesion
{
NEW_DB_VERSION=$(su - oracle -c "sqlplus -S /nolog<<DEF
  connect / as sysdba
  set pages 0
  set feedback off
  SELECT setting_value FROM WFS.SYSTEM_SETTINGS WHERE setting_type = 'RELEASE';
  exit
DEF"
)

if [ "${NEW_DB_VERSION}" = "${LATEST_DBVER}" ]; then 
   service oracle restart
   echo -e "\nCMS Database has been upgraded to 3.1 successfully.\n"
else
   echo -e "\nCMS database upgrade not completed, contact DBA for futher assistance.\n"
fi
}

if [ "${EVLVEREQ}" = "Y" ]; then
DB_CONS=$(su - oracle -c "sqlplus -S /nolog<<SQL1
connect / as sysdba
set pages 0
set feedback off
SELECT case count(username) when 0 then 'NO' else 'YES' end FROM v\\\$session where username = 'WFS' and status = 'ACTIVE';
exit
SQL1")
if [ "$DB_CONS" = "YES" ]; then
  echo -e "\nPlease close all the database connections and as an oracle user run the script for completing the database upgrade as follows....!"
  echo -e "\n  sh cms_direct_inplace_upgrade/cmsdb_upgrade_evolve.sh Y Y Y ${DBVER} ${LATEST_DBVER}\n"
  exit 1
else
  su - oracle -c "cd /home/oracle/scripts/install/installcms;sh copy_all_xml.sh ttv"
  if  grep -q "ORA-\|SP2-\|Permission denied\|SQL-" "/home/oracle/scripts/copy_all_xml.log"
  then
    echo "Copy all xml script got failed! Check /home/oracle/scripts/copy_all_xml.log file for any errors"
    #echo -e "\nAs an oracle user, please run the below script for completing the database upgrade as follows....!"
    #echo -e "\n  sh cms_direct_inplace_upgrade/cmsdb_upgrade_evolve.sh Y Y Y ${DBVER} ${LATEST_DBVER}\n"
    echo -e "**************************************************************************************************\n"
    exit 1
  else
    echo "COPY ALL XML SCRIPT SUCCEEDED!"
  fi
fi

fi
if [ "${UPGRDREQ}" = "Y" ]; then
su - oracle -c "cd /home/oracle/scripts/install/installcms;sh installCMS.sh"
db_inst_verify "CMS" "/home/oracle/scripts/install/installcms/cmsdbinstall.log"
sleep 15
case "${DBVER}" in
   "3.2.22" )
   cms_version_before_upg "2.5.000.29"
       ;;
   "3.3.20"  )
   cms_version_before_upg "3.000.271"
esac
su - oracle -c "cd /home/oracle/scripts/install/installrcs;sh installRCS.sh"
db_inst_verify "RCS" "/home/oracle/scripts/install/installrcs/rcsdbinstall.log"
sleep 15
su - oracle -c "cd /home/oracle/scripts/install/installepgmgr;sh installepgmgr.sh"
db_inst_verify "EPG Manager" "/home/oracle/scripts/install/installepgmgr/epgmanager.log"
sleep 15
fi
if [ "${DWUPGREQ}" = "Y" ]; then
  su - oracle -c "cd /home/oracle/scripts/install/installdw;sh installDW.sh"
  db_inst_verify "CMS DW" "/home/oracle/scripts/install/installdw/cmsdwinstall.log"
  sleep 15
fi
if [ "X$ERROR_IN_SCRIPT" = "X" ]; then
   validate_db_ojbects
   new_db_vesion  
else
   echo -e "Exiting with errors, please contact Ericsson for further assistance" 
   echo -e "*******************************************************************\n"
   exit 1
fi
exit 0
