#!/bin/sh
#******************************************************************************************#
#    Name of the Script : increment_db_version.sh                                          #
#    Purpose            : This script increments the database version for cms 2.0 to avoid #
#                         db evolve process incase of cms direct upgrade (eg. 1.2 -> 3.1)  #
#    Created by         : Suresh Neravati                                                  #
#    Created on         : 03/22/2013                                                       #
#                                                                                          #
#******************************************************************************************#

if [ -f "/home/oracle/.profile" ]; then
  source /home/oracle/.profile
elif [ -f "/home/oracle/.bash_profile" ]; then
  source /home/oracle/.bash_profile
fi

DB_VERSION=$(sqlplus -S /nolog<<SQL1
  connect / as sysdba
  set pages 0
  set feedback off
  SELECT setting_value FROM WFS.SYSTEM_SETTINGS WHERE setting_type = 'RELEASE';
  exit
SQL1
)

if [ "${DB_VERSION}" = "3.2.15" ] || [ "${DB_VERSION}" = "3.2.17" ]; then 
$ORACLE_HOME/bin/sqlplus -s /nolog<<SQEOF  
   connect / as sysdba
   set serveroutput on
   SET VERIFY OFF
   UPDATE WFS.SYSTEM_SETTINGS SET setting_value='${DB_VERSION}.1' WHERE setting_type = 'RELEASE';
   UPDATE WFS.SYSTEM_RELEASE  SET setting_value='${DB_VERSION}.1' WHERE setting_type = 'RELEASE';
   commit;
SQEOF

DB_VERSION=$(sqlplus -S /nolog<<XYZ
  connect / as sysdba
  set pages 0
  set feedback off
  SELECT setting_value FROM WFS.SYSTEM_SETTINGS WHERE setting_type = 'RELEASE';
  exit
XYZ
)
echo -e "\nDatabase version incremented to ${DB_VERSION} successfully.\n"
fi
exit
