##############################################################################################################
##    Script Name    : restoreCMS.sh                                                                        ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/09/2013                                                                           ##
##    Usage          : ./restoreCMS.sh  <backup tar file path>                                              ##
##    Purpose        : The top-level Parent script for restoring the CMS backup files                       ##
##                         from the previous version CMS app server to CMS 3.1.                             ##
##############################################################################################################

#!/bin/bash

##
## Top-level Parent script to restore backed up configuration files 
##     from the previous version CMS app server to new CMS 3.1 setup.
##

me=`basename $0`

echo "    $me invoked with args: $*"

homedir=$(pwd)

home=/home/upgrade
scriptsdir=$home/dist

$scriptsdir/activitySeparator.sh

echo "$me invoked with args: $*"

startTime=$(date +%s)
timestamp=`date --utc -d "@$(( $startTime ))" +%Y%m%d_%H%M%S`
hostname=$(hostname)
logFileName=restore-CMS.$hostname.$timestamp.log
logFilePath=$logFileName

./restore-CMSMain.sh $* 2>&1 | tee -a $logFilePath

echo "CMS App Server restore completed on host $hostname...$(date)"

$scriptsdir/activitySeparator.sh

cd $homedir

