##############################################################################################################
##    Script Name    : restore-CMS.sh                                                                       ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/23/2013                                                                           ##
##    Usage          : ./restore-CMS.sh <backup tar file path>                                              ##
##    Purpose        : The main script for restoring the CMS backup files                                   ##
##                         from the previous version CMS app server.                                        ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## Restore backed up configuration files to new 3.1 setup
##

me=`basename $0`

echo "    $me invoked with args: $*"

backupTarFilePath="$1"

shift

homedir=$(pwd) 

home=/home/upgrade
scriptsdir=$home/dist

cd $scriptsdir

./activitySeparator.sh

MESSAGE_PREFIX="    $me: "
BEGIN_MESSAGE="begin "
START_MESSAGE=""
DONE_MESSAGE="done "

ACTIVITY="restoring backed up CMS files"
ACTIVITY_MSG="$MESSAGE_PREFIX$BEGIN_MESSAGE$ACTIVITY...$(date)"

echo "$ACTIVITY_MSG"

## First initialize the common environment variables and functions.

SUB_ACTIVITY="initializing environment variables"
SUB_ACTIVITY_MSG="$MESSAGE_PREFIX$BEGIN_MESSAGE$SUB_ACTIVITY...$(date)"

echo "$SUB_ACTIVITY_MSG"

. ./initEnvCommon.sh

logDoneMsg "$SUB_ACTIVITY"

activitySeparator

SUB_ACTIVITY="getting upgrade path"

logBeginMsg "$SUB_ACTIVITY"

## get upgrade_path_name

. ./getUpgradePath.sh

logDoneMsg "$SUB_ACTIVITY"

activitySeparator

EXCLUDES_FILE_PATH_PREFIX=$CONF_PATH/restore/excludes
EXCLUDES_FILE_NAME_SEPARATOR=-
EXCLUDES_FILE_PATH_SUFFIX=

excludes_file_path=$EXCLUDES_FILE_PATH_PREFIX$EXCLUDES_FILE_NAME_SEPARATOR$upgrade_path_name$EXCLUDES_FILE_PATH_SUFFIX

SUB_ACTIVITY="extracting backup tar with excludes file path: $excludes_file_path" 

logBeginMsg "$SUB_ACTIVITY"

cd $homedir

tar xvf $backupTarFilePath --exclude-from=$excludes_file_path

logDoneMsg "$SUB_ACTIVITY"

cd $scriptsdir

activitySeparator

logDoneMsg "$ACTIVITY"

activitySeparator

cd $homedir
