#!/bin/sh
IFS=$'\12'
filename=/opt/tandbergtv/cms/conf/contentMgmt/FieldAliasMapping.dat
if [ ! -f $filename ]; then
	filename=/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/resources/FieldAliasMapping.dat
fi

outputFileName=FieldAliasMapping.dat

echo "processing $filename"
touch $outputFileName
for i in $(cat $filename);
do
        echo $i > tmp.txt
        sed -e 's/=/,/' tmp.txt >> $outputFileName
done

mv $outputFileName /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/resources/.
chown nobody:nobody /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/resources/$outputFileName
rm -f tmp.txt

mv /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/resources/$outputFileName /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/resources/temp_fam.dat
sed -e 's://Fields/Languages/Language/@value:/Fields/Languages/Language/@value:' /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/resources/temp_fam.dat >> /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/resources/$outputFileName
rm -f /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/resources/temp_fam.dat


if grep /Fields/Rating/MSORatings/MSORating $filename >> /dev/null
then
	echo "FieldAliasMapping.dat is already upgraded for MSORating"
	exit;
fi

mv /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/resources/$outputFileName /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/resources/temp_fam.dat
sed -e 's:/Fields/Rating/MSORating:/Fields/Rating/MSORatings/MSORating:' /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/resources/temp_fam.dat >> /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/resources/$outputFileName
rm -f /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/resources/temp_fam.dat
