#!/bin/sh

dir=/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/
file=$dir/plugin.xml
tmpFile=$dir/tmp.txt

if grep com.tandbergtv.metadata.provider.series $file >> /dev/null
 	then
		echo "plugin.xml is already upgraded";
		exit;
fi

message='<!-- Extra data for SERIES root --> \n 
    <extension id="com.tandbergtv.metadata.provider.series" plugin-id="com.tandbergtv.metadata" point-id="series_provider"> \n \t
       <parameter id="definitionResource" value="series_definition.xml" /> \n \t
       <parameter id="tableConfigurationResource" value="tableconfiguration.xml" />\n \t
       <parameter id="resourcebundle" value="ecmf" />\n 
    </extension>\n 
</plugin-fragment>'

# take backup of old file
cp $file $dir/plugin.xml.beforeUpgrade

# Delete the line
grep -v "</plugin-fragment>" $file > $tmpFile

# append the line as a part of upgrade
echo -e $message  >> $tmpFile

#rename the file
mv -f $tmpFile $file



