#!/bin/sh

dir=/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources
file=$dir/tableconfiguration.xml
tmpFile=$dir/tmp_tableconfiguration.xml

if grep seriesMetadataSearchColumns $file >> /dev/null
		then
		echo "table-configuration.xml is already upgraded";
		exit;
fi

message='<!-- Extra data for SERIES search columns --> \n 
     <table-extension id="seriesMetadataSearchColumns"> \n \t
		<column> \n \t
			<name>table.series.assetname</name> \n \t
			<title-section>SERIES</title-section> \n \t
			<metadata-name>/Fields/AssetName</metadata-name> \n \t
			<isSelectedByDefault>true</isSelectedByDefault> \n \t
			<width /> \n \t
		</column> \n \t
		<column> \n \t
			<name>table.brief.title</name> \n \t
			<title-section>SERIES/TITLE</title-section> \n \t
			<metadata-name>/Fields/Title/ShortTitle/Value</metadata-name> \n \t
			<isSelectedByDefault>true</isSelectedByDefault> \n \t
			<width /> \n \t
		</column> \n \t
		<column> \n \t
			<name>table.asset.id</name> \n \t
			<title-section>SERIES</title-section> \n \t
			<metadata-name>/Fields/ExternalSeriesID/Id</metadata-name> \n \t
			<isSelectedByDefault>true</isSelectedByDefault> \n \t
			<width /> \n \t
		</column> \n \t
		<column> \n \t
			<name>table.series.network</name> \n \t
			<title-section>SERIES/TITLE</title-section> \n \t
			<metadata-name>/Fields/TvId/Network</metadata-name> \n \t
			<isSelectedByDefault>true</isSelectedByDefault> \n \t
			<width /> \n \t
		</column> \n \t
		<column> \n \t
			<name>table.series.description</name> \n \t
			<title-section>SERIES</title-section> \n \t
			<metadata-name>/Fields/Description/Text</metadata-name> \n \t
			<isSelectedByDefault>true</isSelectedByDefault> \n \t
			<width /> \n \t
		</column> \n \t		
		<!-- 		
		<column> \n \t
			<name>table.file.encodeFormat</name> \n \t
			<title-section>SERIES/POSTER/FILE</title-section> \n \t
			<metadata-name>/Fields[Locator/Description/Text="ORIGINAL"]/CustomFields/CustomField[@name=EncodeFormat]/@value</metadata-name> \n \t
			<width />	\n \t		
		</column> \n \t
		<column> \n \t
			<name>table.file.Checksum</name> \n \t
			<title-section>SERIES/POSTER/FILE</title-section> \n \t
			<metadata-name>/Fields[Locator/Description/Text="ORIGINAL"]/Content/Checksum</metadata-name> \n \t
			<width /> \n \t
		</column> \n \t
		 --> \n \t
	</table-extension> \n \t
	</tableconfiguration>'

# take backup of old file
cp $file $dir/tableconfiguration.xml.beforeUpgrade

# Delete the line
grep -v "</tableconfiguration>" $file > $tmpFile

# append the line as a part of upgrade
echo -e $message  >> $tmpFile

#rename the file
mv -f $tmpFile $file

