#!/bin/bash
START=$(date +%s)
TIMESTAMP=`date --utc -d "@$(( $START ))" +%Y%m%d_%H%M%S`

## Edit The Commands if nessary 
CONARY_UNPIN_KERNAL="conary unpin kernel-firmware kernel-headers"
CONARY_UPDATE_RPATH="conary update conary=/rhel.rpath.com@rpath:rhel-6/2.4.4-1-1 --from-file /root/group-cmsdb-appliance_absolute_3.0.ccs --disconnected"
CONARY_SYNC_DATABASE="conary migrate group-cmsdb-appliance=cmsdb.etv@satv:cmsdb-2.5/2.5-16-1 --info"
CONARY_UPDATE_APP="conary migrate group-cmsdb-appliance=cmsdb.etv@satv:cmsdb-3.0 --from-file /root/group-cmsdb-appliance_absolute_3.0.ccs --disconnected"

(
cp -f /home/upgrade/chgdbarchivemode.sh /home/oracle/scripts/dbca/chgdbarchivemode.sh
if [ $? -ne 0 ]; then
  echo "Error in copying the chgdbarchivemode.sh file" 
  exit 1
else
    chmod 755 /home/oracle/scripts/dbca/chgdbarchivemode.sh
    chown oracle:oinstall /home/oracle/scripts/dbca/chgdbarchivemode.sh
fi
mkdir /home/upgrade/prev_conf_files
if [ $? -eq 0 ]; then
    ## Get system info ##
    echo "Starting Appliance Update @ "$(date '+%Y-%m-%d %H:%M:%S')
    echo "System Name.................." $HOSTNAME
    echo "System IP...................." `cat /etc/hosts | grep $HOSTNAME | awk '{print $1}'`
    echo "Appliance Verions............" `conary q | grep appliance | awk -F= '{print $2}'`
    echo "Conary Version..............." `conary q --version`                            

    #Create Backups
    su - oracle -c "/home/oracle/scripts/dbca/chgdbarchivemode.sh ttv"
    su - oracle -c "/opt/oracle/backup/scripts/rman_backup.ksh DISK"
    
    ## unset Path
    unset PATH
    PATH=/opt/oracle/product/11.2.0/db_1/bin:/opt/oracle/product/11.2.0/db_1/OPatch:/usr/local/bin:/bin:/usr/bin:/usr/local/sbin:/usr/sbin:/sbin:
    export PATH

    ## Stop Services
    service oracle stop
    
    #Backing up oracle
    echo "backing up files in case of rollback"
    cd /opt
    tar -czvpf /home/upgrade/oracle.tar.gz oracle
    cd /home/upgrade

    cp /etc/sysctl.conf          /home/upgrade/prev_conf_files/sysctl.conf.bak
    cp /etc/security/limits.conf /home/upgrade/prev_conf_files/limits.conf.bak
    cp /etc/oratab               /home/upgrade/prev_conf_files/oratab.bak
    cp /etc/init.d/oracle        /home/upgrade/prev_conf_files/oracle_service 
    cp /etc/oraInst.loc          /home/upgrade/prev_conf_files/oraInst.loc.bak

    cp /home/oracle/.bash_profile                               /home/upgrade/prev_conf_files/oracle_profile.bak
    cp /opt/oracle/product/11.2.0/db_1/sqlplus/admin/glogin.sql /home/upgrade/prev_conf_files/glogin.sql.bak
    cp /opt/oracle/backup/scripts/rman_backup.ksh               /home/upgrade/prev_conf_files/rman_backup.ksh
    cp /opt/oracle/backup/scripts/rman_backup_arch.ksh          /home/upgrade/prev_conf_files/rman_backup_arch.ksh

    su - oracle -c "crontab -l > /home/oracle/oracle_cron.bak"
    cp /home/oracle/oracle_cron.bak /home/upgrade/prev_conf_files/oracle_cron.bak

    cp /opt/oracle/product/11.2.0/db_1/assistants/dbca/templates/ttv.ctl /home/upgrade/prev_conf_files/ttv.ctl
    cp /opt/oracle/product/11.2.0/db_1/assistants/dbca/templates/ttv.dfb /home/upgrade/prev_conf_files/ttv.dfb
    cp /opt/oracle/product/11.2.0/db_1/assistants/dbca/templates/ttv.dbc /home/upgrade/prev_conf_files/ttv.dbc
    crontab -l > /home/upgrade/prev_conf_files/root_cron.bak

    echo "Unpin Kernal"
    echo "RUNTIME COMMAND: $CONARY_UNPIN_KERNAL"
    $CONARY_UNPIN_KERNAL
    sleep 2
    echo "Updating Conary Version"
    echo "RUNTIME COMMAND: $CONARY_UPDATE_RPATH"
    $CONARY_UPDATE_RPATH
    sleep 2
    echo "Syncing the Conary Database"
    echo "RUNTIME COMMAND: $CONARY_SYNC_DATABASE"
    $CONARY_SYNC_DATABASE
    sleep 2
    echo "Pinning Post Installed RPMs"
    echo `conary q --full-versions | grep PHANTOM` > rpms2pin.log
    for line in $(cat rpms2pin.log)
    do
        echo "Pinning $line"
        conary pin $line
    done
    sleep 2
    echo "Updating the Appliance"
    echo "RUNTIME COMMAND: $CONARY_UPDATE_APP"
    $CONARY_UPDATE_APP
    sleep 2
    echo "Updating the Conary Install Label"
    sed -i 's\2.5\3.0\g'  /etc/conaryrc

    #echo "127.0.0.1         `hostname`" >> /etc/hosts

    mkdir -p /opt/oracle/product/11.2.0/db_1/dbs/dbs/arch
    chown oracle:oinstall /opt/oracle/product/11.2.0/db_1/dbs/arch
    mkdir -p /opt/oracle/backup/scripts
    chown -R oracle:oinstall /opt/oracle/
    mkdir -p /opt/oracle/oradata
    chown -R oracle:oinstall /opt/oracle/oradata
    mkdir -p /opt/oracle/admin
    chown -R oracle:oinstall /opt/oracle/admin

    cp -f /home/upgrade/prev_conf_files/oratab.bak /etc/oratab
    TOTAL_MEMORY=$(echo "scale=0;$(cat /proc/meminfo | grep MemTotal | awk '{print $2}' ) /1024"|bc)
    ORA_MEMORY=$(printf %.0f $(echo "scale=0;${TOTAL_MEMORY}*2/3"|bc))
    sed -i "/vm.nr_hugepages =[.]*/d" /etc/sysctl.conf
    grep -q ^vm.nr_hugepages /etc/sysctl.conf
    if [ $? -ne 0 ]; then
      if [ ${ORA_MEMORY} -gt 42000 ]; then
        echo "vm.nr_hugepages = 21510" >> /etc/sysctl.conf
      elif [ ${ORA_MEMORY} -gt 15360 ]; then
        echo "vm.nr_hugepages = 7170" >> /etc/sysctl.conf
      else
        echo "#vm.nr_hugepages = 7170" >> /etc/sysctl.conf
      fi
    fi
    sysctl -p
    cp -f /home/oracle/scripts/dbca/oracle_profile /home/oracle/.bash_profile
    cp -f /home/oracle/scripts/dbca/glogin.sql /opt/oracle/product/11.2.0/db_1/sqlplus/admin/glogin.sql
    #cp -f /home/oracle/scripts/dbca/oraInst.loc /etc/oraInst.loc
    cp -f /home/oracle/scripts/dbca/rman_backup.ksh /opt/oracle/backup/scripts/rman_backup.ksh 
    cp -f /home/oracle/scripts/dbca/rman_backup_arch.ksh /opt/oracle/backup/scripts/rman_backup_arch.ksh
    #chown root:root /etc/oraInst.loc
    chown oracle:oinstall /opt/oracle/product/11.2.0/db_1/sqlplus/admin/glogin.sql
    chown oracle:oinstall /opt/oracle/backup/scripts/rman_backup*.ksh
    chown oracle:oinstall /home/oracle/.bash_profile
    chmod 755 /opt/oracle/backup/scripts/rman_backup*.ksh
  
    cp -f /home/oracle/scripts/dbca/ttv.ctl /opt/oracle/product/11.2.0/db_1/assistants/dbca/templates/ttv.ctl
    cp -f /home/oracle/scripts/dbca/ttv.dfb /opt/oracle/product/11.2.0/db_1/assistants/dbca/templates/ttv.dfb
    cp -f /home/oracle/scripts/dbca/ttv.dbc /opt/oracle/product/11.2.0/db_1/assistants/dbca/templates/ttv.dbc
    cp -f /home/oracle/scripts/dbca/oracle_service /etc/init.d/oracle
    chown oracle:oinstall /opt/oracle/product/11.2.0/db_1/assistants/dbca/templates/ttv.*
    chown root:root /etc/init.d/oracle
    chmod 755 /etc/init.d/oracle
    ln -s /usr/bin /usr/local/bin

    ## Start Oracle Service
    su - oracle -c "cd /home/oracle/scripts/db_restore; sh db_post_upgrade.sh"
    cd /home/oracle/scripts/dbca
    sh create_modify_instance.sh ttv 48G

    #Identify conflict files
    echo "The following files contained conflicts and were not updated properly"
    echo "Begin List"
    find / | grep "\.conflict"
    echo "End List"
    echo ""
    echo "The following files contained new files provided by the update, but were not replaced"
    echo "Begin List"
    find / | grep "\.rpmnew"
    echo "End List"
    echo "Upgrade completed."
else
  echo "This machine is already upgraded."
  exit 1
fi    
    
) 2>&1 | tee /home/upgrade/$TIMESTAMP.update.log
