##############################################################################################################
##    Script Name    : upgradeCMS.sh                                                                        ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/09/2013                                                                           ##
##    Usage          : ./upgradeCMS.sh                                                                      ##
##    Purpose        : The top-level Parent script for upgrading CMS App Server to version 3.1.             ##
##                                                                                                          ##
##############################################################################################################

#!/bin/bash

me="upgradeCMS.sh"

homedir=$(pwd)

home=/home/upgrade
scriptsdir=$home/dist

cd $scriptsdir

./activitySeparator.sh

echo "$me invoked with args: $*"

startTime=$(date +%s)
timestamp=`date --utc -d "@$(( $startTime ))" +%Y%m%d_%H%M%S`
hostname=$(hostname)
logFileName=upgradeCMS.$hostname.$timestamp.log
logFilePath=$home/$logFileName


./upgradeCMSMain.sh $* 2>&1 | tee -a $logFilePath

echo "CMS App Server upgrade completed on host $hostname...$(date)"

./activitySeparator.sh

cd $homedir

