##############################################################################################################
##    Script Name    : upgradeCMSMain.sh                                                                    ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/13/2013                                                                           ##
##    Usage          : ./upgradeCMSMain.sh                                                                  ##
##    Purpose        : Main Parent script for upgrading CMS App Server to version 3.1.                      ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## This upgrade script determines the upgrade path in progress,  
##       and invokes appropriate app server upgrade script for that.
##

me="upgradeCMSMain.sh"

./activitySeparator.sh

echo "$me invoked with args: $*"

MESSAGE_PREFIX="    $me: "
BEGIN_MESSAGE="begin "
START_MESSAGE=""
DONE_MESSAGE="done "

MAIN_ACTIVITY="cms upgrade main script"
MAIN_ACTIVITY_MSG="$MESSAGE_PREFIX$BEGIN_MESSAGE$MAIN_ACTIVITY...$(date)"

echo "$MAIN_ACTIVITY_MSG"

## First initialize the common environment variables and functions.

MAIN_SUB_ACTIVITY="initializing environment variables"
MAIN_SUB_ACTIVITY_MSG="$MESSAGE_PREFIX$MAIN_SUB_ACTIVITY...$(date)"

echo "$MAIN_SUB_ACTIVITY_MSG"

. ./initEnvCommon.sh

logDoneMsg "$MAIN_SUB_ACTIVITY"

activitySeparator

MAIN_SUB_ACTIVITY="getting upgrade path"

logBeginMsg "$MAIN_SUB_ACTIVITY"

. ./getUpgradePath.sh

logDoneMsg "$MAIN_SUB_ACTIVITY"

activitySeparator

MAIN_SUB_ACTIVITY="running common pre-upgrade tasks" 

logBeginMsg "$MAIN_SUB_ACTIVITY"

## First the tasks which are common to all upgrade paths. 
. ./commonPreUpgradeTasks.sh

logDoneMsg "$MAIN_SUB_ACTIVITY"

activitySeparator

MAIN_SUB_ACTIVITY="running upgrade script: $cms_upgrade_script_name $*" 

logBeginMsg "$MAIN_SUB_ACTIVITY"

runUpgradeScript $cms_upgrade_script_name $*

logDoneMsg "$MAIN_SUB_ACTIVITY"

activitySeparator

MAIN_SUB_ACTIVITY="running common post-upgrade tasks" 

logBeginMsg "$MAIN_SUB_ACTIVITY"

## Finally the post-upgrade tasks which are common to all upgrade paths. 
./commonPostUpgradeTasks.sh

logDoneMsg "$MAIN_SUB_ACTIVITY"

activitySeparator

logDoneMsg "$MAIN_ACTIVITY"

activitySeparator


   