##############################################################################################################
##    Script Name    : upgradeCMSMain1_5-3_1.sh                                                             ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/13/2013                                                                           ##
##    Usage          : ./upgradeCMSMain1_5-3_1.sh                                                           ##
##    Purpose        : Main Parent script for upgrading CMS App Server from v 1.5 to v 3.1.                 ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## This upgrade script assumes that the backup configuration files from previous version (e.g., 1.2) have
##      been restored to the current CMS setup (e.g., 3.1).
##

logMsg "upgradeCMSMain1_5-3_1.sh invoked with args: $*"

ACTIVITY="upgrading CMS from version $upgrade_from_cms_version to $upgrade_to_cms_version"

logBeginMsg "$ACTIVITY"

activitySeparator

cd $SCRIPTS_DIR

## Upgrade Property Files
./upgradePropertyFiles.sh

activitySeparator

cd $SCRIPTS_DIR

## Upgrade cms/conf/workflow/table-config.xml
./upgradeWorkflowTableConfig.sh

activitySeparator

cd $SCRIPTS_DIR

## Upgrade /opt/tandbergtv/watchpoint/tomcat/webapps/watchfolder/WEB-INF/classes/watchfolder.properties
## Commenting out because this script does not work properly for 1.2->3.1.
##./upgradeWatchfolderProperties.sh

activitySeparator

cd $SCRIPTS_DIR

## Upgrade Lookup Keys
./upgradeLookupKeys.sh

activitySeparator

cd $SCRIPTS_DIR

## Upgrade report-config.xml
./upgradeReportConfig.sh

activitySeparator

cd $SCRIPTS_DIR

## Upgrade Standard Fields
CMS_VERSION_15_SPEC_FILE_PATH="/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.cablelabsvod11.ui/resources/definition.xml"
BACKUP_CMS_VERSION_15_SPEC_FILE_PATH="$backupdir/com.tandbergtv.metadata.cablelabsvod11.ui/resources/definition.xml"
specFilePath="$BACKUP_CMS_VERSION_15_SPEC_FILE_PATH"

if [ -f "$CMS_VERSION_15_SPEC_FILE_PATH" ]; then
    specFilePath="$CMS_VERSION_15_SPEC_FILE_PATH"
fi

./upgradeStandardFields.sh "$specFilePath"

activitySeparator

cd $SCRIPTS_DIR

## Upgrade permissions
./upgradePermissions.sh

activitySeparator

cd $SCRIPTS_DIR

## Upgrade Metadata Format for sites
./upgradeSiteMetadataFormats.sh

activitySeparator

cd $SCRIPTS_DIR

## Upgrade Sites
./upgradeSites.sh

activitySeparator

cd $SCRIPTS_DIR

## Annotate Templates
./annotateTemplates.sh

activitySeparator

cd $SCRIPTS_DIR

## Upgrade spec plugins
./upgradeSpecPlugins.sh

activitySeparator

## Upgrade Autofill Providers
./upgradeAutofillProviders.sh

activitySeparator

cd $SCRIPTS_DIR

## Upgrade Content Class and definition.xml ##
## Also upgrades Custom Fields ##
./upgradeContentClass.sh

activitySeparator

cd $SCRIPTS_DIR

## Upgrade Metadata
./upgradeMetadata.sh

activitySeparator

cd $SCRIPTS_DIR

## Load categories ##
./loadCategories.sh

activitySeparator

cd $SCRIPTS_DIR

logDoneMsg "$ACTIVITY"

activitySeparator