##############################################################################################################
##    Script Name    : upgradeCMSMain2_5-3_1.sh                                                             ##
##    Author         : Bak Ng                                                                               ##
##    Created on     : 05/21/2013                                                                           ##
##    Usage          : ./upgradeCMSMain2_5-3_1.sh                                                           ##
##    Purpose        : Main Parent script for upgrading CMS App Server from v 2.5 to v 3.1.                 ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## This upgrade script assumes that the backup configuration files from previous version (e.g., 2.5) have 
## been restored to the current CMS setup (e.g., 3.1).
##

logMsg "upgradeCMSMain2_5-3_1.sh invoked with args: $*"

ACTIVITY="upgrading CMS from version $upgrade_from_cms_version to $upgrade_to_cms_version"

logBeginMsg "$ACTIVITY"

activitySeparator

cd $SCRIPTS_DIR

## Upgrade /opt/tandbergtv/watchpoint/tomcat/webapps/watchfolder/WEB-INF/classes/watchfolder.properties
## Commenting out because this script does not work properly for 1.2->3.1.
##./upgradeWatchfolderProperties.sh
    
activitySeparator

cd $SCRIPTS_DIR

## Upgrade Custom Fields, Content Class, and definition.xml
./upgradeCustomFields.sh

activitySeparator
    
cd $SCRIPTS_DIR

## Upgrade report-config.xml
./upgradeReportConfig.sh
    
activitySeparator

cd $SCRIPTS_DIR
    
logDoneMsg "$ACTIVITY"
 
activitySeparator
