##############################################################################################################
##    Script Name    : upgradeContentClassCMS1_2-3_1.sh                                                     ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/30/2013                                                                           ##
##    Usage          : ./upgradeContentClassCMS1_2-3_1.sh                                                   ##
##    Purpose        : Script for upgrading content class, definition.xml and custom fields                 ##
##                         from CMS 1.2 to 3.1                                                              ##
##############################################################################################################

#!/bin/bash

##
## Upgrade content class, definition.xml and custom fields from CMS 1.2 to 3.1. 
## Note: Version 1.2 didn't have a content class
##

ACTIVITY="upgrading content class, definition.xml and custom fields from CMS 1.2 to 3.1"

logBeginMsg "$ACTIVITY"

## Backup old ui plugins

./backupContentUiPlugins1_2-3_1.sh

if [[ $? -ne 0 ]]; then
    logMsg "Failure in content ui plugins backup script..."
    logMsg "Aborting content class upgrade..."
    exit 1
fi

## Convert definition.xml and properties
OLD_PATH=$backupdir/com.tandbergtv.metadata.cablelabsvod11.ui/resources
NEW_PATH=$upgradedir/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources
mkdir -p $NEW_PATH

cd upgrade25/dist/contentmgmt
./scripts/convert_12.sh $OLD_PATH definition.xml cablelabsvod11.properties $NEW_PATH
cd ../../..

## Replace old files
cp $NEW_PATH/* /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/

## Convert custom fields
cd upgrade30/dist/customfields
./scripts/custom_fields_upgrade.sh
cd ../../..

logDoneMsg "$ACTIVITY"
