##############################################################################################################
##    Script Name    : upgradeContentClassCMS1_5-3_1.sh                                                     ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/30/2013                                                                           ##
##    Usage          : ./upgradeContentClassCMS1_5-3_1.sh                                                   ##
##    Purpose        : Script for upgrading content class, definition.xml and custom fields                 ##
##                         from CMS 1.5 to 3.1.                                                             ##
##############################################################################################################

#!/bin/sh

##
## Upgrade content class, definition.xml and custom fields from CMS 1.5 to 3.1. 
##

ACTIVITY="upgrading content class, definition.xml and custom fields from CMS 1.5 to 3.1"

logBeginMsg "${ACTIVITY}"

## Backup old ui plugins

./backupContentUiPlugins1_2-3_1.sh

if [[ $? -ne 0 ]]; then
    logMsg "Failure in content ui plugins backup script..."
    logMsg "Aborting content class upgrade..."
    exit 1
fi

upgrade20dir=/home/upgrade/2_0

## Convert definition.xml and properties
OLD_PATH=$backupdir/com.tandbergtv.metadata.cablelabsvod11.ui/resources
NEW_PATH=$upgrade20dir/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources
mkdir -p $NEW_PATH

cd upgrade20/dist
./cc.sh $OLD_PATH/definition.xml $OLD_PATH/cablelabsvod11.properties $NEW_PATH
cd ../..

## Replace old files
cp $NEW_PATH/definition.xml /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/
cp $NEW_PATH/cablelabsvod11.properties /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/ecmf.properties
cp $NEW_PATH/cfDataTypeMapping.dat /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/

./upgradeContentClassCMS2_0-3_1.sh

logDoneMsg "${ACTIVITY}"