##############################################################################################################
##    Script Name    : upgradeContentClassCMS2_0-3_1.sh                                                     ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/30/2013                                                                           ##
##    Usage          : ./upgradeContentClassCMS2_0-3_1.sh                                                   ##
##    Purpose        : Script for upgrading content class, definition.xml and custom fields                 ##
##                         from CMS 2.0 to 3.1.                                                             ##
##############################################################################################################

#!/bin/sh

##
## Upgrade content class, definition.xml and custom fields from CMS 2.0 to 3.1. 
##

ACTIVITY="upgrading content class, definition.xml and custom fields from CMS 2.0 to 3.1"

logBeginMsg "${ACTIVITY}"

##
## Update current timestamp string.
##
genCurrentTimestampStr
currTimestamp="${currentTimeStampStr}"

ECMF_UI_PLUGIN_NAME="com.tandbergtv.metadata.ecmf.ui"
CMS_CONTENT_PLUGINS_PATH="/opt/tandbergtv/cms/plugins/content"
ECMF_UI_PLUGIN_PATH="${CMS_CONTENT_PLUGINS_PATH}/${ECMF_UI_PLUGIN_NAME}"
RESOURCES_DIR_NAME="resources"
ECMF_UI_PLUGIN_RESOURCES_PATH="${ECMF_UI_PLUGIN_PATH}/${RESOURCES_DIR_NAME}"
SPEC_FILE_NAME="definition.xml"
SPEC_FILE_PATH="${ECMF_UI_PLUGIN_RESOURCES_PATH}/${SPEC_FILE_NAME}"
SERIES_SPEC_FILE_NAME="series_definition.xml"
SERIES_SPEC_FILE_PATH="${ECMF_UI_PLUGIN_RESOURCES_PATH}/${SERIES_SPEC_FILE_NAME}"
SPEC_PROPS_FILE_NAME="ecmf.properties"
SPEC_PROPS_FILE_PATH="${ECMF_UI_PLUGIN_RESOURCES_PATH}/${SPEC_PROPS_FILE_NAME}"

## Backup old ECMF ui plugin

SUB_ACTIVITY="backing up 2.0 ecmf ui plugin"

logBeginMsg "${SUB_ACTIVITY}"

cp -Rvf "${ECMF_UI_PLUGIN_PATH}" "${backupdir}/"

logDoneMsg "${SUB_ACTIVITY}"

## ECMF UI plugin upgrade is done in two steps:
##    1) 2.0 to 2.5
##    2) 2.5 to 3.1

## Initialize 2.5 upgraded plugin with a copy of the 2.0 backup plugin.

backupEcmfUiPluginPath="${backupdir}/${ECMF_UI_PLUGIN_NAME}"
ECMF_UI_PLUGIN_UPGRADED_TO_25_NAME="${ECMF_UI_PLUGIN_NAME}_25"
ECMF_UI_PLUGIN_UPGRADED_TO_31_NAME="${ECMF_UI_PLUGIN_NAME}_31"
ECMF_UI_PLUGIN_UPGRADED_TO_31_AFTER_AUTOFILL_NAME="${ECMF_UI_PLUGIN_NAME}_31_after_autofill"
upgradedEcmfUiPluginTo25Path="${upgradedir}/${ECMF_UI_PLUGIN_UPGRADED_TO_25_NAME}"
upgradedEcmfUiPluginTo31Path="${upgradedir}/${ECMF_UI_PLUGIN_UPGRADED_TO_31_NAME}"
upgradedEcmfUiPluginTo31AfterAutofillPath="${upgradedir}/${ECMF_UI_PLUGIN_UPGRADED_TO_31_AFTER_AUTOFILL_NAME}"

homedir="$(pwd)" 

SUB_ACTIVITY="copying 2.0 ecmf ui plugin ${backupEcmfUiPluginPath} to ${upgradedEcmfUiPluginTo25Path}"

logBeginMsg "${SUB_ACTIVITY}"

if [ -d "${upgradedEcmfUiPluginTo25Path}" ]; then
    backupUpgradedEcmfUiPluginTo25Path="${upgradedEcmfUiPluginTo25Path}_backup_${currTimestamp}"
    mv -vf "${upgradedEcmfUiPluginTo25Path}" "${backupUpgradedEcmfUiPluginTo25Path}"
fi

cp -Rvf "${backupEcmfUiPluginPath}" "${upgradedEcmfUiPluginTo25Path}"

logDoneMsg "${SUB_ACTIVITY}"

## Upgrade definition.xml and ecmf.properties from 2.0 to 2.5.

inputDir="${backupEcmfUiPluginPath}/${RESOURCES_DIR_NAME}"
outputDir="${upgradedEcmfUiPluginTo25Path}/${RESOURCES_DIR_NAME}"
 
SUB_ACTIVITY="converting definition.xml and ecmf.properties from 2.0 to 2.5 with inputDir = ${inputDir} and outputDir = ${outputDir}"

logBeginMsg "${SUB_ACTIVITY}"

cd upgrade25/dist/contentmgmt

./scripts/convert_spec_25.sh "${inputDir}" "${outputDir}"

logDoneMsg "${SUB_ACTIVITY}"

## Upgrade content class from 2.0 to 2.5.

inputSpecFilePath="${inputDir}/${SPEC_FILE_NAME}"

SUB_ACTIVITY="converting content class from 2.0 to 2.5 with inputSpecFilePath = ${inputSpecFilePath}"

logBeginMsg "${SUB_ACTIVITY}"

./scripts/convert_cc_db.sh "${inputSpecFilePath}"

logDoneMsg "${SUB_ACTIVITY}"

## Upgrade definition.xml and ecmf.properties from 2.5 to 3.1.

SUB_ACTIVITY="converting definition.xml and ecmf.properties from 2.5 to 3.1"

logBeginMsg "${SUB_ACTIVITY}"

SUB_SUB_ACTIVITY="copying the ecmf ui plugin upgraded to version 2.5 at ${upgradedEcmfUiPluginTo25Path} to ${upgradedEcmfUiPluginTo31Path}"

logBeginMsg "${SUB_SUB_ACTIVITY}"

if [ -d "${upgradedEcmfUiPluginTo31Path}" ]; then
    backupUpgradedEcmfUiPluginTo31Path="${upgradedEcmfUiPluginTo31Path}_backup_${currTimestamp}"
    mv -vf "${upgradedEcmfUiPluginTo31Path}" "${backupUpgradedEcmfUiPluginTo31Path}"
fi

cp -Rvf "${upgradedEcmfUiPluginTo25Path}" "${upgradedEcmfUiPluginTo31Path}"

logDoneMsg "${SUB_SUB_ACTIVITY}"

SUB_SUB_ACTIVITY="running convert_spec.sh for ecmf ui plugin upgraded to version 2.5 at ${upgradedEcmfUiPluginTo25Path} to ${upgradedEcmfUiPluginTo31Path}"

logBeginMsg "${SUB_SUB_ACTIVITY}"

inputDir2_5_3_1="${upgradedEcmfUiPluginTo25Path}/${RESOURCES_DIR_NAME}"
outputDir2_5_3_1="${upgradedEcmfUiPluginTo31Path}/${RESOURCES_DIR_NAME}"

./scripts/convert_spec.sh "${inputDir2_5_3_1}" "${outputDir2_5_3_1}"

logDoneMsg "${SUB_SUB_ACTIVITY}"

logDoneMsg "${SUB_ACTIVITY}"

# Custom fields upgrade script picks up the definition.xml and ecmf.properties defined in config.properties in that project.

SUB_ACTIVITY="updating config.properties for upgrading custom fields from 2.5 to 3.1"

logBeginMsg "${SUB_ACTIVITY}"

cd "${homedir}"

cd upgrade30/dist/customfields

./scripts/cf_upgrade_config.sh "${inputDir2_5_3_1}/${SPEC_FILE_NAME}" "${inputDir2_5_3_1}/${SERIES_SPEC_FILE_NAME}" "${inputDir2_5_3_1}/${SPEC_PROPS_FILE_NAME}"

logDoneMsg "${SUB_ACTIVITY}"

SUB_ACTIVITY="upgrading custom fields from 2.5 to 3.1"

logBeginMsg "${SUB_ACTIVITY}"

./scripts/custom_fields_upgrade.sh

logDoneMsg "${SUB_ACTIVITY}"

SUB_ACTIVITY="upgrading content class partners from 2.5 to 3.1"

logBeginMsg "${SUB_ACTIVITY}"

./scripts/content_class_partner_upgrade.sh

logDoneMsg "${SUB_ACTIVITY}"

SUB_ACTIVITY="moving autofill providers to 3.1 DB"

logBeginMsg "${SUB_ACTIVITY}"

inputDir3_1_3_1_After_Autofill="${upgradedEcmfUiPluginTo31Path}/${RESOURCES_DIR_NAME}"
outputDir3_1_3_1_After_Autofill="${upgradedEcmfUiPluginTo31AfterAutofillPath}/${RESOURCES_DIR_NAME}"

cd "${homedir}"

cd upgrade25/dist/contentmgmt

./scripts/convert_autofill_prov.sh "${inputDir3_1_3_1_After_Autofill}" "${outputDir3_1_3_1_After_Autofill}" "${SPEC_FILE_NAME}" "${SPEC_PROPS_FILE_NAME}"

logDoneMsg "${SUB_ACTIVITY}"

SUB_ACTIVITY="copying upgraded ecmf ui plugin resources to CMS ecmf ui plugin resources folder: ${ECMF_UI_PLUGIN_RESOURCES_PATH}"

logBeginMsg "${SUB_ACTIVITY}"

cp -Rvf ${upgradedEcmfUiPluginTo31AfterAutofillPath}/${RESOURCES_DIR_NAME}/* "${ECMF_UI_PLUGIN_RESOURCES_PATH}/"

logDoneMsg "${SUB_SUB_ACTIVITY}"

cd "${homedir}"

logDoneMsg "${ACTIVITY}"
