##############################################################################################################
##    Script Name    : upgradePMMPropertiesFile.sh                                                          ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 04/24/2013                                                                           ##
##    Usage          : ./upgradePMMPropertiesFile.sh                                                        ##
##    Purpose        : Script for upgrading cms/conf/pmm.properties.                                        ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## Upgrades conf/pmm.properties.
##

PMM_PROPERTIES_FILE_PATH=/opt/tandbergtv/cms/conf/pmm/pmm.properties
OLD_SPECIFICATION="specification=CableLabsVOD1.1"
NEW_SPECIFICATION="specification=ECMF"

ACTIVITY="upgrading PMM_PROPERTIES_FILE_PATH=$PMM_PROPERTIES_FILE_PATH"

logBeginMsg "$ACTIVITY"

sed -i$UPGRADED_FILE_SUFFIX 's/$OLD_SPECIFICATION/$NEW_SPECIFICATION/g;s/tns://g' $PMM_PROPERTIES_FILE_PATH

echo >> $PMM_PROPERTIES_FILE_PATH

if ! grep -qe "^\s*derivedAssets=/content/derived\s*$" $PMM_PROPERTIES_FILE_PATH; then
    echo "derivedAssets=/content/derived" >> $PMM_PROPERTIES_FILE_PATH
    logMsg "Added property derivedAssets=/content/derived to $PMM_PROPERTIES_FILE_PATH"
else
    logMsg "derivedAssets=/content/derived property is already there."
fi

if ! grep -qe "^\s*uploadedAssets=/content/uploaded\s*$" $PMM_PROPERTIES_FILE_PATH; then
    echo "uploadedAssets=/content/uploaded" >> $PMM_PROPERTIES_FILE_PATH
    logMsg "Added property uploadedAssets=/content/uploaded to $PMM_PROPERTIES_FILE_PATH"
else
    logMsg "uploadedAssets=/content/uploaded property is already there."
fi

if ! grep -qe "^\s*scheduleExportSpecification=CL1_1\s*$" $PMM_PROPERTIES_FILE_PATH; then
    echo "scheduleExportSpecification=CL1_1" >> $PMM_PROPERTIES_FILE_PATH
    logMsg "Added property scheduleExportSpecification=CL1_1 to $PMM_PROPERTIES_FILE_PATH"
else
    logMsg "scheduleExportSpecification=CL1_1 property is already there."
fi

logDoneMsg "$ACTIVITY"
