##############################################################################################################
##    Script Name    : upgradePermissionsToCMS2_0.sh                                                        ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/30/2013                                                                           ##
##    Usage          : ./upgradePermissionsToCMS2_0.sh                                                      ##
##    Purpose        : Script for upgrading module permissions which are required                           ##
##                         only if upgrading from CMS version 2.0.                                          ##
##############################################################################################################

#!/bin/sh

##
## Upgrade permissions for CMS modules which are required only if upgrading from a CMS version less than 2.0.
##

ACTIVITY="upgrading module permissions for upgrade to CMS version 2.0 or higher"

logBeginMsg "$ACTIVITY"

homedir=$(pwd) 

logMsg "  JAVA: $JAVA"
logMsg "  CLASSPATH: $CLASSPATH"

$JAVA -classpath $CLASSPATH com.ericsson.cms.upgrade.PermissionsManager $*


cd $homedir

logDoneMsg "$ACTIVITY"
