##############################################################################################################
##    Script Name    : upgradeSpecPlugins.sh                                                                ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 03/26/2013                                                                           ##
##    Usage          : ./upgradeSpecPlugins.sh                                                              ##
##    Purpose        : Script for upgrading spec plugins.                                                   ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## Upgrade specification plugins.
##

ACTIVITY="upgrading spec plugins"

logBeginMsg "$ACTIVITY"

SPEC_PLUGIN_PATH_CABLELABS11=/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.cablelabsvod11
SPEC_PLUGIN_PATH_MSTV2=/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.mstv2
SPEC_PLUGIN_PATH_OPENSTREAMVOD=/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.openstreamvod

homedir=$(pwd) 

logMsg "  JAVA: $JAVA"
logMsg "  CLASSPATH: $CLASSPATH"

SUB_ACTIVITY="upgrading spec plugin"

logMsg "$SUB_ACTIVITY $SPEC_PLUGIN_PATH_CABLELABS11"

$JAVA -classpath $CLASSPATH com.ericsson.cms.upgrade.SpecPluginUpdater $SPEC_PLUGIN_PATH_CABLELABS11

logMsg "done $SUB_ACTIVITY $SPEC_PLUGIN_PATH_CABLELABS11"

if [ -d "$SPEC_PLUGIN_PATH_MSTV2" ]; then
    logMsg "$SUB_ACTIVITY $SPEC_PLUGIN_PATH_MSTV2"

    $JAVA -classpath $CLASSPATH com.ericsson.cms.upgrade.SpecPluginUpdater $SPEC_PLUGIN_PATH_MSTV2

    logMsg "done $SUB_ACTIVITY $SPEC_PLUGIN_PATH_MSTV2"
else
    logMsg "Spec Plugin $SPEC_PLUGIN_PATH_MSTV2 does not exist. No upgrade required..." 
fi

if [ -d "$SPEC_PLUGIN_PATH_OPENSTREAMVOD" ]; then
    logMsg "$SUB_ACTIVITY $SPEC_PLUGIN_PATH_OPENSTREAMVOD"

    $JAVA -classpath $CLASSPATH com.ericsson.cms.upgrade.SpecPluginUpdater $SPEC_PLUGIN_PATH_OPENSTREAMVOD

    logMsg "done $SUB_ACTIVITY $SPEC_PLUGIN_PATH_OPENSTREAMVOD"
else
    logMsg "Spec Plugin $SPEC_PLUGIN_PATH_OPENSTREAMVOD does not exist. No upgrade required..." 
fi

cd $homedir

logDoneMsg "$ACTIVITY"
